/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.groupconcat;

import com.blazebit.persistence.impl.function.Order;
import com.blazebit.persistence.impl.function.groupconcat.AbstractGroupConcatFunction;
import com.blazebit.persistence.parser.util.TypeUtils;
import com.blazebit.persistence.spi.FunctionRenderContext;
import java.util.List;

public class PostgreSQLGroupConcatFunction
extends AbstractGroupConcatFunction {
    public PostgreSQLGroupConcatFunction() {
        super("string_agg(?1)");
    }

    @Override
    public void render(FunctionRenderContext context, AbstractGroupConcatFunction.GroupConcat groupConcat) {
        StringBuilder sb = new StringBuilder();
        if (groupConcat.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(groupConcat.getExpression());
        sb.append(", ");
        TypeUtils.STRING_CONVERTER.appendTo((Object)groupConcat.getSeparator(), sb);
        List<Order> orderBys = groupConcat.getOrderBys();
        if (!orderBys.isEmpty()) {
            sb.append(" order by ");
            this.render(sb, orderBys.get(0));
            for (int i = 1; i < orderBys.size(); ++i) {
                sb.append(", ");
                this.render(sb, orderBys.get(i));
            }
        }
        this.renderer.start(context).addParameter(sb.toString()).build();
    }
}

