/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.tomultiset;

import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.function.tostringjson.AbstractToStringJsonFunction;
import com.blazebit.persistence.impl.function.tostringxml.AbstractToStringXmlFunction;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.expression.Subquery;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionProcessor;
import java.util.List;

public class ToMultisetFunction
implements JpqlFunction,
JpqlFunctionProcessor<CharSequence> {
    public static final String FUNCTION_NAME = "to_multiset";
    private final AbstractToStringJsonFunction toJsonFunction;
    private final AbstractToStringXmlFunction toXmlFunction;

    public ToMultisetFunction(AbstractToStringJsonFunction toJsonFunction, AbstractToStringXmlFunction toXmlFunction) {
        this.toJsonFunction = toJsonFunction;
        this.toXmlFunction = toXmlFunction;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return String.class;
    }

    public Object process(CharSequence result, List<Object> arguments) {
        SubqueryExpression subqueryExpression = (SubqueryExpression)arguments.get(0);
        Subquery subquery = subqueryExpression.getSubquery();
        if (!(subquery instanceof SubqueryInternalBuilder)) {
            throw new IllegalArgumentException("Can't handle: " + subquery);
        }
        String[] fields = ToMultisetFunction.createFields(((SubqueryInternalBuilder)subquery).getSelectExpressions().size());
        if (this.toJsonFunction == null) {
            return this.toXmlFunction.process(result, fields);
        }
        return this.toJsonFunction.process(result, fields);
    }

    public void render(FunctionRenderContext context) {
        if (context.getArgumentsSize() != 1) {
            throw new RuntimeException("The to_multiset function needs exactly one argument <subquery>! args=" + context);
        }
        String subquery = context.getArgument(0);
        int fromIndex = SqlUtils.indexOfFrom(subquery, 1);
        String[] selectItemExpressions = subquery.startsWith("(select * from (") ? SqlUtils.getSelectItemAliases(subquery, SqlUtils.SELECT_FINDER.indexIn(subquery, "(select * from (".length())) : SqlUtils.getSelectItemExpressions(subquery, SqlUtils.SELECT_FINDER.indexIn(subquery, 1));
        String[] fields = ToMultisetFunction.createFields(selectItemExpressions.length);
        if (this.toJsonFunction == null) {
            this.toXmlFunction.render(context, fields, selectItemExpressions, subquery, fromIndex);
        } else {
            this.toJsonFunction.render(context, fields, selectItemExpressions, subquery, fromIndex);
        }
    }

    private static String[] createFields(int length) {
        String[] fields = new String[length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = "f" + i;
        }
        return fields;
    }
}

