/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.List;

public abstract class AbortableVisitorAdapter
implements Expression.ResultVisitor<Boolean> {
    @Override
    public Boolean visit(PathExpression expression) {
        List<PathElementExpression> expressions = expression.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (!expressions.get(i).accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(ArrayExpression expression) {
        if (expression.getBase().accept(this).booleanValue()) {
            return true;
        }
        return expression.getIndex().accept(this);
    }

    @Override
    public Boolean visit(TreatExpression expression) {
        return expression.getExpression().accept(this);
    }

    @Override
    public Boolean visit(PropertyExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(ParameterExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(ListIndexExpression expression) {
        return expression.getPath().accept(this);
    }

    @Override
    public Boolean visit(MapEntryExpression expression) {
        return expression.getPath().accept(this);
    }

    @Override
    public Boolean visit(MapKeyExpression expression) {
        return expression.getPath().accept(this);
    }

    @Override
    public Boolean visit(MapValueExpression expression) {
        return expression.getPath().accept(this);
    }

    @Override
    public Boolean visit(NullExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(SubqueryExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(FunctionExpression expression) {
        List<Expression> expressions = expression.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (!expressions.get(i).accept(this).booleanValue()) continue;
            return true;
        }
        WindowDefinition windowDefinition = expression.getWindowDefinition();
        if (windowDefinition != null) {
            Predicate filterPredicate = windowDefinition.getFilterPredicate();
            if (filterPredicate != null && filterPredicate.accept(this).booleanValue()) {
                return true;
            }
            List<Expression> partitionExpressions = windowDefinition.getPartitionExpressions();
            size = partitionExpressions.size();
            for (int i = 0; i < size; ++i) {
                if (!partitionExpressions.get(i).accept(this).booleanValue()) continue;
                return true;
            }
            List<OrderByItem> orderByExpressions = windowDefinition.getOrderByExpressions();
            size = orderByExpressions.size();
            for (int i = 0; i < size; ++i) {
                if (!orderByExpressions.get(i).getExpression().accept(this).booleanValue()) continue;
                return true;
            }
            Expression frameStartExpression = windowDefinition.getFrameStartExpression();
            if (frameStartExpression != null && frameStartExpression.accept(this).booleanValue()) {
                return true;
            }
            Expression frameEndExpression = windowDefinition.getFrameEndExpression();
            if (frameEndExpression != null && frameEndExpression.accept(this).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean visit(TypeFunctionExpression expression) {
        return this.visit((FunctionExpression)expression);
    }

    @Override
    public Boolean visit(TrimExpression expression) {
        if (expression.getTrimCharacter() != null && expression.getTrimCharacter().accept(this).booleanValue()) {
            return true;
        }
        return expression.getTrimSource().accept(this);
    }

    @Override
    public Boolean visit(GeneralCaseExpression expression) {
        List<WhenClauseExpression> expressions = expression.getWhenClauses();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (!expressions.get(i).accept(this).booleanValue()) continue;
            return true;
        }
        if (expression.getDefaultExpr() != null) {
            return expression.getDefaultExpr().accept(this);
        }
        return false;
    }

    @Override
    public Boolean visit(SimpleCaseExpression expression) {
        if (expression.getCaseOperand().accept(this).booleanValue()) {
            return true;
        }
        return this.visit((GeneralCaseExpression)expression);
    }

    @Override
    public Boolean visit(WhenClauseExpression expression) {
        if (expression.getCondition().accept(this).booleanValue()) {
            return true;
        }
        return expression.getResult().accept(this);
    }

    @Override
    public Boolean visit(ArithmeticExpression expression) {
        if (expression.getLeft().accept(this).booleanValue()) {
            return true;
        }
        if (expression.getRight().accept(this).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(ArithmeticFactor expression) {
        return expression.getExpression().accept(this);
    }

    @Override
    public Boolean visit(NumericLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(BooleanLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(StringLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(DateLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(TimeLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(TimestampLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(EnumLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(EntityLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(CompoundPredicate predicate) {
        List<Predicate> children = predicate.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            if (!children.get(i).accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(EqPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(IsNullPredicate predicate) {
        return predicate.getExpression().accept(this);
    }

    @Override
    public Boolean visit(IsEmptyPredicate predicate) {
        return predicate.getExpression().accept(this);
    }

    @Override
    public Boolean visit(MemberOfPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(LikePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(BetweenPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        if (predicate.getStart().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getEnd().accept(this);
    }

    @Override
    public Boolean visit(InPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        for (Expression right : predicate.getRight()) {
            if (!right.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(GtPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(GePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(LtPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(LePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    protected Boolean visit(BinaryExpressionPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(ExistsPredicate predicate) {
        return predicate.getExpression().accept(this);
    }
}

