/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AggregateExpression
extends FunctionExpression {
    private boolean distinct;

    public AggregateExpression(boolean distinct, String functionName, List<Expression> expressions) {
        super(functionName, expressions);
        this.distinct = distinct;
    }

    public AggregateExpression(boolean distinct, String functionName, List<Expression> expressions, Predicate filterPredicate) {
        super(functionName, expressions, filterPredicate == null ? null : new WindowDefinition(null, filterPredicate));
        this.distinct = distinct;
    }

    @Override
    public AggregateExpression copy(ExpressionCopyContext copyContext) {
        List<Expression> newExpressions;
        int size = this.expressions.size();
        if (size == 0) {
            newExpressions = Collections.emptyList();
        } else {
            newExpressions = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                newExpressions.add(((Expression)this.expressions.get(i)).copy(copyContext));
            }
        }
        return new AggregateExpression(this.distinct, this.functionName, newExpressions, this.windowDefinition == null ? null : this.windowDefinition.getFilterPredicate().copy(copyContext));
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }
}

