/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.expression.modifier.ArithmeticFactorExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.ArithmeticLeftExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.ArithmeticRightExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.ArrayExpressionBaseModifier;
import com.blazebit.persistence.parser.expression.modifier.ArrayExpressionIndexModifier;
import com.blazebit.persistence.parser.expression.modifier.BetweenPredicateEndModifier;
import com.blazebit.persistence.parser.expression.modifier.BetweenPredicateLeftModifier;
import com.blazebit.persistence.parser.expression.modifier.BetweenPredicateStartModifier;
import com.blazebit.persistence.parser.expression.modifier.BinaryExpressionPredicateLeftModifier;
import com.blazebit.persistence.parser.expression.modifier.BinaryExpressionPredicateRightModifier;
import com.blazebit.persistence.parser.expression.modifier.ExpressionListModifier;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.GeneralCaseExpressionDefaultModifier;
import com.blazebit.persistence.parser.expression.modifier.InPredicateLeftModifier;
import com.blazebit.persistence.parser.expression.modifier.ListIndexExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.MapEntryExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.MapKeyExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.MapValueExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.OrderByItemModifier;
import com.blazebit.persistence.parser.expression.modifier.SimpleCaseExpressionOperandModifier;
import com.blazebit.persistence.parser.expression.modifier.TreatExpressionModifier;
import com.blazebit.persistence.parser.expression.modifier.TrimExpressionCharacterModifier;
import com.blazebit.persistence.parser.expression.modifier.TrimExpressionSourceModifier;
import com.blazebit.persistence.parser.expression.modifier.UnaryExpressionPredicateModifier;
import com.blazebit.persistence.parser.expression.modifier.WhenClauseExpressionConditionModifier;
import com.blazebit.persistence.parser.expression.modifier.WhenClauseExpressionResultModifier;
import com.blazebit.persistence.parser.expression.modifier.WindowFilterModifier;
import com.blazebit.persistence.parser.expression.modifier.WindowFrameEndModifier;
import com.blazebit.persistence.parser.expression.modifier.WindowFrameStartModifier;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.UnaryExpressionPredicate;
import java.util.List;

public abstract class ExpressionModifierCollectingResultVisitorAdapter
implements Expression.ResultVisitor<Boolean> {
    protected abstract void onModifier(ExpressionModifier var1);

    public void visit(ExpressionModifier parentModifier) {
        if (Boolean.TRUE == parentModifier.get().accept(this)) {
            this.onModifier(parentModifier);
        }
    }

    @Override
    public Boolean visit(ArrayExpression expression) {
        if (Boolean.TRUE == expression.getBase().accept(this)) {
            this.onModifier(new ArrayExpressionBaseModifier(expression));
        }
        if (Boolean.TRUE == expression.getIndex().accept(this)) {
            this.onModifier(new ArrayExpressionIndexModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(TreatExpression expression) {
        if (Boolean.TRUE == expression.getExpression().accept(this)) {
            this.onModifier(new TreatExpressionModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(PropertyExpression expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(ParameterExpression expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(ListIndexExpression expression) {
        if (Boolean.TRUE == expression.getPath().accept(this)) {
            this.onModifier(new ListIndexExpressionModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(MapEntryExpression expression) {
        if (Boolean.TRUE == expression.getPath().accept(this)) {
            this.onModifier(new MapEntryExpressionModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(MapKeyExpression expression) {
        if (Boolean.TRUE == expression.getPath().accept(this)) {
            this.onModifier(new MapKeyExpressionModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(MapValueExpression expression) {
        if (Boolean.TRUE == expression.getPath().accept(this)) {
            this.onModifier(new MapValueExpressionModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(NullExpression expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(SubqueryExpression expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(FunctionExpression expression) {
        List<Expression> expressions = expression.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (Boolean.TRUE != expressions.get(i).accept(this)) continue;
            this.onModifier(new ExpressionListModifier(expressions, i));
        }
        WindowDefinition windowDefinition = expression.getWindowDefinition();
        if (windowDefinition != null) {
            Expression frameEndExpression;
            Predicate filterPredicate = windowDefinition.getFilterPredicate();
            if (filterPredicate != null && Boolean.TRUE == filterPredicate.accept(this)) {
                this.onModifier(new WindowFilterModifier(windowDefinition));
            }
            List<Expression> partitionExpressions = windowDefinition.getPartitionExpressions();
            size = partitionExpressions.size();
            for (int i = 0; i < size; ++i) {
                if (Boolean.TRUE != partitionExpressions.get(i).accept(this)) continue;
                this.onModifier(new ExpressionListModifier(partitionExpressions, i));
            }
            List<OrderByItem> orderByExpressions = windowDefinition.getOrderByExpressions();
            size = orderByExpressions.size();
            for (int i = 0; i < size; ++i) {
                if (Boolean.TRUE != orderByExpressions.get(i).getExpression().accept(this)) continue;
                this.onModifier(new OrderByItemModifier(orderByExpressions.get(i)));
            }
            Expression frameStartExpression = windowDefinition.getFrameStartExpression();
            if (frameStartExpression != null && Boolean.TRUE == frameStartExpression.accept(this)) {
                this.onModifier(new WindowFrameStartModifier(windowDefinition));
            }
            if ((frameEndExpression = windowDefinition.getFrameEndExpression()) != null && Boolean.TRUE == frameEndExpression.accept(this)) {
                this.onModifier(new WindowFrameEndModifier(windowDefinition));
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(TypeFunctionExpression expression) {
        return this.visit((FunctionExpression)expression);
    }

    @Override
    public Boolean visit(TrimExpression expression) {
        Expression trimCharacter;
        if (Boolean.TRUE == expression.getTrimSource().accept(this)) {
            this.onModifier(new TrimExpressionSourceModifier(expression));
        }
        if ((trimCharacter = expression.getTrimCharacter()) != null && Boolean.TRUE == trimCharacter.accept(this)) {
            this.onModifier(new TrimExpressionCharacterModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(WhenClauseExpression expression) {
        if (Boolean.TRUE == expression.getCondition().accept(this)) {
            this.onModifier(new WhenClauseExpressionConditionModifier(expression));
        }
        if (Boolean.TRUE == expression.getResult().accept(this)) {
            this.onModifier(new WhenClauseExpressionResultModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(GeneralCaseExpression expression) {
        List<WhenClauseExpression> expressions = expression.getWhenClauses();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (Boolean.TRUE != expressions.get(i).accept(this)) continue;
            this.onModifier(new ExpressionListModifier(expressions, i));
        }
        if (expression.getDefaultExpr() != null && Boolean.TRUE == expression.getDefaultExpr().accept(this)) {
            this.onModifier(new GeneralCaseExpressionDefaultModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(SimpleCaseExpression expression) {
        if (Boolean.TRUE == expression.getCaseOperand().accept(this)) {
            this.onModifier(new SimpleCaseExpressionOperandModifier(expression));
        }
        return this.visit((GeneralCaseExpression)expression);
    }

    @Override
    public Boolean visit(PathExpression expression) {
        List<PathElementExpression> expressions = expression.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (Boolean.TRUE != expressions.get(i).accept(this)) continue;
            this.onModifier(new ExpressionListModifier(expressions, i));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(ArithmeticExpression expression) {
        if (Boolean.TRUE == expression.getLeft().accept(this)) {
            this.onModifier(new ArithmeticLeftExpressionModifier(expression));
        }
        if (Boolean.TRUE == expression.getRight().accept(this)) {
            this.onModifier(new ArithmeticRightExpressionModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(ArithmeticFactor expression) {
        if (Boolean.TRUE == expression.getExpression().accept(this)) {
            this.onModifier(new ArithmeticFactorExpressionModifier(expression));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(NumericLiteral expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(BooleanLiteral expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(StringLiteral expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(DateLiteral expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(TimeLiteral expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(TimestampLiteral expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(EnumLiteral expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(EntityLiteral expression) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(CompoundPredicate predicate) {
        List<Predicate> predicates = predicate.getChildren();
        int size = predicates.size();
        for (int i = 0; i < size; ++i) {
            if (Boolean.TRUE != predicates.get(i).accept(this)) continue;
            this.onModifier(new ExpressionListModifier(predicates, i));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(EqPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(IsNullPredicate predicate) {
        return this.visit((UnaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(IsEmptyPredicate predicate) {
        return this.visit((UnaryExpressionPredicate)predicate);
    }

    private Boolean visit(UnaryExpressionPredicate predicate) {
        if (Boolean.TRUE == predicate.getExpression().accept(this)) {
            this.onModifier(new UnaryExpressionPredicateModifier(predicate));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(MemberOfPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(LikePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(BetweenPredicate predicate) {
        if (Boolean.TRUE == predicate.getLeft().accept(this)) {
            this.onModifier(new BetweenPredicateLeftModifier(predicate));
        }
        if (Boolean.TRUE == predicate.getStart().accept(this)) {
            this.onModifier(new BetweenPredicateStartModifier(predicate));
        }
        if (Boolean.TRUE == predicate.getEnd().accept(this)) {
            this.onModifier(new BetweenPredicateEndModifier(predicate));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(InPredicate predicate) {
        if (Boolean.TRUE == predicate.getLeft().accept(this)) {
            this.onModifier(new InPredicateLeftModifier(predicate));
        }
        List<Expression> expressions = predicate.getRight();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (Boolean.TRUE != expressions.get(i).accept(this)) continue;
            this.onModifier(new ExpressionListModifier(expressions, i));
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(GtPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(GePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(LtPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(LePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Boolean visit(ExistsPredicate predicate) {
        return this.visit((UnaryExpressionPredicate)predicate);
    }

    private Boolean visit(BinaryExpressionPredicate predicate) {
        if (Boolean.TRUE == predicate.getLeft().accept(this)) {
            this.onModifier(new BinaryExpressionPredicateLeftModifier(predicate));
        }
        if (Boolean.TRUE == predicate.getRight().accept(this)) {
            this.onModifier(new BinaryExpressionPredicateRightModifier(predicate));
        }
        return Boolean.FALSE;
    }
}

