/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.List;

public abstract class InplaceModificationResultVisitorAdapter
implements Expression.ResultVisitor<Expression> {
    @Override
    public Expression visit(ArrayExpression expression) {
        expression.setBase(expression.getBase().accept(this));
        expression.setIndex(expression.getIndex().accept(this));
        return expression;
    }

    @Override
    public Expression visit(TreatExpression expression) {
        expression.setExpression(expression.getExpression().accept(this));
        return expression;
    }

    @Override
    public Expression visit(PropertyExpression expression) {
        return expression;
    }

    @Override
    public Expression visit(ParameterExpression expression) {
        return expression;
    }

    @Override
    public Expression visit(ListIndexExpression expression) {
        expression.setPath((PathExpression)expression.getPath().accept(this));
        return expression;
    }

    @Override
    public Expression visit(MapEntryExpression expression) {
        expression.setPath((PathExpression)expression.getPath().accept(this));
        return expression;
    }

    @Override
    public Expression visit(MapKeyExpression expression) {
        expression.setPath((PathExpression)expression.getPath().accept(this));
        return expression;
    }

    @Override
    public Expression visit(MapValueExpression expression) {
        expression.setPath((PathExpression)expression.getPath().accept(this));
        return expression;
    }

    @Override
    public Expression visit(NullExpression expression) {
        return expression;
    }

    @Override
    public Expression visit(SubqueryExpression expression) {
        return expression;
    }

    @Override
    public Expression visit(FunctionExpression expression) {
        List<Expression> expressions = expression.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            expressions.set(i, expressions.get(i).accept(this));
        }
        WindowDefinition windowDefinition = expression.getWindowDefinition();
        if (windowDefinition != null) {
            Expression frameEndExpression;
            Predicate filterPredicate = windowDefinition.getFilterPredicate();
            if (filterPredicate != null) {
                windowDefinition.setFilterPredicate((Predicate)filterPredicate.accept(this));
            }
            List<Expression> partitionExpressions = windowDefinition.getPartitionExpressions();
            size = partitionExpressions.size();
            for (int i = 0; i < size; ++i) {
                partitionExpressions.set(i, partitionExpressions.get(i).accept(this));
            }
            List<OrderByItem> orderByExpressions = windowDefinition.getOrderByExpressions();
            size = orderByExpressions.size();
            for (int i = 0; i < size; ++i) {
                orderByExpressions.get(i).setExpression(orderByExpressions.get(i).getExpression().accept(this));
            }
            Expression frameStartExpression = windowDefinition.getFrameStartExpression();
            if (frameStartExpression != null) {
                windowDefinition.setFrameStartExpression(frameStartExpression.accept(this));
            }
            if ((frameEndExpression = windowDefinition.getFrameEndExpression()) != null) {
                windowDefinition.setFrameEndExpression(frameEndExpression.accept(this));
            }
        }
        return expression;
    }

    @Override
    public Expression visit(TypeFunctionExpression expression) {
        return this.visit((FunctionExpression)expression);
    }

    @Override
    public Expression visit(TrimExpression expression) {
        expression.setTrimSource(expression.getTrimSource().accept(this));
        if (expression.getTrimCharacter() != null) {
            expression.setTrimCharacter(expression.getTrimCharacter().accept(this));
        }
        return expression;
    }

    @Override
    public Expression visit(WhenClauseExpression expression) {
        expression.setCondition(expression.getCondition().accept(this));
        expression.setResult(expression.getResult().accept(this));
        return expression;
    }

    @Override
    public Expression visit(GeneralCaseExpression expression) {
        List<WhenClauseExpression> expressions = expression.getWhenClauses();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            expressions.set(i, (WhenClauseExpression)expressions.get(i).accept(this));
        }
        if (expression.getDefaultExpr() != null) {
            expression.setDefaultExpr(expression.getDefaultExpr().accept(this));
        }
        return expression;
    }

    @Override
    public Expression visit(SimpleCaseExpression expression) {
        expression.setCaseOperand(expression.getCaseOperand().accept(this));
        return this.visit((GeneralCaseExpression)expression);
    }

    @Override
    public Expression visit(PathExpression expression) {
        List<PathElementExpression> expressions = expression.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            expressions.set(i, (PathElementExpression)expressions.get(i).accept(this));
        }
        return expression;
    }

    @Override
    public Expression visit(ArithmeticExpression expression) {
        expression.setLeft(expression.getLeft().accept(this));
        expression.setRight(expression.getRight().accept(this));
        return expression;
    }

    @Override
    public Expression visit(ArithmeticFactor expression) {
        expression.setExpression(expression.getExpression().accept(this));
        return expression;
    }

    @Override
    public Expression visit(NumericLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(BooleanLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(StringLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(DateLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(TimeLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(TimestampLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(EnumLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(EntityLiteral expression) {
        return expression;
    }

    @Override
    public Expression visit(CompoundPredicate predicate) {
        List<Predicate> predicates = predicate.getChildren();
        int size = predicates.size();
        for (int i = 0; i < size; ++i) {
            predicates.set(i, (Predicate)predicates.get(i).accept(this));
        }
        return predicate;
    }

    @Override
    public Expression visit(EqPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Expression visit(IsNullPredicate predicate) {
        predicate.setExpression(predicate.getExpression().accept(this));
        return predicate;
    }

    @Override
    public Expression visit(IsEmptyPredicate predicate) {
        predicate.setExpression(predicate.getExpression().accept(this));
        return predicate;
    }

    @Override
    public Expression visit(MemberOfPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Expression visit(LikePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Expression visit(BetweenPredicate predicate) {
        predicate.setLeft(predicate.getLeft().accept(this));
        predicate.setStart(predicate.getStart().accept(this));
        predicate.setEnd(predicate.getEnd().accept(this));
        return predicate;
    }

    @Override
    public Expression visit(InPredicate predicate) {
        predicate.setLeft(predicate.getLeft().accept(this));
        List<Expression> expressions = predicate.getRight();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            expressions.set(i, expressions.get(i).accept(this));
        }
        return predicate;
    }

    @Override
    public Expression visit(GtPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Expression visit(GePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Expression visit(LtPredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Expression visit(LePredicate predicate) {
        return this.visit((BinaryExpressionPredicate)predicate);
    }

    @Override
    public Expression visit(ExistsPredicate predicate) {
        predicate.setExpression(predicate.getExpression().accept(this));
        return predicate;
    }

    private BinaryExpressionPredicate visit(BinaryExpressionPredicate predicate) {
        predicate.setLeft(predicate.getLeft().accept(this));
        predicate.setRight(predicate.getRight().accept(this));
        return predicate;
    }
}

