/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.predicate;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.predicate.BinaryExpressionPredicate;

public class LikePredicate
extends BinaryExpressionPredicate {
    private final boolean caseSensitive;
    private Expression escapeCharacter;

    public LikePredicate(Expression left, Expression right, boolean caseSensitive, Character escapeCharacter) {
        this(left, right, caseSensitive, escapeCharacter == null ? null : new StringLiteral(escapeCharacter.toString()), false);
    }

    public LikePredicate(Expression left, Expression right, boolean caseSensitive, Expression escapeCharacter) {
        this(left, right, caseSensitive, escapeCharacter, false);
    }

    public LikePredicate(Expression left, Expression right, boolean caseSensitive, Character escapeCharacter, boolean negated) {
        this(left, right, caseSensitive, escapeCharacter == null ? null : new StringLiteral(escapeCharacter.toString()), negated);
    }

    public LikePredicate(Expression left, Expression right, boolean caseSensitive, Expression escapeCharacter, boolean negated) {
        super(left, right, negated);
        this.caseSensitive = caseSensitive;
        this.escapeCharacter = escapeCharacter;
    }

    @Override
    public LikePredicate copy(ExpressionCopyContext copyContext) {
        return new LikePredicate(this.left.copy(copyContext), this.right.copy(copyContext), this.caseSensitive, this.escapeCharacter, this.negated);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Expression getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setEscapeCharacter(Expression escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LikePredicate)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LikePredicate that = (LikePredicate)o;
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        return this.escapeCharacter != null ? this.escapeCharacter.equals(that.escapeCharacter) : that.escapeCharacter == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        result = 31 * result + (this.escapeCharacter != null ? this.escapeCharacter.hashCode() : 0);
        return result;
    }
}

