/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class LocalDateTimeTypeConverter
extends TypeUtils.AbstractLiteralFunctionTypeConverter<LocalDateTime> {
    public static final TypeConverter<?> INSTANCE = new LocalDateTimeTypeConverter();
    private static final long serialVersionUID = 1L;

    private LocalDateTimeTypeConverter() {
        super("literal_local_date_time");
    }

    @Override
    public LocalDateTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        if (value instanceof String) {
            return LocalDateTime.ofInstant(Timestamp.valueOf((String)value).toInstant(), ZoneId.systemDefault());
        }
        throw LocalDateTimeTypeConverter.unknownConversion(value, LocalDateTime.class);
    }

    @Override
    public String toString(LocalDateTime value) {
        return TypeUtils.jdbcTimestamp(value.getYear(), value.getMonthValue(), value.getDayOfMonth(), value.getHour(), value.getMinute(), value.getSecond(), value.getNano());
    }

    @Override
    public void appendTo(LocalDateTime value, StringBuilder stringBuilder) {
        TypeUtils.appendJdbcTimestamp(stringBuilder, value.getYear(), value.getMonthValue(), value.getDayOfMonth(), value.getHour(), value.getMinute(), value.getSecond(), value.getNano());
    }
}

