/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.MacroFunction;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PrefixingQueryGenerator
extends SimpleQueryGenerator {
    private static final Set<String> DEFAULT_QUERY_ALIASES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("correlationEmbeddingViewAlias_", "correlationViewRootAlias_")));
    private static final Set<String> MACROS = new HashSet<String>(Arrays.asList("VIEW", "VIEW_ROOT", "EMBEDDING_VIEW"));
    private final ExpressionFactory expressionFactory;
    private final String prefix;
    private final String substitute;
    private final String aliasToReplace;
    private final Set<String> queryAliases;
    private final boolean expandMacros;
    private final boolean fromEmbeddingViewScope;
    private boolean doPrefix = true;

    public PrefixingQueryGenerator(ExpressionFactory ef, String prefix, String substitute, String aliasToReplace, Set<String> queryAliases, boolean expandMacros, boolean fromEmbeddingViewScope) {
        this.expressionFactory = ef;
        this.prefix = prefix;
        this.substitute = substitute;
        this.expandMacros = expandMacros;
        this.fromEmbeddingViewScope = fromEmbeddingViewScope;
        this.aliasToReplace = aliasToReplace;
        this.queryAliases = new HashSet<String>(queryAliases);
        this.queryAliases.addAll(DEFAULT_QUERY_ALIASES);
    }

    public static String prefix(ExpressionFactory ef, Expression expression, String prefix, Set<String> queryAliases, boolean fromEmbeddingViewScope) {
        PrefixingQueryGenerator generator = new PrefixingQueryGenerator(ef, prefix, null, null, queryAliases, !fromEmbeddingViewScope, fromEmbeddingViewScope);
        StringBuilder sb = new StringBuilder(20 + prefix.length());
        generator.setQueryBuffer(sb);
        expression.accept((Expression.Visitor)generator);
        return sb.toString();
    }

    public void visit(ArrayExpression expression) {
        expression.getBase().accept((Expression.Visitor)this);
        this.sb.append('[');
        if (expression.getIndex() instanceof Predicate) {
            boolean doPrefix = this.doPrefix;
            try {
                this.doPrefix = false;
                expression.getIndex().accept((Expression.Visitor)this);
            }
            finally {
                this.doPrefix = doPrefix;
            }
        } else {
            expression.getIndex().accept((Expression.Visitor)this);
        }
        this.sb.append(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FunctionExpression expression) {
        String macroName;
        List expressions = expression.getExpressions();
        if (ExpressionUtils.isCustomFunctionInvocation((FunctionExpression)expression) && MACROS.contains((macroName = ((StringLiteral)expressions.get(0)).getValue()).toUpperCase())) {
            if (this.expandMacros) {
                MacroFunction macroFunction = this.expressionFactory.getDefaultMacroConfiguration().get(macroName);
                Expression expandedExpression = macroFunction.apply(expressions.subList(1, expressions.size()));
                boolean doPrefix = this.doPrefix;
                try {
                    this.doPrefix = false;
                    expandedExpression.accept((Expression.Visitor)this);
                }
                finally {
                    this.doPrefix = doPrefix;
                }
            } else {
                if (this.fromEmbeddingViewScope) {
                    if ("EMBEDDING_VIEW".equalsIgnoreCase(macroName)) {
                        throw new IllegalArgumentException("Illegal use of EMBEDDING_VIEW!");
                    }
                    if ("VIEW".equalsIgnoreCase(macroName)) {
                        this.sb.append("EMBEDDING_VIEW");
                    } else {
                        this.sb.append(macroName);
                    }
                } else {
                    this.sb.append(macroName);
                }
                this.sb.append('(');
                int size = expressions.size();
                if (size > 1) {
                    ((Expression)expressions.get(1)).accept((Expression.Visitor)this);
                    for (int i = 2; i < size; ++i) {
                        this.sb.append(",");
                        ((Expression)expressions.get(i)).accept((Expression.Visitor)this);
                    }
                }
                this.sb.append(')');
            }
        } else {
            super.visit(expression);
        }
    }

    public void visit(PathExpression expression) {
        List expressions = expression.getExpressions();
        if (expressions.isEmpty()) {
            this.sb.append(this.prefix);
        } else {
            PathElementExpression firstElement = (PathElementExpression)expressions.get(0);
            String firstProperty = firstElement instanceof PropertyExpression ? ((PropertyExpression)firstElement).getProperty() : null;
            int size = expressions.size();
            if (!this.doPrefix || this.queryAliases.contains(firstProperty)) {
                super.visit(expression);
                return;
            }
            if (this.aliasToReplace != null && this.aliasToReplace.equals(firstProperty)) {
                this.sb.append(this.substitute);
                for (int i = 1; i < size; ++i) {
                    this.sb.append(".");
                    ((PathElementExpression)expressions.get(i)).accept((Expression.Visitor)this);
                }
                return;
            }
            if (firstElement instanceof ArrayExpression && ((ArrayExpression)firstElement).getBase() instanceof EntityLiteral) {
                super.visit(expression);
                return;
            }
            if (!(firstElement instanceof TreatExpression)) {
                String expressionString = expression.toString();
                int dotIndex = -1;
                int length = Math.min(this.prefix.length(), expressionString.length());
                block1: for (int i = 0; i < length; ++i) {
                    if (this.prefix.charAt(i) == expressionString.charAt(i)) continue;
                    while (i > 0) {
                        if (this.prefix.charAt(i) == '.' && expressionString.charAt(i) == '.') {
                            dotIndex = i;
                            break block1;
                        }
                        --i;
                    }
                    break;
                }
                if (!(dotIndex != -1 || this.prefix.isEmpty() || expressionString.length() < this.prefix.length() && this.prefix.charAt(expressionString.length()) == '.' && this.prefix.startsWith(expressionString) || expressionString.length() > this.prefix.length() && expressionString.charAt(this.prefix.length()) == '.' && expressionString.startsWith(this.prefix) || expressionString.equals(this.prefix))) {
                    this.sb.append(this.prefix);
                    this.sb.append('.');
                }
            }
            if ("this".equalsIgnoreCase(firstProperty)) {
                if (size > 1) {
                    for (int i = 1; i < size; ++i) {
                        ((PathElementExpression)expressions.get(i)).accept((Expression.Visitor)this);
                    }
                } else {
                    this.sb.setLength(this.sb.length() - 1);
                }
            } else {
                super.visit(expression);
            }
        }
    }
}

