/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.SubqueryProvider;
import com.blazebit.persistence.view.SubqueryProviderFactory;
import com.blazebit.persistence.view.impl.ParameterizedSubqueryProviderFactory;
import com.blazebit.persistence.view.impl.SimpleSubqueryProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;

public class SubqueryProviderHelper {
    private SubqueryProviderHelper() {
    }

    public static SubqueryProviderFactory getFactory(Class<? extends SubqueryProvider> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> noArgsConstructor = null;
        ParameterizedSubqueryProviderFactory parameterizedSubqueryProviderFactory = null;
        for (int constructorIdx = 0; constructorIdx < constructors.length; ++constructorIdx) {
            Constructor<?> constructor = constructors[constructorIdx];
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            int size = parameterAnnotations.length;
            if (size == 0) {
                noArgsConstructor = constructor;
                continue;
            }
            String[] parameterNames = new String[size];
            boolean hasMappingParameter = false;
            int firstParameterIdxWithoutMappingParameter = -1;
            for (int i = 0; i < size; ++i) {
                Annotation[] annotations = parameterAnnotations[i];
                int annotationsSize = annotations.length;
                for (int j = 0; j < annotationsSize; ++j) {
                    if (annotations[j].annotationType() != MappingParameter.class) continue;
                    hasMappingParameter = true;
                    parameterNames[i] = ((MappingParameter)annotations[j]).value();
                    break;
                }
                if (parameterNames[i] != null) continue;
                firstParameterIdxWithoutMappingParameter = i;
            }
            if (!hasMappingParameter) continue;
            if (firstParameterIdxWithoutMappingParameter >= 0) {
                throw new IllegalArgumentException("Could not find any parameter mapping annotations on constructor parameter at index " + firstParameterIdxWithoutMappingParameter + " of subquery provider: " + clazz.getName());
            }
            parameterizedSubqueryProviderFactory = new ParameterizedSubqueryProviderFactory(constructor, parameterNames);
        }
        if (parameterizedSubqueryProviderFactory != null) {
            return parameterizedSubqueryProviderFactory;
        }
        if (noArgsConstructor != null) {
            return new SimpleSubqueryProviderFactory(clazz);
        }
        throw new IllegalArgumentException("No eligible constructor exists for subquery provider: " + clazz.getName());
    }
}

