/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.accessor;

import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import java.util.List;

public class NestedAttributeAccessor
implements AttributeAccessor {
    private final AttributeAccessor[] accessors;

    NestedAttributeAccessor(List<AttributeAccessor> accessors) {
        this.accessors = accessors.toArray(new AttributeAccessor[accessors.size()]);
    }

    @Override
    public void setValue(Object entity, Object value) {
        if (entity == null || this.accessors.length == 0) {
            return;
        }
        for (int i = 0; i < this.accessors.length - 1; ++i) {
            entity = this.accessors[i].getOrCreateValue(entity);
        }
        this.accessors[this.accessors.length - 1].setValue(entity, value);
    }

    @Override
    public Object getOrCreateValue(Object entity) {
        if (entity == null || this.accessors.length == 0) {
            return entity;
        }
        Object value = entity;
        for (int i = 0; i < this.accessors.length - 1; ++i) {
            value = this.accessors[i].getOrCreateValue(value);
        }
        return this.accessors[this.accessors.length - 1].getValue(value);
    }

    @Override
    public Object getValue(Object entity) {
        if (entity == null || this.accessors.length == 0) {
            return entity;
        }
        Object value = entity;
        for (int i = 0; i < this.accessors.length - 1; ++i) {
            if ((value = this.accessors[i].getValue(value)) != null) continue;
            return null;
        }
        return this.accessors[this.accessors.length - 1].getValue(value);
    }
}

