/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.ListAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ListAddAction<C extends List<E>, E>
implements ListAction<C> {
    private final int index;
    private final boolean append;
    private final E element;

    public ListAddAction(int index, boolean append, E element) {
        this.index = index;
        this.append = append;
        this.element = element;
    }

    @Override
    public void doAction(C list, UpdateContext context, ViewToEntityMapper mapper, CollectionRemoveListener removeListener) {
        if (this.append) {
            if (mapper != null) {
                list.add((Object)mapper.applyToEntity(context, null, this.element));
            } else {
                list.add(this.element);
            }
        } else if (mapper != null) {
            list.add(this.index, (Object)mapper.applyToEntity(context, null, this.element));
        } else {
            list.add(this.index, this.element);
        }
    }

    @Override
    public void undo(C collection, Collection<?> removedObjects, Collection<?> addedObjects) {
        collection.remove(this.index);
    }

    @Override
    public boolean containsObject(C collection, Object o) {
        return o == this.element;
    }

    @Override
    public Collection<Object> getAddedObjects() {
        return Collections.singleton(this.element);
    }

    @Override
    public Collection<Object> getRemovedObjects() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAddedObjects(C collection) {
        if (collection.contains(this.element)) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.element);
    }

    @Override
    public Collection<Object> getRemovedObjects(C collection) {
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getInsertedObjectEntries() {
        if (this.append) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new AbstractMap.SimpleEntry<E, Integer>(this.element, this.index));
    }

    @Override
    public List<Map.Entry<Object, Integer>> getAppendedObjectEntries() {
        if (this.append) {
            return Collections.singletonList(new AbstractMap.SimpleEntry<E, Integer>(this.element, this.index));
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getRemovedObjectEntries() {
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getTrimmedObjectEntries() {
        return Collections.emptyList();
    }

    @Override
    public CollectionAction<C> replaceObject(Object oldElem, Object elem) {
        if (this.element != oldElem) {
            return null;
        }
        return new ListAddAction<C, Object>(this.index, this.append, elem);
    }

    @Override
    public CollectionAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        if (objectMapping == null) {
            return this;
        }
        Object newElement = objectMapping.get(this.element);
        if (newElement == null) {
            return this;
        }
        return new ListAddAction<C, Object>(this.index, this.append, newElement);
    }

    @Override
    public void addAction(RecordingCollection<?, ?> recordingCollection, List<CollectionAction<C>> actions) {
        actions.add(this);
    }
}

