/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.collection.RecordingUtils;
import com.blazebit.persistence.view.impl.entity.MapViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapRemoveAllKeysAction<C extends Map<K, V>, K, V>
implements MapAction<C> {
    private final Collection<?> elements;
    private final Map<K, V> removedObjectsInView;

    public MapRemoveAllKeysAction(Collection<?> elements, Map<K, V> delegate) {
        this.elements = elements;
        this.removedObjectsInView = new LinkedHashMap(elements.size());
        for (Object key : elements) {
            V oldValue = delegate.get(key);
            if (oldValue == null) continue;
            this.removedObjectsInView.put(key, oldValue);
        }
    }

    private MapRemoveAllKeysAction(List<?> elements, Map<K, V> removedObjectsInView) {
        this.elements = elements;
        this.removedObjectsInView = removedObjectsInView;
    }

    public static <C extends Map<K, V>, K, V> MapRemoveAllKeysAction<C, K, V> retainAll(Collection<?> c, C delegate) {
        int size = c.size() >= delegate.size() ? delegate.size() : delegate.size() - c.size();
        LinkedHashMap<K, V> removedObjectsInView = new LinkedHashMap<K, V>(size);
        for (Map.Entry<K, V> entry : delegate.entrySet()) {
            if (c.contains(entry.getKey())) continue;
            removedObjectsInView.put(entry.getKey(), entry.getValue());
        }
        return new MapRemoveAllKeysAction(new ArrayList(removedObjectsInView.keySet()), removedObjectsInView);
    }

    @Override
    public void doAction(C map, UpdateContext context, MapViewToEntityMapper mapper, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener valueRemoveListener) {
        if (mapper != null && mapper.getKeyMapper() != null) {
            if (this.elements.size() == 1) {
                Object e = this.elements.iterator().next();
                Object key = mapper.getKeyMapper().applyToEntity(context, null, e);
                Object value = map.remove(key);
                if (value != null) {
                    if (keyRemoveListener != null) {
                        keyRemoveListener.onCollectionRemove(context, e);
                    }
                    if (valueRemoveListener != null) {
                        valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(e));
                    }
                }
            } else {
                ArrayList<Object> entities = new ArrayList<Object>(this.elements.size());
                entities.addAll(this.elements);
                mapper.getKeyMapper().applyAll(context, entities);
                int i = 0;
                for (Object e : this.elements) {
                    Object key;
                    Object value;
                    if ((value = map.remove(key = entities.get(i++))) == null) continue;
                    if (keyRemoveListener != null) {
                        keyRemoveListener.onCollectionRemove(context, e);
                    }
                    if (valueRemoveListener == null) continue;
                    valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(e));
                }
            }
        } else if (map.size() > 0 && (keyRemoveListener != null || valueRemoveListener != null)) {
            for (Object k : this.elements) {
                Object v = map.remove(k);
                if (v == null) continue;
                if (keyRemoveListener != null) {
                    keyRemoveListener.onCollectionRemove(context, k);
                }
                if (valueRemoveListener == null) continue;
                valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(k));
            }
        } else {
            map.keySet().removeAll(this.elements);
        }
    }

    @Override
    public void undo(C map, Collection<?> removedKeys, Collection<?> addedKeys, Collection<?> removedElements, Collection<?> addedElements) {
        for (Map.Entry<K, V> entry : this.removedObjectsInView.entrySet()) {
            if (!removedKeys.contains(entry.getKey()) && !removedElements.contains(entry.getValue())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Collection<Object> getAddedKeys() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedKeys() {
        return this.removedObjectsInView.keySet();
    }

    @Override
    public Collection<Object> getAddedElements() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedElements() {
        return this.removedObjectsInView.values();
    }

    @Override
    public Collection<Object> getAddedKeys(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedKeys(C collection) {
        ArrayList<Object> removedKeys = new ArrayList<Object>(this.elements.size());
        for (Object o : this.elements) {
            if (!collection.containsKey(o)) continue;
            removedKeys.add(o);
        }
        return removedKeys;
    }

    @Override
    public Collection<Object> getAddedElements(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedElements(C collection) {
        ArrayList<Object> removedElements = new ArrayList<Object>(this.elements.size());
        for (Object o : this.elements) {
            Object value = collection.get(o);
            if (value == null) continue;
            removedElements.add(value);
        }
        return removedElements;
    }

    @Override
    public MapAction<C> replaceObject(Object oldKey, Object oldValue, Object newKey, Object newValue) {
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, oldKey, newKey);
        if (newElements == null) {
            return null;
        }
        return new MapRemoveAllKeysAction<C, K, V>(newElements, this.removedObjectsInView);
    }

    @Override
    public MapAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        if (objectMapping == null) {
            return this;
        }
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, objectMapping);
        Map<Object, Object> newRemovedObjectsInView = RecordingUtils.replaceElements(this.removedObjectsInView, objectMapping);
        if (newElements != null) {
            if (newRemovedObjectsInView == null) {
                return new MapRemoveAllKeysAction<C, K, V>(newElements, this.removedObjectsInView);
            }
            return new MapRemoveAllKeysAction<C, Object, Object>(newElements, newRemovedObjectsInView);
        }
        if (newRemovedObjectsInView != null) {
            return new MapRemoveAllKeysAction<C, Object, Object>(this.elements, newRemovedObjectsInView);
        }
        return this;
    }

    @Override
    public void addAction(List<MapAction<C>> actions, Collection<Object> addedKeys, Collection<Object> removedKeys, Collection<Object> addedElements, Collection<Object> removedElements) {
        actions.add(this);
    }
}

