/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.MapRemoveAllEntriesAction;
import com.blazebit.persistence.view.impl.collection.RecordingEntrySetIterator;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RecordingEntrySet<C extends Map<K, V>, K, V>
implements Set<Map.Entry<K, V>>,
Serializable {
    protected final Set<Map.Entry<K, V>> delegate;
    protected final RecordingMap<C, K, V> recordingMap;

    public RecordingEntrySet(Set<Map.Entry<K, V>> delegate, RecordingMap<C, K, V> recordingMap) {
        this.delegate = delegate;
        this.recordingMap = recordingMap;
    }

    @Override
    public boolean add(Map.Entry<K, V> e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        this.recordingMap.addAction(new MapRemoveAllEntriesAction((Map.Entry)o, this.recordingMap.delegate));
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.recordingMap.addAction(new MapRemoveAllEntriesAction(c, this.recordingMap.delegate));
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.recordingMap.addAction(MapRemoveAllEntriesAction.retainAll(c, this.recordingMap.delegate));
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.recordingMap.addClearAction();
        this.delegate.clear();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new RecordingEntrySetIterator<K, V>(this.recordingMap);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }
}

