/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import java.util.Iterator;

public class RecordingIterator<E>
implements Iterator<E> {
    private final RecordingCollection<?, E> recordingCollection;
    private final Iterator<E> iterator;
    private E current;

    public RecordingIterator(RecordingCollection<?, E> recordingCollection) {
        this.recordingCollection = recordingCollection;
        this.iterator = recordingCollection.delegate.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        this.current = this.iterator.next();
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.recordingCollection.addRemoveAction(this.current);
        this.iterator.remove();
        this.current = null;
    }
}

