/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.entity.AbstractEntityLoader;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.entity.ReferenceEntityLoader;
import com.blazebit.persistence.view.impl.entity.TargetViewClassBasedEntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.update.EntityViewUpdaterImpl;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.ViewType;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class EntityLoaders {
    private EntityLoaders() {
    }

    public static EntityLoader referenceLoaderForAttribute(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewType<?> subviewType, AbstractMethodAttribute<?, ?> attribute) {
        return EntityLoaders.referenceLoaderForAttribute(evm, localCache, subviewType, attribute.getViewTypes(), null);
    }

    public static EntityLoader referenceLoaderForAttribute(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewType<?> subviewType, Set<? extends ManagedViewType<?>> viewTypes, String attributeIdAttributeName) {
        if (viewTypes.size() == 1) {
            return EntityLoaders.buildReferenceEntityLoader(evm, localCache, subviewType, attributeIdAttributeName);
        }
        EntityLoader first = null;
        HashMap entityLoaderMap = new HashMap(viewTypes.size());
        for (ManagedViewType<?> viewType : viewTypes) {
            EntityLoader referenceEntityLoader = EntityLoaders.buildReferenceEntityLoader(evm, localCache, viewType, attributeIdAttributeName);
            entityLoaderMap.put(viewType.getJavaType(), referenceEntityLoader);
            if (viewType != subviewType) continue;
            first = referenceEntityLoader;
        }
        return new TargetViewClassBasedEntityLoader(first, entityLoaderMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EntityLoader buildReferenceEntityLoader(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewType<?> subviewType, String attributeIdAttributeName) {
        ViewToEntityMapper viewIdMapper;
        SingularAttribute<?, ?> attributeIdAttribute;
        boolean forceQuery = false;
        if (subviewType instanceof ViewType && attributeIdAttributeName != null) {
            MethodAttribute idAttribute = ((ViewType)subviewType).getIdAttribute();
            if (!attributeIdAttributeName.equals(((MappingAttribute)idAttribute).getMapping())) {
                ExtendedManagedType managedType = (ExtendedManagedType)evm.getMetamodel().getEntityMetamodel().getManagedType(ExtendedManagedType.class, subviewType.getEntityClass());
                if (managedType.getAttribute(attributeIdAttributeName).getAttribute().getJavaMember() instanceof Field) {
                    boolean bl = forceQuery = !evm.getJpaProvider().supportsProxyParameterForNonPkAssociation();
                }
                if (Accessors.forEntityMappingAsViewAccessor(evm, subviewType, attributeIdAttributeName, true) == null) {
                    attributeIdAttribute = AbstractEntityLoader.viewIdMappingOf(evm, subviewType);
                    viewIdMapper = EntityViewUpdaterImpl.createViewIdMapper(evm, localCache, subviewType);
                    forceQuery = !evm.getJpaProvider().supportsProxyParameterForNonPkAssociation();
                    return new ReferenceEntityLoader(evm, subviewType.getEntityClass(), AbstractEntityLoader.jpaIdOf(evm, subviewType), attributeIdAttribute, viewIdMapper, evm.getEntityIdAccessor(), forceQuery);
                } else {
                    attributeIdAttribute = AbstractEntityLoader.associationIdMappingOf(evm, subviewType, attributeIdAttributeName);
                    if (attributeIdAttribute.getType().getPersistenceType() != Type.PersistenceType.BASIC) throw new UnsupportedOperationException("Composite or association based natural keys for associations are not yet supported!");
                    viewIdMapper = null;
                }
                return new ReferenceEntityLoader(evm, subviewType.getEntityClass(), AbstractEntityLoader.jpaIdOf(evm, subviewType), attributeIdAttribute, viewIdMapper, evm.getEntityIdAccessor(), forceQuery);
            } else {
                attributeIdAttribute = AbstractEntityLoader.viewIdMappingOf(evm, subviewType);
                viewIdMapper = EntityViewUpdaterImpl.createViewIdMapper(evm, localCache, subviewType);
            }
            return new ReferenceEntityLoader(evm, subviewType.getEntityClass(), AbstractEntityLoader.jpaIdOf(evm, subviewType), attributeIdAttribute, viewIdMapper, evm.getEntityIdAccessor(), forceQuery);
        } else {
            attributeIdAttribute = AbstractEntityLoader.viewIdMappingOf(evm, subviewType);
            viewIdMapper = EntityViewUpdaterImpl.createViewIdMapper(evm, localCache, subviewType);
        }
        return new ReferenceEntityLoader(evm, subviewType.getEntityClass(), AbstractEntityLoader.jpaIdOf(evm, subviewType), attributeIdAttribute, viewIdMapper, evm.getEntityIdAccessor(), forceQuery);
    }
}

