/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.AbstractEntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.List;

public class ReferenceEntityLoader
extends AbstractEntityLoader {
    private final JpaProvider jpaProvider;
    private final String queryString;
    private final String queryStringMultiple;

    public ReferenceEntityLoader(EntityViewManagerImpl evm, ManagedViewType<?> subviewType, ViewToEntityMapper viewIdMapper) {
        this(evm, subviewType.getEntityClass(), ReferenceEntityLoader.jpaIdOf(evm, subviewType), ReferenceEntityLoader.viewIdMappingOf(evm, subviewType), viewIdMapper, evm.getEntityIdAccessor(), false);
    }

    public ReferenceEntityLoader(EntityViewManagerImpl evm, Class<?> entityClass, SingularAttribute<?, ?> idAttribute, SingularAttribute<?, ?> viewIdMappingAttribute, ViewToEntityMapper viewIdMapper, AttributeAccessor entityIdAccessor, boolean forceQuery) {
        super(evm, entityClass, idAttribute, viewIdMappingAttribute, viewIdMapper, entityIdAccessor);
        if (!forceQuery && this.primaryKeyId) {
            this.jpaProvider = null;
            this.queryString = null;
            this.queryStringMultiple = null;
        } else {
            this.jpaProvider = evm.getJpaProvider();
            this.queryString = "SELECT e FROM " + evm.getMetamodel().getEntityMetamodel().entity(entityClass).getName() + " e WHERE e." + this.idAttributeName + " = :id";
            this.queryStringMultiple = "SELECT e FROM " + evm.getMetamodel().getEntityMetamodel().entity(entityClass).getName() + " e WHERE e." + this.idAttributeName + " IN :entityIds";
        }
    }

    @Override
    public Object toEntity(UpdateContext context, Object view, Object id) {
        if (id == null) {
            return this.createEntity();
        }
        return this.getReferenceOrLoad(context, view, id);
    }

    @Override
    public void toEntities(UpdateContext context, List<Object> views, List<Object> ids) {
        this.getReferencesLoadOrCreate(context, views, ids);
    }

    @Override
    protected Object queryEntity(EntityManager em, Object id) {
        if (this.queryString == null) {
            return em.getReference(this.entityClass, id);
        }
        List list = em.createQuery(this.queryString).setParameter("id", id).getResultList();
        if (list.isEmpty()) {
            throw new EntityNotFoundException("Required entity '" + this.entityClass.getName() + "' with id '" + id + "' couldn't be found!");
        }
        Object entity = list.get(0);
        if (this.jpaProvider == null) {
            return entity;
        }
        return this.jpaProvider.unproxy(entity);
    }

    @Override
    protected List<Object> queryEntities(EntityManager em, List<Object> ids) {
        if (this.queryStringMultiple == null) {
            ArrayList<Object> entities = new ArrayList<Object>(ids.size());
            for (Object id : ids) {
                entities.add(em.getReference(this.entityClass, id));
            }
            return entities;
        }
        List list = em.createQuery(this.queryStringMultiple).setParameter("entityIds", ids).getResultList();
        if (list.size() != ids.size()) {
            throw new EntityNotFoundException("Required entities '" + this.entityClass.getName() + "' with ids '" + ids + "' couldn't all be found!");
        }
        if (this.jpaProvider == null) {
            return list;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.jpaProvider.unproxy(list.get(i)));
        }
        return list;
    }

    @Override
    public Object getEntityId(UpdateContext context, Object entity) {
        if (this.entityIdAccessor == null) {
            return null;
        }
        return this.entityIdAccessor.getValue(entity);
    }
}

