/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.mapper;

import com.blazebit.persistence.view.ConvertOption;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.MapInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.proxy.ConvertReflectionInstantiator;
import com.blazebit.persistence.view.impl.proxy.ObjectInstantiator;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MapAttribute;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.ParameterAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewMetamodel;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.type.DirtyStateTrackable;
import com.blazebit.persistence.view.spi.type.DirtyTracker;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewMapper<S, T> {
    private final int[] dirtyMapping;
    private final boolean tryCopyInitialState;
    private final ObjectMapper[] objectMappers;
    private final ObjectInstantiator<T> objectInstantiator;
    private final EntityViewKindMapping entityViewKindMapping;
    private final Method postConvert;
    private final boolean postConvertUsesSource;

    public ViewMapper(ManagedViewType<S> sourceType, ManagedViewType<T> targetType, MappingConstructorImpl<T> targetConstructor, boolean ignoreMissing, Boolean maybeMarkNew, EntityViewManager entityViewManager, ProxyFactory proxyFactory, String prefix, Map<String, Key<Object, Object>> subMappers) {
        if (sourceType != null && !targetType.getEntityClass().isAssignableFrom(sourceType.getEntityClass())) {
            throw this.inconvertible("Incompatible entity types!", sourceType, targetType);
        }
        EntityViewKindMapping entityViewKindMapping = maybeMarkNew != null && maybeMarkNew != false ? EntityViewKindMapping.MARK_NEW : (targetType.isCreatable() ? EntityViewKindMapping.MAP_REFERENCE_AND_NEW : EntityViewKindMapping.MAP_REFERENCE);
        if (targetConstructor == null) {
            targetConstructor = this.getDefaultConstructor(targetType);
        }
        List<Object> parameterAttributes = targetConstructor == null ? Collections.emptyList() : targetConstructor.getParameterAttributes();
        Set attributes = targetType.getAttributes();
        Class[] parameterTypes = new Class[attributes.size() + parameterAttributes.size()];
        ObjectMapper[] objectMappers = new ObjectMapper[attributes.size() + parameterAttributes.size()];
        Iterator iterator = attributes.iterator();
        MethodAttribute idAttribute = null;
        ArrayList<Integer> dirtyMapping = new ArrayList<Integer>();
        int i = 0;
        if (targetType instanceof ViewType) {
            idAttribute = ((ViewType)targetType).getIdAttribute();
            parameterTypes[i] = idAttribute.getConvertedJavaType();
            objectMappers[i] = this.createAccessor(sourceType, targetType, ignoreMissing, entityViewKindMapping, entityViewManager, proxyFactory, idAttribute, prefix, subMappers);
            ++i;
        }
        while (iterator.hasNext()) {
            MethodAttribute targetAttribute = (MethodAttribute)iterator.next();
            if (targetAttribute == idAttribute) continue;
            parameterTypes[i] = targetAttribute.getConvertedJavaType();
            objectMappers[i] = this.createAccessor(sourceType, targetType, ignoreMissing, entityViewKindMapping, entityViewManager, proxyFactory, targetAttribute, prefix, subMappers);
            int n = ((AbstractMethodAttribute)targetAttribute).getDirtyStateIndex();
            if (n != -1) {
                int sourceIndex;
                MethodAttribute sourceAttribute;
                MethodAttribute methodAttribute = sourceAttribute = sourceType == null ? null : sourceType.getAttribute(targetAttribute.getName());
                if (sourceAttribute != null && (sourceIndex = ((AbstractMethodAttribute)sourceAttribute).getDirtyStateIndex()) != -1) {
                    for (int j = dirtyMapping.size(); j <= n; ++j) {
                        dirtyMapping.add(-1);
                    }
                    dirtyMapping.set(n, sourceIndex);
                }
            }
            ++i;
        }
        for (ParameterAttribute parameterAttribute : parameterAttributes) {
            parameterTypes[i] = parameterAttribute.getConvertedJavaType();
            if (parameterAttribute.getMappingType() == Attribute.MappingType.PARAMETER) {
                objectMappers[i] = new ParameterObjectMapper(((MappingAttribute)parameterAttribute).getMapping());
            }
            ++i;
        }
        if (dirtyMapping.isEmpty()) {
            this.dirtyMapping = null;
        } else {
            int[] dirtyMappingArray = new int[dirtyMapping.size()];
            for (i = 0; i < dirtyMapping.size(); ++i) {
                dirtyMappingArray[i] = (Integer)dirtyMapping.get(i);
            }
            this.dirtyMapping = dirtyMappingArray;
        }
        this.tryCopyInitialState = entityViewKindMapping != EntityViewKindMapping.MARK_NEW;
        this.objectMappers = objectMappers;
        try {
            this.objectInstantiator = new ConvertReflectionInstantiator<T>(proxyFactory, targetType, parameterTypes, parameterAttributes.size(), entityViewManager);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Empty constructor is required for conversion. Please make sure " + targetType.getJavaType().getName() + " has an empty constructor!", ex);
        }
        if (entityViewKindMapping == EntityViewKindMapping.MARK_NEW && !targetType.isCreatable()) {
            throw new IllegalArgumentException("Defined to convert to new object but target view type isn't annotated with @CreatableEntityView: " + targetType.getJavaType().getName());
        }
        this.entityViewKindMapping = entityViewKindMapping;
        Method postConvertMethod = targetType.getPostConvertMethod();
        if (postConvertMethod != null) {
            postConvertMethod.setAccessible(true);
        }
        this.postConvert = postConvertMethod;
        this.postConvertUsesSource = postConvertMethod != null && postConvertMethod.getParameterTypes().length != 0;
    }

    private ObjectMapper createAccessor(ManagedViewType<S> sourceType, ManagedViewType<T> targetType, boolean ignoreMissing, EntityViewKindMapping entityViewKindMapping, EntityViewManager entityViewManager, ProxyFactory proxyFactory, MethodAttribute<? super T, ?> targetAttribute, String prefix, Map<String, Key<Object, Object>> subMappers) {
        AttributeAccessor accessor;
        MethodAttribute sourceAttribute;
        String newPrefix = prefix.isEmpty() ? targetAttribute.getName() : prefix + "." + targetAttribute.getName();
        MappingConstructorImpl constructor = null;
        Boolean maybeMarkNew = entityViewKindMapping == EntityViewKindMapping.MARK_NEW ? null : Boolean.valueOf(false);
        Key<Object, Object> subMapperKey = subMappers.get(newPrefix);
        if (subMapperKey == Key.EXCLUDE_MARKER) {
            return null;
        }
        if (subMapperKey != null) {
            ignoreMissing = ((Key)subMapperKey).ignoreMissing;
            maybeMarkNew = ((Key)subMapperKey).markNew;
        }
        if (sourceType == null) {
            sourceAttribute = null;
            if (targetAttribute.getMappingType() == Attribute.MappingType.PARAMETER) {
                return new ParameterObjectMapper(((MappingAttribute)targetAttribute).getMapping());
            }
            accessor = Accessors.forEntityMapping((EntityViewManagerImpl)entityViewManager, targetAttribute);
            if (accessor == null) {
                if (ignoreMissing) {
                    return null;
                }
                throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type is missing in source type!", targetType);
            }
        } else {
            sourceAttribute = sourceType.getAttribute(targetAttribute.getName());
            if (sourceAttribute == null) {
                if (targetAttribute.getMappingType() == Attribute.MappingType.PARAMETER) {
                    return new ParameterObjectMapper(((MappingAttribute)targetAttribute).getMapping());
                }
                if (ignoreMissing) {
                    return null;
                }
                throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type is missing in source type!", sourceType, targetType);
            }
            accessor = Accessors.forViewAttribute(null, sourceAttribute, true);
        }
        if (targetAttribute.isCollection()) {
            if (sourceAttribute != null && targetAttribute.getConvertedJavaType() != sourceAttribute.getConvertedJavaType()) {
                throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type has a different plural type than in source type!", sourceType, targetType);
            }
            PluralAttribute targetPluralAttr = (PluralAttribute)targetAttribute;
            Type elementType = sourceAttribute == null ? null : ((PluralAttribute)sourceAttribute).getElementType();
            ViewMapper<Object, Object> valueMapper = null;
            Object attributeType = targetPluralAttr.getElementType();
            if (subMapperKey != null) {
                attributeType = ((Key)subMapperKey).targetType;
                constructor = ((Key)subMapperKey).targetConstructor;
            }
            if (targetAttribute.isSubview()) {
                valueMapper = this.createViewMapper((Type<?>)elementType, (Type<?>)attributeType, constructor, ignoreMissing, maybeMarkNew, entityViewManager, proxyFactory, newPrefix, subMappers);
            } else if (sourceType != null && targetPluralAttr.getElementType() != elementType) {
                throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type has a different element type than in source type!", sourceType, targetType);
            }
            boolean needsDirtyTracker = ((AbstractAttribute)targetAttribute).needsDirtyTracker();
            if (targetPluralAttr.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                MapAttribute targetMapAttr = (MapAttribute)targetAttribute;
                Type keyType = sourceAttribute == null ? null : ((MapAttribute)sourceAttribute).getKeyType();
                ViewMapper<Object, Object> keyMapper = null;
                if (targetMapAttr.isKeySubview()) {
                    String newKeyPrefix = "KEY(" + newPrefix + ")";
                    Key<Object, Object> keySubMapperKey = subMappers.get(newKeyPrefix);
                    if (keySubMapperKey == Key.EXCLUDE_MARKER) {
                        keyMapper = null;
                    } else {
                        Boolean maybeMarkNewKey;
                        constructor = null;
                        Object keyTargetType = targetMapAttr.getKeyType();
                        Boolean bl = maybeMarkNewKey = entityViewKindMapping == EntityViewKindMapping.MARK_NEW ? null : Boolean.valueOf(false);
                        if (subMapperKey != null) {
                            constructor = ((Key)keySubMapperKey).targetConstructor;
                            keyTargetType = ((Key)keySubMapperKey).targetType;
                            ignoreMissing = ((Key)keySubMapperKey).ignoreMissing;
                            maybeMarkNewKey = ((Key)keySubMapperKey).markNew;
                        }
                        keyMapper = this.createViewMapper((Type<?>)keyType, (Type<?>)keyTargetType, constructor, ignoreMissing, maybeMarkNewKey, entityViewManager, proxyFactory, newPrefix, subMappers);
                    }
                } else if (sourceType != null && targetMapAttr.getKeyType() != keyType) {
                    throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type has a different key type than in source type!", sourceType, targetType);
                }
                MapInstantiatorImplementor<?, ?> mapInstantiator = ((AbstractAttribute)targetAttribute).getMapInstantiator();
                return new MapObjectMapper(accessor, needsDirtyTracker, entityViewKindMapping != EntityViewKindMapping.MARK_NEW, mapInstantiator, keyMapper, valueMapper);
            }
            CollectionInstantiatorImplementor<?, ?> collectionInstantiator = ((AbstractAttribute)targetAttribute).getCollectionInstantiator();
            return new CollectionObjectMapper(accessor, needsDirtyTracker, entityViewKindMapping != EntityViewKindMapping.MARK_NEW, collectionInstantiator, valueMapper);
        }
        if (targetAttribute.isSubview()) {
            Object attributeType = ((SingularAttribute)targetAttribute).getType();
            if (subMapperKey != null) {
                attributeType = ((Key)subMapperKey).targetType;
                constructor = ((Key)subMapperKey).targetConstructor;
            }
            Type type = sourceAttribute == null ? null : ((SingularAttribute)sourceAttribute).getType();
            ViewMapper<Object, Object> mapper = this.createViewMapper((Type<?>)type, (Type<?>)attributeType, constructor, ignoreMissing, maybeMarkNew, entityViewManager, proxyFactory, newPrefix, subMappers);
            return new AttributeObjectMapper(accessor, mapper);
        }
        if (sourceAttribute != null && targetAttribute.getConvertedJavaType() != sourceAttribute.getConvertedJavaType()) {
            throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type has a different type than in source type!", sourceType, targetType);
        }
        return new PassthroughObjectMapper(accessor);
    }

    private MappingConstructorImpl<T> getDefaultConstructor(ManagedViewType<T> targetType) {
        MappingConstructorImpl constructor = (MappingConstructorImpl)targetType.getConstructor("init");
        if (constructor == null) {
            switch (targetType.getConstructors().size()) {
                case 0: {
                    break;
                }
                case 1: {
                    constructor = (MappingConstructorImpl)targetType.getConstructors().iterator().next();
                    break;
                }
                default: {
                    constructor = (MappingConstructorImpl)targetType.getConstructor(new Class[0]);
                }
            }
        }
        return constructor;
    }

    private ViewMapper<Object, Object> createViewMapper(Type<?> source, Type<?> target, MappingConstructorImpl<?> targetConstructor, boolean ignoreMissing, Boolean markNew, EntityViewManager entityViewManager, ProxyFactory proxyFactory, String prefix, Map<String, Key<Object, Object>> subMappers) {
        ManagedViewType sourceType = (ManagedViewType)source;
        ManagedViewType targetType = (ManagedViewType)target;
        return new ViewMapper<Object, Object>(sourceType, targetType, targetConstructor, ignoreMissing, markNew, entityViewManager, proxyFactory, prefix, subMappers);
    }

    private RuntimeException inconvertible(String reason, ManagedViewType<S> sourceType, ManagedViewType<T> targetType) {
        return new IllegalArgumentException("Can't convert from '" + sourceType.getJavaType().getName() + "' to '" + targetType.getJavaType().getName() + "'! " + reason);
    }

    private RuntimeException inconvertible(String reason, ManagedViewType<T> targetType) {
        return new IllegalArgumentException("Can't convert from '" + targetType.getEntityClass().getName() + "' to '" + targetType.getJavaType().getName() + "'! " + reason);
    }

    public T map(S source, Map<String, Object> optionalParameters) {
        boolean tryResetInitialState;
        boolean copiedInitialState;
        T result;
        block21: {
            block20: {
                Object[] tuple = new Object[this.objectMappers.length];
                for (int i = 0; i < this.objectMappers.length; ++i) {
                    if (this.objectMappers[i] == null) continue;
                    tuple[i] = this.objectMappers[i].getValue(source, optionalParameters);
                }
                result = this.objectInstantiator.newInstance(tuple);
                copiedInitialState = false;
                if (this.dirtyMapping != null && source instanceof DirtyTracker) {
                    DirtyTracker oldDirtyTracker = (DirtyTracker)source;
                    DirtyTracker dirtyTracker = (DirtyTracker)result;
                    if (this.tryCopyInitialState && oldDirtyTracker instanceof DirtyStateTrackable && dirtyTracker instanceof DirtyStateTrackable) {
                        Object[] oldInitial = ((DirtyStateTrackable)oldDirtyTracker).$$_getInitialState();
                        Object[] newInitial = ((DirtyStateTrackable)dirtyTracker).$$_getInitialState();
                        for (int i = 0; i < this.dirtyMapping.length; ++i) {
                            int dirtyStateIndex = this.dirtyMapping[i];
                            if (!oldDirtyTracker.$$_isDirty(dirtyStateIndex)) continue;
                            newInitial[i] = oldInitial[dirtyStateIndex];
                            dirtyTracker.$$_markDirty(i);
                        }
                        copiedInitialState = true;
                    } else {
                        for (int i = 0; i < this.dirtyMapping.length; ++i) {
                            if (!oldDirtyTracker.$$_isDirty(this.dirtyMapping[i])) continue;
                            dirtyTracker.$$_markDirty(i);
                        }
                    }
                }
                tryResetInitialState = false;
                if (!(source instanceof EntityViewProxy)) break block20;
                switch (this.entityViewKindMapping) {
                    case MAP_REFERENCE_AND_NEW: {
                        if (((EntityViewProxy)source).$$_isNew()) {
                            tryResetInitialState = true;
                            ((MutableStateTrackable)result).$$_setIsNew(true);
                        }
                    }
                    case MAP_REFERENCE: {
                        if (((EntityViewProxy)source).$$_isReference()) {
                            tryResetInitialState = true;
                            ((EntityViewProxy)result).$$_setIsReference(true);
                        }
                        break block21;
                    }
                    case MARK_NEW: {
                        tryResetInitialState = true;
                        ((MutableStateTrackable)result).$$_setIsNew(true);
                        break block21;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported entity view kind mapping: " + (Object)((Object)this.entityViewKindMapping));
                    }
                }
            }
            if (this.entityViewKindMapping == EntityViewKindMapping.MARK_NEW) {
                tryResetInitialState = true;
                ((MutableStateTrackable)result).$$_setIsNew(true);
            }
        }
        if (!copiedInitialState && tryResetInitialState && result instanceof DirtyStateTrackable) {
            Object[] initialState = ((DirtyStateTrackable)result).$$_getInitialState();
            Arrays.fill(initialState, null);
        }
        if (this.postConvert != null) {
            try {
                if (this.postConvertUsesSource) {
                    this.postConvert.invoke(result, source);
                } else {
                    this.postConvert.invoke(result, new Object[0]);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Error during invocation of post convert method!", ex);
            }
        }
        return result;
    }

    private static enum EntityViewKindMapping {
        MAP_REFERENCE,
        MAP_REFERENCE_AND_NEW,
        MARK_NEW;

    }

    private static interface ObjectMapper {
        public Object getValue(Object var1, Map<String, Object> var2);
    }

    private static class ParameterObjectMapper
    implements ObjectMapper {
        private final String parameterName;

        public ParameterObjectMapper(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public Object getValue(Object object, Map<String, Object> optionalParameters) {
            return optionalParameters.get(this.parameterName);
        }
    }

    public static class Key<S, T> {
        public static final Key<Object, Object> EXCLUDE_MARKER = new Key(null, null, null, false, false);
        private final ManagedViewTypeImplementor<S> sourceType;
        private final ManagedViewTypeImplementor<T> targetType;
        private final MappingConstructorImpl<T> targetConstructor;
        private final boolean ignoreMissing;
        private final boolean markNew;

        public Key(ManagedViewTypeImplementor<S> sourceType, ManagedViewTypeImplementor<T> targetType, MappingConstructorImpl<T> targetConstructor, boolean ignoreMissing, boolean markNew) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.targetConstructor = targetConstructor;
            this.ignoreMissing = ignoreMissing;
            this.markNew = markNew;
        }

        public ViewMapper<S, T> createViewMapper(EntityViewManager entityViewManager, ProxyFactory proxyFactory, Map<String, Key<Object, Object>> subMappers) {
            return new ViewMapper<S, T>(this.sourceType, this.targetType, this.targetConstructor, this.ignoreMissing, this.markNew, entityViewManager, proxyFactory, "", subMappers);
        }

        public static <Y> Key<Object, Y> create(ViewMetamodel metamodel, Object source, Class<Y> targetEntityViewClass, String constructorName, ConvertOption ... convertOptions) {
            if (source instanceof EntityViewProxy) {
                EntityViewProxy sourceProxy = (EntityViewProxy)source;
                return Key.createWithConvertOptions(metamodel, sourceProxy.$$_getEntityViewClass(), targetEntityViewClass, constructorName, false, convertOptions);
            }
            ManagedViewType targetViewType = metamodel.managedView(targetEntityViewClass);
            if (targetViewType == null) {
                throw new IllegalArgumentException("Unknown target view type: " + targetEntityViewClass.getName());
            }
            if (!targetViewType.getEntityClass().isInstance(source)) {
                throw new IllegalArgumentException("The source object is not an instance of the target views entity type " + targetViewType.getEntityClass().getName() + ": " + source.getClass().getName());
            }
            return Key.createWithConvertOptions(metamodel, null, targetEntityViewClass, constructorName, true, convertOptions);
        }

        public static <X, Y> Key<X, Y> create(ViewMetamodel metamodel, Class<X> sourceEntityViewClass, Class<Y> targetEntityViewClass, String constructorName, ConvertOption ... convertOptions) {
            return Key.createWithConvertOptions(metamodel, sourceEntityViewClass, targetEntityViewClass, constructorName, false, convertOptions);
        }

        public static <X, Y> Key<X, Y> create(ViewMetamodel metamodel, Class<Y> targetEntityViewClass, String constructorName, ConvertOption ... convertOptions) {
            return Key.createWithConvertOptions(metamodel, null, targetEntityViewClass, constructorName, true, convertOptions);
        }

        public static <X, Y> Key<X, Y> create(ViewMetamodel metamodel, Class<X> sourceEntityViewClass, Class<Y> targetEntityViewClass, String targetConstructorName, boolean ignoreMissingAttributes, boolean markNew) {
            return Key.createWithFlags(metamodel, sourceEntityViewClass, targetEntityViewClass, targetConstructorName, false, ignoreMissingAttributes, markNew);
        }

        public ManagedViewTypeImplementor<S> getSourceType() {
            return this.sourceType;
        }

        public ManagedViewTypeImplementor<T> getTargetType() {
            return this.targetType;
        }

        public boolean isIgnoreMissing() {
            return this.ignoreMissing;
        }

        public boolean isMarkNew() {
            return this.markNew;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this == EXCLUDE_MARKER || o == EXCLUDE_MARKER || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.ignoreMissing != key.ignoreMissing) {
                return false;
            }
            if (this.markNew != key.markNew) {
                return false;
            }
            if (this.sourceType == null && key.sourceType != null) {
                return false;
            }
            if (this.sourceType != null && !this.sourceType.equals(key.sourceType)) {
                return false;
            }
            return this.targetType.equals(key.targetType);
        }

        public int hashCode() {
            if (this == EXCLUDE_MARKER) {
                return 0;
            }
            int result = this.sourceType == null ? 0 : this.sourceType.hashCode();
            result = 31 * result + this.targetType.hashCode();
            result = 31 * result + (this.ignoreMissing ? 1 : 0);
            result = 31 * result + (this.markNew ? 1 : 0);
            return result;
        }

        private static <X, Y> Key<X, Y> createWithConvertOptions(ViewMetamodel metamodel, Class<X> sourceEntityViewClass, Class<Y> targetEntityViewClass, String constructorName, boolean useEntityAsSource, ConvertOption ... convertOptions) {
            boolean ignoreMissingAttributes = false;
            boolean markNew = false;
            block4: for (ConvertOption copyOption : convertOptions) {
                switch (copyOption) {
                    case CREATE_NEW: {
                        markNew = true;
                        continue block4;
                    }
                    case IGNORE_MISSING_ATTRIBUTES: {
                        ignoreMissingAttributes = true;
                        continue block4;
                    }
                }
            }
            return Key.createWithFlags(metamodel, sourceEntityViewClass, targetEntityViewClass, constructorName, useEntityAsSource, ignoreMissingAttributes, markNew);
        }

        private static <X, Y> Key<X, Y> createWithFlags(ViewMetamodel metamodel, Class<X> sourceEntityViewClass, Class<Y> targetEntityViewClass, String targetConstructorName, boolean useEntityAsSource, boolean ignoreMissingAttributes, boolean markNew) {
            ManagedViewTypeImplementor sourceViewType = (ManagedViewTypeImplementor)metamodel.managedView(sourceEntityViewClass);
            if (!useEntityAsSource && sourceViewType == null) {
                throw new IllegalArgumentException("Unknown source view type: " + sourceEntityViewClass.getName());
            }
            ManagedViewTypeImplementor targetViewType = (ManagedViewTypeImplementor)metamodel.managedView(targetEntityViewClass);
            if (targetViewType == null) {
                throw new IllegalArgumentException("Unknown target view type: " + targetEntityViewClass.getName());
            }
            MappingConstructorImpl constructor = null;
            if (targetConstructorName != null && (constructor = (MappingConstructorImpl)targetViewType.getConstructor(targetConstructorName)) == null) {
                throw new IllegalArgumentException("Unknown constructor '" + targetConstructorName + "' on target view type: " + targetEntityViewClass.getName());
            }
            return new Key(sourceViewType, targetViewType, constructor, ignoreMissingAttributes, markNew);
        }
    }

    private static class MapObjectMapper
    implements ObjectMapper {
        private final AttributeAccessor accessor;
        private final boolean recording;
        private final boolean tryCopyDirtyState;
        private final MapInstantiatorImplementor<?, ?> mapInstantiator;
        private final ViewMapper<Object, Object> keyMapper;
        private final ViewMapper<Object, Object> valueMapper;

        public MapObjectMapper(AttributeAccessor accessor, boolean recording, boolean tryCopyDirtyState, MapInstantiatorImplementor<?, ?> mapInstantiator, ViewMapper<Object, Object> keyMapper, ViewMapper<Object, Object> valueMapper) {
            this.accessor = accessor;
            this.recording = recording;
            this.tryCopyDirtyState = tryCopyDirtyState;
            this.mapInstantiator = mapInstantiator;
            this.keyMapper = keyMapper;
            this.valueMapper = valueMapper;
        }

        @Override
        public Object getValue(Object object, Map<String, Object> optionalParameters) {
            Map map = (Map)this.accessor.getValue(object);
            Map newMap = null;
            if (map != null) {
                Object newKey;
                Object backingMap;
                IdentityHashMap<Object, Object> objectMapping = null;
                if (this.recording) {
                    RecordingMap recordingMap = (RecordingMap)this.mapInstantiator.createRecordingMap(map.size());
                    newMap = recordingMap;
                    if (this.tryCopyDirtyState) {
                        backingMap = recordingMap.getDelegate();
                        if (map instanceof RecordingMap && (this.keyMapper != null || this.valueMapper != null)) {
                            objectMapping = new IdentityHashMap<Object, Object>(map.size() * 2);
                            if (this.keyMapper != null) {
                                for (Object e : ((RecordingMap)map).getRemovedKeys()) {
                                    objectMapping.put(e, this.keyMapper.map(e, optionalParameters));
                                }
                            }
                            if (this.valueMapper != null) {
                                for (Object e : ((RecordingMap)map).getRemovedElements()) {
                                    objectMapping.put(e, this.valueMapper.map(e, optionalParameters));
                                }
                            }
                        }
                    } else {
                        backingMap = newMap;
                    }
                } else {
                    backingMap = this.mapInstantiator.createMap(map.size());
                    newMap = backingMap;
                }
                if (this.keyMapper != null && this.valueMapper != null) {
                    if (objectMapping == null) {
                        for (Map.Entry entry : map.entrySet()) {
                            backingMap.put(this.keyMapper.map(entry.getKey(), optionalParameters), this.valueMapper.map(entry.getValue(), optionalParameters));
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            newKey = this.keyMapper.map(entry.getKey(), optionalParameters);
                            Object newValue = this.valueMapper.map(entry.getValue(), optionalParameters);
                            objectMapping.put(entry.getKey(), newKey);
                            objectMapping.put(entry.getValue(), newValue);
                            backingMap.put(newKey, newValue);
                        }
                    }
                } else if (this.keyMapper != null) {
                    if (objectMapping == null) {
                        for (Map.Entry entry : map.entrySet()) {
                            backingMap.put(this.keyMapper.map(entry.getKey(), optionalParameters), entry.getValue());
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            newKey = this.keyMapper.map(entry.getKey(), optionalParameters);
                            objectMapping.put(entry.getKey(), newKey);
                            backingMap.put(newKey, entry.getValue());
                        }
                    }
                } else if (this.valueMapper != null) {
                    if (objectMapping == null) {
                        for (Map.Entry entry : map.entrySet()) {
                            backingMap.put(entry.getKey(), this.valueMapper.map(entry.getValue(), optionalParameters));
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            Object newValue = this.valueMapper.map(entry.getValue(), optionalParameters);
                            objectMapping.put(entry.getValue(), newValue);
                            backingMap.put(entry.getKey(), newValue);
                        }
                    }
                } else {
                    backingMap.putAll(map);
                }
                if (this.recording && this.tryCopyDirtyState && map instanceof RecordingMap) {
                    ((RecordingMap)newMap).setActions((RecordingMap)map, objectMapping);
                }
            }
            return newMap;
        }
    }

    private static class CollectionObjectMapper
    implements ObjectMapper {
        private final AttributeAccessor accessor;
        private final boolean recording;
        private final boolean tryCopyDirtyState;
        private final CollectionInstantiatorImplementor<?, ?> collectionInstantiator;
        private final ViewMapper<Object, Object> valueMapper;

        public CollectionObjectMapper(AttributeAccessor accessor, boolean recording, boolean tryCopyDirtyState, CollectionInstantiatorImplementor<?, ?> collectionInstantiator, ViewMapper<Object, Object> valueMapper) {
            this.accessor = accessor;
            this.recording = recording;
            this.tryCopyDirtyState = tryCopyDirtyState;
            this.collectionInstantiator = collectionInstantiator;
            this.valueMapper = valueMapper;
        }

        @Override
        public Object getValue(Object object, Map<String, Object> optionalParameters) {
            Collection collection = (Collection)this.accessor.getValue(object);
            Collection newCollection = null;
            if (collection != null) {
                Object backingCollection;
                IdentityHashMap<Object, Object> objectMapping = null;
                if (this.recording) {
                    RecordingCollection coll = (RecordingCollection)this.collectionInstantiator.createRecordingCollection(collection.size());
                    newCollection = coll;
                    if (this.tryCopyDirtyState) {
                        backingCollection = coll.getDelegate();
                        if (collection instanceof RecordingCollection && this.valueMapper != null) {
                            objectMapping = new IdentityHashMap<Object, Object>(collection.size());
                            for (Object e : ((RecordingCollection)collection).getRemovedElements()) {
                                objectMapping.put(e, this.valueMapper.map(e, optionalParameters));
                            }
                        }
                    } else {
                        backingCollection = newCollection;
                    }
                } else {
                    backingCollection = this.collectionInstantiator.createCollection(collection.size());
                    newCollection = backingCollection;
                }
                if (this.valueMapper != null) {
                    if (objectMapping == null) {
                        for (Object o : collection) {
                            backingCollection.add(this.valueMapper.map(o, optionalParameters));
                        }
                    } else {
                        for (Object o : collection) {
                            Object newObject = this.valueMapper.map(o, optionalParameters);
                            objectMapping.put(o, newObject);
                            backingCollection.add(newObject);
                        }
                    }
                } else {
                    backingCollection.addAll(collection);
                }
                if (this.recording && this.tryCopyDirtyState && collection instanceof RecordingCollection) {
                    ((RecordingCollection)newCollection).setActions((RecordingCollection)collection, objectMapping);
                }
            }
            return newCollection;
        }
    }

    private static class AttributeObjectMapper
    implements ObjectMapper {
        private final AttributeAccessor accessor;
        private final ViewMapper<Object, Object> mapper;

        public AttributeObjectMapper(AttributeAccessor accessor, ViewMapper<Object, Object> mapper) {
            this.accessor = accessor;
            this.mapper = mapper;
        }

        @Override
        public Object getValue(Object object, Map<String, Object> optionalParameters) {
            Object value = this.accessor.getValue(object);
            if (value != null) {
                return this.mapper.map(value, optionalParameters);
            }
            return null;
        }
    }

    private static class PassthroughObjectMapper
    implements ObjectMapper {
        private final AttributeAccessor accessor;

        public PassthroughObjectMapper(AttributeAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public Object getValue(Object object, Map<String, Object> optionalParameters) {
            return this.accessor.getValue(object);
        }
    }
}

