/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import com.blazebit.persistence.view.impl.collection.CollectionInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingList;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import java.util.Collection;
import java.util.List;

public class CollectionInstantiatorAccumulator
implements ContainerAccumulator<Collection<?>> {
    private final CollectionInstantiatorImplementor<?, ?> collectionInstantiator;
    private final ContainerAccumulator<Object> valueAccumulator;
    private final boolean filterNulls;

    public CollectionInstantiatorAccumulator(CollectionInstantiatorImplementor<?, ?> collectionInstantiator, ContainerAccumulator<?> valueAccumulator, boolean filterNulls) {
        this.collectionInstantiator = collectionInstantiator;
        this.valueAccumulator = valueAccumulator;
        this.filterNulls = filterNulls;
    }

    public CollectionInstantiatorImplementor<?, ?> getCollectionInstantiator() {
        return this.collectionInstantiator;
    }

    public ContainerAccumulator<Object> getValueAccumulator() {
        return this.valueAccumulator;
    }

    @Override
    public Collection<?> createContainer(boolean recording, int size) {
        if (recording) {
            return this.collectionInstantiator.createRecordingCollection(size);
        }
        return this.collectionInstantiator.createCollection(size);
    }

    @Override
    public void add(Collection<?> container, Object indexObject, Object value, boolean recording) {
        if (this.filterNulls && value == null) {
            return;
        }
        if (indexObject == null || !this.collectionInstantiator.isIndexed()) {
            if (recording) {
                ((RecordingCollection)container).getDelegate().add(value);
            } else {
                container.add(value);
            }
        } else {
            int size;
            List list = recording ? (List)((RecordingList)container).getDelegate() : (List)container;
            int index = (Integer)indexObject;
            if (index < (size = list.size())) {
                if (this.valueAccumulator == null) {
                    Object oldValue = list.set(index, value);
                    if (oldValue != null && !oldValue.equals(value)) {
                        throw new IllegalArgumentException("Value " + value + " replaces old value " + oldValue + " at index " + index + "! Use a proper accumulator!");
                    }
                } else {
                    this.valueAccumulator.add(list.get(index), null, value, false);
                }
            } else {
                if (index > size) {
                    for (int i = size; i < index; ++i) {
                        list.add(null);
                    }
                }
                if (this.valueAccumulator != null) {
                    Object valueContainer = this.valueAccumulator.createContainer(false, 1);
                    this.valueAccumulator.add(valueContainer, null, value, false);
                    value = valueContainer;
                }
                list.add(index, value);
            }
        }
    }

    @Override
    public void addAll(Collection<?> container, Collection<?> collection, boolean recording) {
        if (!this.collectionInstantiator.isIndexed() || !(collection instanceof List)) {
            Object target = recording ? ((RecordingCollection)container).getDelegate() : container;
            if (this.filterNulls) {
                for (Object o : collection) {
                    if (o == null) continue;
                    target.add(o);
                }
            } else {
                target.addAll(collection);
            }
        } else {
            List other = (List)collection;
            List list = recording ? (List)((RecordingList)container).getDelegate() : (List)container;
            int listEnd = Math.min(list.size(), other.size());
            if (this.valueAccumulator == null) {
                int i;
                for (i = 0; i < listEnd; ++i) {
                    Object value = other.get(i);
                    Object oldValue = list.set(i, value);
                    if (oldValue == null || oldValue.equals(value)) continue;
                    throw new IllegalArgumentException("Value " + value + " replaces old value " + oldValue + " at index " + i + "! Use a proper accumulator!");
                }
                for (i = listEnd; i < other.size(); ++i) {
                    list.add(i, other.get(i));
                }
            } else {
                int i;
                for (i = 0; i < listEnd; ++i) {
                    this.valueAccumulator.add(list.get(i), null, other.get(i), false);
                }
                for (i = listEnd; i < other.size(); ++i) {
                    Object valueContainer = this.valueAccumulator.createContainer(false, 1);
                    this.valueAccumulator.addAll(valueContainer, other.get(i), false);
                    list.add(i, valueContainer);
                }
            }
        }
    }

    @Override
    public boolean requiresPostConstruct() {
        return this.collectionInstantiator.requiresPostConstruct();
    }

    @Override
    public void postConstruct(Collection<?> collection) {
        this.collectionInstantiator.postConstruct(collection);
    }
}

