/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformator;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.UpdatableViewMap;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.spi.type.BasicUserTypeStringSupport;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.List;

public class MultisetTupleTransformer
implements TupleTransformer {
    private final int startIndex;
    private final boolean hasSelectOrSubselectFetchedAttributes;
    private final TupleTransformator tupleTransformator;
    private final TupleTransformer subviewTupleTransformer;
    private final TupleTransformer indexSubviewTupleTransformer;
    private final int indexStartIndex;
    private final BasicUserTypeStringSupport<Object>[] fieldConverters;
    private final TypeConverter<Object, Object> elementConverter;
    private final ContainerAccumulator<Object> containerAccumulator;
    private final boolean dirtyTracking;

    public MultisetTupleTransformer(int startIndex, boolean hasSelectOrSubselectFetchedAttributes, TupleTransformator tupleTransformator, TupleTransformer subviewTupleTransformer, TupleTransformer indexSubviewTupleTransformer, int indexStartIndex, BasicUserTypeStringSupport<Object>[] fieldConverters, TypeConverter<Object, Object> elementConverter, ContainerAccumulator<Object> containerAccumulator, boolean dirtyTracking) {
        this.startIndex = startIndex;
        this.hasSelectOrSubselectFetchedAttributes = hasSelectOrSubselectFetchedAttributes;
        this.tupleTransformator = tupleTransformator;
        this.subviewTupleTransformer = subviewTupleTransformer;
        this.indexSubviewTupleTransformer = indexSubviewTupleTransformer;
        this.indexStartIndex = indexStartIndex;
        this.elementConverter = elementConverter;
        this.fieldConverters = fieldConverters;
        this.containerAccumulator = containerAccumulator;
        this.dirtyTracking = dirtyTracking;
    }

    @Override
    public int getConsumeStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getConsumeEndIndex() {
        return this.startIndex + 1;
    }

    @Override
    public Object[] transform(Object[] tuple, UpdatableViewMap updatableViewMap) {
        Object collection = this.containerAccumulator.createContainer(this.dirtyTracking, 0);
        if (tuple[this.startIndex] != null) {
            int i;
            List objects = (List)tuple[this.startIndex];
            for (i = 0; i < objects.size(); ++i) {
                Object[] elementTuple = (Object[])objects.get(i);
                for (int j = 0; j < this.fieldConverters.length; ++j) {
                    if (!(elementTuple[j] instanceof CharSequence)) continue;
                    elementTuple[j] = this.fieldConverters[j].fromString((CharSequence)elementTuple[j]);
                }
            }
            if (this.tupleTransformator != null) {
                this.tupleTransformator.transformAll(objects);
            }
            for (i = 0; i < objects.size(); ++i) {
                Object indexObject = null;
                if (this.indexSubviewTupleTransformer != null) {
                    indexObject = this.indexSubviewTupleTransformer.transform((Object[])objects.get(i), updatableViewMap)[this.indexSubviewTupleTransformer.getConsumeStartIndex() - 1];
                } else if (this.indexStartIndex != -1) {
                    indexObject = ((Object[])objects.get(i))[this.indexStartIndex];
                }
                if (this.subviewTupleTransformer == null) {
                    this.add(collection, indexObject, ((Object[])objects.get(i))[this.startIndex]);
                    continue;
                }
                Object[] transformedTuple = this.subviewTupleTransformer.transform((Object[])objects.get(i), updatableViewMap);
                this.add(collection, indexObject, transformedTuple[0]);
            }
        }
        tuple[this.startIndex] = collection;
        return tuple;
    }

    protected void add(Object collection, Object index, Object value) {
        if (this.elementConverter != null) {
            value = this.elementConverter.convertToViewType(value);
        }
        this.containerAccumulator.add(collection, index, value, this.dirtyTracking);
    }
}

