/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.impl.type.LobImplementor;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Clob;
import java.sql.NClob;

public class ClobProxy
implements InvocationHandler {
    private static final Class<?>[] PROXY_INTERFACES = new Class[]{Clob.class, LobImplementor.class};
    private static final Class<?>[] NCLOB_PROXY_INTERFACES = new Class[]{NClob.class, LobImplementor.class};
    private final Clob delegate;
    private BasicDirtyTracker parent;
    private int parentIndex = -1;
    private boolean dirty;

    public ClobProxy(Clob delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "getWrapped": {
                return this.delegate;
            }
            case "$$_isDirty": {
                return this.dirty;
            }
            case "$$_unmarkDirty": {
                this.dirty = false;
                return null;
            }
            case "$$_setParent": {
                if (this.parent != null) {
                    throw new IllegalStateException("Parent object for " + this.toString() + " is already set to " + this.parent.toString() + " and can't be set to:" + this.parent.toString());
                }
                this.parent = (BasicDirtyTracker)args[0];
                this.parentIndex = (Integer)args[1];
                return null;
            }
            case "$$_unsetParent": {
                this.parent = null;
                this.parentIndex = -1;
                return null;
            }
            case "$$_markDirty": {
                this.dirty = true;
                return null;
            }
            case "setString": 
            case "setAsciiStream": 
            case "setCharacterStream": 
            case "truncate": {
                this.dirty = true;
                if (this.parent == null) break;
                this.parent.$$_markDirty(this.parentIndex);
                break;
            }
            case "toString": {
                return this.toString();
            }
            case "equals": {
                return this == args[0];
            }
            case "hashCode": {
                return this.hashCode();
            }
        }
        return method.invoke((Object)this.delegate, args);
    }

    public static Clob generateProxy(Clob delegate) {
        if (delegate == null) {
            return null;
        }
        return (Clob)Proxy.newProxyInstance(ClobProxy.class.getClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ClobProxy(delegate));
    }

    public static NClob generateProxy(NClob delegate) {
        if (delegate == null) {
            return null;
        }
        return (NClob)Proxy.newProxyInstance(ClobProxy.class.getClassLoader(), NCLOB_PROXY_INTERFACES, (InvocationHandler)new ClobProxy(delegate));
    }
}

