/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.spi.type.TypeConverter;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class OptionalTypeConverter
implements TypeConverter<Object, Object> {
    private static final Object[] NULL_ARRAY = new Object[]{null};
    private static final Method OF_NULLABLE;
    private static final Method OR_ELSE;

    public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
        if (declaredType.getClass() == Class.class) {
            return (Class)declaredType;
        }
        return ReflectionUtils.resolveTypeArguments(owningClass, (Type)declaredType)[0];
    }

    public Object convertToViewType(Object object) {
        try {
            return OF_NULLABLE.invoke(null, object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object convertToUnderlyingType(Object object) {
        try {
            return OR_ELSE.invoke(object, NULL_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method ofNullable = null;
        Method orElse = null;
        try {
            Class<?> c = Class.forName("java.util.Optional");
            ofNullable = c.getDeclaredMethod("ofNullable", Object.class);
            orElse = c.getDeclaredMethod("orElse", Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OF_NULLABLE = ofNullable;
        OR_ELSE = orElse;
    }
}

