/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.view.FlushMode;
import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.OptimisticLockException;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.MacroConfigurationExpressionFactory;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapInstantiatorImplementor;
import com.blazebit.persistence.view.impl.entity.EmbeddableUpdaterBasedViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.EntityIdLoader;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.entity.EntityLoaders;
import com.blazebit.persistence.view.impl.entity.FullEntityLoader;
import com.blazebit.persistence.view.impl.entity.LoadOnlyViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.LoadOrPersistViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ReferenceEntityLoader;
import com.blazebit.persistence.view.impl.entity.UpdaterBasedViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.macro.MutableEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableViewJpqlMacro;
import com.blazebit.persistence.view.impl.mapper.Mappers;
import com.blazebit.persistence.view.impl.mapper.ViewMapper;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImplementor;
import com.blazebit.persistence.view.impl.update.DefaultEntityTupleizer;
import com.blazebit.persistence.view.impl.update.EntityViewUpdater;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.BasicAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.CollectionAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.CompositeAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.EmbeddableAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.EntityCollectionRemoveListener;
import com.blazebit.persistence.view.impl.update.flush.IndexedListAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.InverseFlusher;
import com.blazebit.persistence.view.impl.update.flush.MapAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.SimpleMapViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.flush.SubviewAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedBasicAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedCollectionAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedMapAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedWritableBasicAttributeSetNullCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.VersionAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.ViewCollectionRemoveListener;
import com.blazebit.persistence.view.metamodel.BasicType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MapAttribute;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.type.DirtyStateTrackable;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import com.blazebit.persistence.view.spi.type.VersionBasicUserType;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class EntityViewUpdaterImpl
implements EntityViewUpdater {
    public static final String WHERE_CLAUSE_PREFIX = "_";
    private final boolean rootUpdateAllowed;
    private final ManagedViewTypeImplementor<?> managedViewType;
    private final FlushStrategy flushStrategy;
    private final EntityLoader fullEntityLoader;
    private final DirtyAttributeFlusher<?, Object, Object> idFlusher;
    private final VersionAttributeFlusher<Object, Object> versionFlusher;
    private final CompositeAttributeFlusher fullFlusher;
    private final String updatePrefixString;
    private final String updatePostfixString;
    private final String versionedUpdatePostfixString;
    private final String fullUpdateQueryString;

    public EntityViewUpdaterImpl(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewTypeImplementor<?> viewType, ManagedViewTypeImplementor<?> declaredViewType, EntityViewUpdaterImpl owner, String ownerMapping) {
        AbstractMethodAttribute versionAttribute;
        AbstractMethodAttribute idAttribute;
        ViewMapper<Object, Object> persistViewMapper;
        EntityIdLoader jpaIdInstantiator;
        ObjectBuilder<?> idViewBuilder;
        DefaultEntityTupleizer tupleizer;
        AttributeAccessor viewIdAccessor;
        String lockOwner;
        boolean persistable;
        evm.addUpdater(localCache, viewType, declaredViewType, owner, ownerMapping, this);
        Class entityClass = viewType.getEntityClass();
        this.managedViewType = viewType;
        this.flushStrategy = viewType.getFlushStrategy();
        EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
        ExtendedManagedType extendedManagedType = (ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, entityClass);
        EntityType entityType = extendedManagedType.getType() instanceof EntityType ? (EntityType)extendedManagedType.getType() : null;
        ViewToEntityMapper viewIdMapper = null;
        boolean bl = persistable = entityType != null;
        if (persistable && viewType instanceof ViewType) {
            ViewType view = (ViewType)viewType;
            this.rootUpdateAllowed = true;
            lockOwner = view.getLockOwner();
            viewIdAccessor = Accessors.forViewId(evm, (ViewType)viewType, false);
            com.blazebit.persistence.view.metamodel.SingularAttribute viewIdAttribute = (com.blazebit.persistence.view.metamodel.SingularAttribute)view.getIdAttribute();
            if (view.getIdAttribute().isSubview()) {
                ManagedViewTypeImplementor viewIdType = (ManagedViewTypeImplementor)viewIdAttribute.getType();
                boolean updateMappable = EntityViewUpdaterImpl.isUpdateMappable(viewIdType.getAttributes());
                if (updateMappable) {
                    viewIdMapper = EntityViewUpdaterImpl.createViewIdMapper(evm, localCache, view);
                    tupleizer = new DefaultEntityTupleizer(evm, viewIdType);
                    ExpressionFactory ef = (ExpressionFactory)evm.getCriteriaBuilderFactory().getService(ExpressionFactory.class);
                    idViewBuilder = evm.getTemplate(new MacroConfigurationExpressionFactory(ef, ef.getDefaultMacroConfiguration()), viewIdType, null, null, new MutableViewJpqlMacro(), null, new MutableEmbeddingViewJpqlMacro(), 0).createObjectBuilder(null, null, null, 0, false, false);
                    jpaIdInstantiator = new EntityIdLoader(viewIdType.getJpaManagedType().getJavaType());
                } else {
                    tupleizer = null;
                    idViewBuilder = null;
                    jpaIdInstantiator = null;
                }
            } else {
                tupleizer = null;
                idViewBuilder = null;
                jpaIdInstantiator = ((BasicTypeImpl)viewIdAttribute.getType()).isJpaManaged() ? new EntityIdLoader(viewIdAttribute.getJavaType()) : null;
            }
            persistViewMapper = declaredViewType != null ? evm.getViewMapper(new ViewMapper.Key(viewType, declaredViewType, null, false, false)) : null;
            this.idFlusher = EntityViewUpdaterImpl.createIdFlusher(evm, localCache, view, viewIdMapper);
        } else {
            this.rootUpdateAllowed = false;
            lockOwner = null;
            viewIdAccessor = null;
            tupleizer = null;
            idViewBuilder = null;
            jpaIdInstantiator = null;
            persistViewMapper = null;
            this.idFlusher = null;
        }
        boolean mutable = viewType.isCreatable() || viewType.isUpdatable();
        this.fullEntityLoader = mutable ? new FullEntityLoader(evm, viewType) : null;
        Set attributes = viewType.getAttributes();
        String idAttributeName = null;
        SingularAttribute jpaIdAttribute = null;
        SingularAttribute viewIdMappingAttribute = null;
        if (viewType instanceof ViewType) {
            idAttribute = (AbstractMethodAttribute)((ViewType)viewType).getIdAttribute();
            versionAttribute = (AbstractMethodAttribute)((ViewType)viewType).getVersionAttribute();
            this.versionFlusher = versionAttribute != null ? this.createVersionFlusher(evm, entityType, versionAttribute) : null;
            jpaIdAttribute = extendedManagedType.getIdAttribute();
            idAttributeName = jpaIdAttribute.getName();
            String mapping = idAttribute.getMapping();
            ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedManagedType.getAttributes().get(mapping);
            SingularAttribute singularAttribute = viewIdMappingAttribute = extendedAttribute == null ? null : (SingularAttribute)extendedAttribute.getAttribute();
            if ((viewType.isCreatable() || viewType.isUpdatable()) && !mapping.equals(jpaIdAttribute.getName())) {
                throw new IllegalArgumentException("Expected JPA id attribute [" + jpaIdAttribute.getName() + "] to match the entity view id attribute mapping [" + mapping + "] but it didn't!");
            }
        } else {
            idAttribute = null;
            versionAttribute = null;
            this.versionFlusher = null;
        }
        ArrayList<DirtyAttributeFlusher<Object, Object, Object>> flushers = new ArrayList<DirtyAttributeFlusher<Object, Object, Object>>(attributes.size());
        ArrayList passThroughFlushers = null;
        StringBuilder sb = null;
        int clauseEndIndex = -1;
        if (mutable && this.flushStrategy != FlushStrategy.ENTITY && jpaIdAttribute != null) {
            this.updatePrefixString = "UPDATE " + entityType.getName() + " e SET ";
            StringBuilder tmpSb = new StringBuilder();
            tmpSb.append(" WHERE ");
            this.idFlusher.appendUpdateQueryFragment(null, tmpSb, "e.", WHERE_CLAUSE_PREFIX, " AND ");
            this.updatePostfixString = tmpSb.toString();
            if (versionAttribute != null) {
                tmpSb.append(" AND ");
                this.versionFlusher.appendUpdateQueryFragment(null, tmpSb, "e.", WHERE_CLAUSE_PREFIX, " AND ");
                this.versionedUpdatePostfixString = tmpSb.toString();
            } else {
                this.versionedUpdatePostfixString = null;
            }
            sb = new StringBuilder(this.updatePrefixString.length() + tmpSb.length() + attributes.size() * 50);
            sb.append(this.updatePrefixString);
            clauseEndIndex = sb.length();
        } else {
            this.updatePrefixString = null;
            this.updatePostfixString = null;
            this.versionedUpdatePostfixString = null;
        }
        if (this.versionFlusher != null && sb != null) {
            this.versionFlusher.appendUpdateQueryFragment(null, sb, "e.", "", ", ");
            if (clauseEndIndex != sb.length()) {
                clauseEndIndex = sb.length();
                sb.append(", ");
            }
        }
        UnmappedAttributeCascadeDeleter[] cascadeDeleteUnmappedFlushers = null;
        UnmappedAttributeCascadeDeleter[][] flusherWiseCascadeDeleteUnmappedFlushers = null;
        TreeMap joinTableUnmappedEntityAttributes = new TreeMap(extendedManagedType.getOwnedAttributes());
        if (jpaIdAttribute != null) {
            joinTableUnmappedEntityAttributes.remove(jpaIdAttribute.getName());
        }
        if (versionAttribute != null) {
            joinTableUnmappedEntityAttributes.remove(versionAttribute.getMapping());
        }
        if (mutable || entityType == null) {
            for (MethodAttribute attribute : attributes) {
                DirtyAttributeFlusher<?, ?, ?> flusher;
                AbstractMethodAttribute methodAttribute;
                if (attribute == idAttribute || attribute == versionAttribute || !(methodAttribute = (AbstractMethodAttribute)attribute).isUpdateMappable()) continue;
                if (methodAttribute.getMapping() != null) {
                    joinTableUnmappedEntityAttributes.remove(methodAttribute.getMapping());
                }
                if ((flusher = this.createAttributeFlusher(evm, localCache, viewType, idAttributeName, this.flushStrategy, methodAttribute, this.idFlusher, owner, ownerMapping)) == null) continue;
                if (sb != null) {
                    int endIndex = sb.length();
                    flusher.appendUpdateQueryFragment(null, sb, "e.", "", ", ");
                    if (endIndex != sb.length()) {
                        clauseEndIndex = sb.length();
                        sb.append(", ");
                    }
                }
                if (flusher.isPassThrough()) {
                    if (passThroughFlushers == null) {
                        passThroughFlushers = new ArrayList();
                    }
                    passThroughFlushers.add(flusher);
                    continue;
                }
                flushers.add(flusher);
            }
            if (passThroughFlushers != null) {
                flushers.addAll(passThroughFlushers);
            }
        }
        Iterator iterator = joinTableUnmappedEntityAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ExtendedAttribute attributeEntry = (ExtendedAttribute)entry.getValue();
            JoinTable joinTable = attributeEntry.getJoinTable();
            if (joinTable != null || "".equals(attributeEntry.getMappedBy()) || entityMetamodel.getEntity(attributeEntry.getElementClass()) != null && attributeEntry.isDeleteCascaded()) continue;
            iterator.remove();
        }
        if (!joinTableUnmappedEntityAttributes.isEmpty()) {
            ArrayList<UnmappedBasicAttributeCascadeDeleter> cascadeDeleteUnmappedFlusherList = new ArrayList<UnmappedBasicAttributeCascadeDeleter>(joinTableUnmappedEntityAttributes.size());
            flusherWiseCascadeDeleteUnmappedFlushers = new UnmappedAttributeCascadeDeleter[flushers.size()][];
            LinkedHashMap flusherWiseCascadeDeleteUnmappedFlusherList = new LinkedHashMap(flushers.size());
            for (int i = 0; i < flushers.size(); ++i) {
                flusherWiseCascadeDeleteUnmappedFlusherList.put(((DirtyAttributeFlusher)flushers.get(i)).getAttributeName(), new ArrayList());
            }
            for (Map.Entry entry : joinTableUnmappedEntityAttributes.entrySet()) {
                List flusherWiseDeleters;
                UnmappedAttributeCascadeDeleter deleter;
                String unmappedAttributeName = (String)entry.getKey();
                ExtendedAttribute extendedAttribute = (ExtendedAttribute)entry.getValue();
                if (extendedAttribute.getAttribute().isCollection()) {
                    if ("".equals(extendedAttribute.getMappedBy())) {
                        ExtendedManagedType managedType = (ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, extendedAttribute.getElementClass());
                        deleter = new UnmappedWritableBasicAttributeSetNullCascadeDeleter(evm, (ManagedType<?>)entityType, (ExtendedManagedType<?>)managedType, extendedAttribute.getWritableMappedByMappings((EntityType)managedType.getType()));
                    } else {
                        deleter = ((jakarta.persistence.metamodel.PluralAttribute)extendedAttribute.getAttribute()).getCollectionType() == PluralAttribute.CollectionType.MAP ? new UnmappedMapAttributeCascadeDeleter(evm, unmappedAttributeName, extendedAttribute, entityClass, idAttributeName, false) : new UnmappedCollectionAttributeCascadeDeleter(evm, unmappedAttributeName, extendedAttribute, entityClass, idAttributeName, false);
                    }
                } else if ("".equals(extendedAttribute.getMappedBy())) {
                    ExtendedManagedType managedType = (ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, extendedAttribute.getElementClass());
                    deleter = new UnmappedWritableBasicAttributeSetNullCascadeDeleter(evm, (ManagedType<?>)entityType, (ExtendedManagedType<?>)managedType, extendedAttribute.getWritableMappedByMappings((EntityType)managedType.getType()));
                } else {
                    deleter = new UnmappedBasicAttributeCascadeDeleter(evm, unmappedAttributeName, extendedAttribute, idAttributeName, false);
                }
                cascadeDeleteUnmappedFlusherList.add((UnmappedBasicAttributeCascadeDeleter)deleter);
                int dotIndex = unmappedAttributeName.indexOf(46);
                if (dotIndex != -1) {
                    unmappedAttributeName = unmappedAttributeName.substring(0, dotIndex);
                }
                if ((flusherWiseDeleters = (List)flusherWiseCascadeDeleteUnmappedFlusherList.get(unmappedAttributeName)) == null) continue;
                flusherWiseDeleters.add(deleter.createFlusherWiseDeleter());
            }
            cascadeDeleteUnmappedFlushers = cascadeDeleteUnmappedFlusherList.toArray(new UnmappedAttributeCascadeDeleter[cascadeDeleteUnmappedFlusherList.size()]);
            int i = 0;
            for (List tmp : flusherWiseCascadeDeleteUnmappedFlusherList.values()) {
                flusherWiseCascadeDeleteUnmappedFlushers[i++] = tmp.toArray(new UnmappedAttributeCascadeDeleter[tmp.size()]);
            }
        }
        this.fullFlusher = new CompositeAttributeFlusher(evm, viewType.getJavaType(), viewType.getEntityClass(), viewType.getJpaManagedType(), persistable, persistViewMapper, jpaIdAttribute, viewIdMappingAttribute, evm.getEntityIdAccessor(), viewIdMapper, viewIdAccessor, tupleizer, jpaIdInstantiator, idViewBuilder, this.idFlusher, this.versionFlusher, lockOwner, cascadeDeleteUnmappedFlushers, flusherWiseCascadeDeleteUnmappedFlushers, flushers.toArray(new DirtyAttributeFlusher[flushers.size()]), viewType.getFlushMode(), this.flushStrategy);
        if (mutable && this.flushStrategy != FlushStrategy.ENTITY && jpaIdAttribute != null && clauseEndIndex != sb.length()) {
            if (clauseEndIndex + 2 == sb.length()) {
                sb.setLength(clauseEndIndex);
            }
            if (this.versionedUpdatePostfixString == null) {
                sb.append(this.updatePostfixString);
            } else {
                sb.append(this.versionedUpdatePostfixString);
            }
            this.fullUpdateQueryString = sb.toString();
        } else {
            this.fullUpdateQueryString = null;
        }
    }

    private static boolean isUpdateMappable(Set<AbstractMethodAttribute<?, ?>> attributes) {
        for (AbstractMethodAttribute<?, ?> attribute : attributes) {
            if (!attribute.isUpdateMappable()) {
                return false;
            }
            Type type = ((com.blazebit.persistence.view.metamodel.SingularAttribute)attribute).getType();
            if (!(type instanceof ManagedViewType) || EntityViewUpdaterImpl.isUpdateMappable(((ManagedViewType)type).getAttributes())) continue;
            return false;
        }
        return true;
    }

    public static ViewToEntityMapper createViewIdMapper(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewType<?> viewType) {
        if (viewType instanceof ViewType) {
            return EntityViewUpdaterImpl.createViewIdMapper(evm, localCache, (com.blazebit.persistence.view.metamodel.SingularAttribute)((ViewType)viewType).getIdAttribute());
        }
        return null;
    }

    public static ViewToEntityMapper createViewIdMapper(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, com.blazebit.persistence.view.metamodel.SingularAttribute<?, ?> viewIdAttribute) {
        if (!viewIdAttribute.isSubview()) {
            return null;
        }
        ManagedViewTypeImplementor viewIdType = (ManagedViewTypeImplementor)viewIdAttribute.getType();
        return new EmbeddableUpdaterBasedViewToEntityMapper(((AbstractMethodAttribute)viewIdAttribute).getLocation(), evm, viewIdType.getJavaType(), Collections.singleton(viewIdType), Collections.singleton(viewIdType), Collections.emptySet(), new ReferenceEntityLoader(evm, viewIdType, null), true, viewIdType.isUpdatable() ? null : Mappers.forViewToEntityAttributeMapping(evm, viewIdType, viewIdType.getEntityClass()), null, null, localCache);
    }

    public static DirtyAttributeFlusher<?, Object, Object> createIdFlusher(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ViewType<?> viewType, ViewToEntityMapper viewToEntityMapper) {
        return EntityViewUpdaterImpl.createIdFlusher(evm, localCache, viewType, viewToEntityMapper, (AbstractMethodAttribute)viewType.getIdAttribute());
    }

    public static DirtyAttributeFlusher<?, Object, Object> createIdFlusher(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ViewType<?> viewType, ViewToEntityMapper viewToEntityMapper, AbstractMethodAttribute<?, ?> idAttribute) {
        String updateFragment;
        String parameterName;
        boolean supportsQueryFlush;
        String attributeName = idAttribute.getName();
        String attributeMapping = idAttribute.getMapping();
        AttributeAccessor viewAttributeAccessor = Accessors.forViewAttribute(evm, idAttribute, true);
        AttributeAccessor entityAttributeAccessor = Accessors.forEntityMapping(evm, idAttribute);
        CompositeAttributeFlusher nestedFlusher = viewToEntityMapper != null ? (CompositeAttributeFlusher)viewToEntityMapper.getFullGraphNode() : null;
        boolean bl = supportsQueryFlush = nestedFlusher == null || nestedFlusher.supportsQueryFlush() && evm.getJpaProvider().supportsUpdateSetEmbeddable();
        if (supportsQueryFlush) {
            parameterName = attributeName;
            updateFragment = attributeMapping;
        } else {
            parameterName = attributeName + WHERE_CLAUSE_PREFIX;
            updateFragment = attributeMapping + ".";
        }
        if (idAttribute.isSubview()) {
            if (viewToEntityMapper == null) {
                return null;
            }
            return new EmbeddableAttributeFlusher<Object, Object>(attributeName, attributeMapping, updateFragment, parameterName, false, false, supportsQueryFlush, entityAttributeAccessor, viewAttributeAccessor, (EmbeddableUpdaterBasedViewToEntityMapper)viewToEntityMapper);
        }
        BasicTypeImpl type = (BasicTypeImpl)((com.blazebit.persistence.view.metamodel.SingularAttribute)idAttribute).getType();
        Map.Entry[] componentFlusherEntries = null;
        if (type.isJpaManaged()) {
            Set attributes = type.getManagedType().getAttributes();
            HashMap<AttributeAccessor, BasicAttributeFlusher> componentFlushers = new HashMap<AttributeAccessor, BasicAttributeFlusher>(attributes.size());
            EntityViewUpdaterImpl.buildComponentFlushers(evm, viewType.getEntityClass(), type.getJavaType(), attributeName + WHERE_CLAUSE_PREFIX, attributeMapping + ".", "", attributes, componentFlushers);
            componentFlusherEntries = componentFlushers.entrySet().toArray(new Map.Entry[componentFlushers.size()]);
        }
        TypeDescriptor typeDescriptor = TypeDescriptor.forType(evm, localCache, null, idAttribute, type, null, null);
        return new BasicAttributeFlusher<Object, Object>(attributeName, attributeMapping, true, false, true, false, false, false, componentFlusherEntries, evm.getJpaProvider(), typeDescriptor, updateFragment, parameterName, entityAttributeAccessor, viewAttributeAccessor, null, null, null);
    }

    private static void buildComponentFlushers(EntityViewManagerImpl evm, Class<?> entityClass, Class<?> rootType, String attributePrefix, String mappingPrefix, String accessorPrefix, Set<Attribute<?, ?>> attributes, Map<AttributeAccessor, BasicAttributeFlusher> componentFlushers) {
        for (Attribute<?, ?> attribute : attributes) {
            HashSet subAttributes;
            if (!(attribute instanceof SingularAttribute)) {
                throw new IllegalArgumentException("Plural attributes in embeddable types aren't supported yet! Remove attribute " + attribute.getName() + " of type " + attribute.getDeclaringType().getJavaType().getName() + " or use an entity view instead of the embeddable type!");
            }
            SingularAttribute attr = (SingularAttribute)attribute;
            if (attr.getType() instanceof jakarta.persistence.metamodel.BasicType) {
                String attributeName = attributePrefix + attribute.getName();
                String attributeMapping = mappingPrefix + attribute.getName();
                String parameterName = attributeName;
                String updateFragment = attributeMapping;
                AttributeAccessor attributeAccessor = Accessors.forEntityMapping(evm, rootType, accessorPrefix + attribute.getName());
                componentFlushers.put(attributeAccessor, new BasicAttributeFlusher(attributeName, attributeMapping, true, false, true, false, false, false, null, evm.getJpaProvider(), TypeDescriptor.forEntityComponentType(), updateFragment, parameterName, attributeAccessor, null, null, null, null));
                continue;
            }
            ManagedType managedType = (ManagedType)attr.getType();
            if (managedType instanceof EmbeddableType) {
                subAttributes = managedType.getAttributes();
            } else {
                subAttributes = new HashSet();
                EntityType entity = evm.getMetamodel().getEntityMetamodel().getEntity(entityClass);
                for (String propertyName : evm.getJpaProvider().getJoinMappingPropertyNames(entity, null, mappingPrefix + attribute.getName()).keySet()) {
                    subAttributes.add(managedType.getAttribute(propertyName));
                }
            }
            EntityViewUpdaterImpl.buildComponentFlushers(evm, entityClass, rootType, attributePrefix + attribute.getName() + WHERE_CLAUSE_PREFIX, mappingPrefix + attribute.getName() + ".", accessorPrefix + attribute.getName() + ".", subAttributes, componentFlushers);
        }
    }

    private VersionAttributeFlusher<Object, Object> createVersionFlusher(EntityViewManagerImpl evm, EntityType<?> entityType, AbstractMethodAttribute<?, ?> versionAttribute) {
        String attributeName = versionAttribute.getName();
        String attributeMapping = versionAttribute.getMapping();
        String parameterName = versionAttribute.getName();
        String updateFragment = versionAttribute.getMapping();
        AttributeAccessor viewAttributeAccessor = Accessors.forViewAttribute(evm, versionAttribute, false);
        AttributeAccessor attributeAccessor = Accessors.forEntityMapping(evm, versionAttribute);
        Type type = ((com.blazebit.persistence.view.metamodel.SingularAttribute)versionAttribute).getType();
        VersionBasicUserType userType = (VersionBasicUserType)((BasicType)type).getUserType();
        boolean jpaVersion = entityType.getSingularAttribute(versionAttribute.getMapping()).isVersion();
        return new VersionAttributeFlusher<Object, Object>(attributeName, attributeMapping, (VersionBasicUserType<Object>)userType, updateFragment, parameterName, attributeAccessor, viewAttributeAccessor, jpaVersion, evm.getJpaProvider());
    }

    public CompositeAttributeFlusher getFullGraphNode() {
        return this.fullFlusher;
    }

    @Override
    public DirtyAttributeFlusher<?, ?, ?> getIdFlusher() {
        return this.idFlusher;
    }

    @Override
    public <T extends DirtyAttributeFlusher<T, E, V>, E, V> DirtyAttributeFlusher<T, E, V> getNestedDirtyFlusher(UpdateContext context, MutableStateTrackable updatableProxy, DirtyAttributeFlusher<T, E, V> fullFlusher) {
        if (context.isForceFull() || this.managedViewType.getFlushMode() == FlushMode.FULL) {
            if (fullFlusher != null) {
                return fullFlusher;
            }
            return this.fullFlusher;
        }
        return this.fullFlusher.getNestedDirtyFlusher(context, updatableProxy);
    }

    @Override
    public DirtyChecker<DirtyStateTrackable> getDirtyChecker() {
        return this.fullFlusher;
    }

    public ManagedViewTypeImplementor<?> getManagedViewType() {
        return this.managedViewType;
    }

    @Override
    public boolean executeUpdate(UpdateContext context, MutableStateTrackable updatableProxy) {
        return this.update(context, null, updatableProxy);
    }

    @Override
    public Object executeUpdate(UpdateContext context, Object entity, MutableStateTrackable updatableProxy) {
        if (entity == null) {
            throw new IllegalArgumentException("Illegal null entity!");
        }
        this.update(context, entity, updatableProxy);
        return entity;
    }

    @Override
    public Query createUpdateQuery(UpdateContext context, MutableStateTrackable updatableProxy, DirtyAttributeFlusher<?, ?, ?> flusher) {
        boolean needsOptimisticLocking;
        String queryString;
        if (flusher == this.fullFlusher) {
            queryString = this.fullUpdateQueryString;
            needsOptimisticLocking = this.fullFlusher.hasVersionFlusher();
        } else {
            StringBuilder sb = new StringBuilder(this.updatePrefixString.length() + this.updatePostfixString.length() + 250);
            sb.append(this.updatePrefixString);
            int initialLength = sb.length();
            flusher.appendUpdateQueryFragment(context, sb, "e.", "", ", ");
            if (sb.length() == initialLength) {
                needsOptimisticLocking = this.fullFlusher.hasVersionFlusher() && flusher.isOptimisticLockProtected();
                if (needsOptimisticLocking) {
                    this.versionFlusher.appendUpdateQueryFragment(context, sb, "e.", "", ", ");
                    sb.append(this.versionedUpdatePostfixString);
                    queryString = sb.toString();
                } else {
                    queryString = null;
                }
            } else {
                needsOptimisticLocking = this.fullFlusher.hasVersionFlusher() && flusher.isOptimisticLockProtected();
                if (needsOptimisticLocking) {
                    sb.append(this.versionedUpdatePostfixString);
                } else {
                    sb.append(this.updatePostfixString);
                }
                queryString = sb.toString();
            }
        }
        Query query = null;
        if (queryString != null) {
            query = context.getEntityManager().createQuery(queryString);
            if (this.idFlusher != null) {
                this.idFlusher.flushQuery(context, WHERE_CLAUSE_PREFIX, null, query, updatableProxy, updatableProxy, updatableProxy.$$_getId(), null, null);
            }
            if (needsOptimisticLocking) {
                this.versionFlusher.flushQueryInitialVersion(context, WHERE_CLAUSE_PREFIX, query, updatableProxy, updatableProxy.$$_getVersion());
            }
        }
        return query;
    }

    private boolean update(UpdateContext context, Object entity, MutableStateTrackable updatableProxy) {
        int updated;
        if (!this.rootUpdateAllowed && entity == null) {
            throw new IllegalArgumentException("Updating instances of the view type [" + updatableProxy.getClass().getName() + "] is not allowed because no entity id is known!");
        }
        DirtyAttributeFlusher flusher = this.getNestedDirtyFlusher(context, updatableProxy, null);
        if (flusher == null) {
            return false;
        }
        if (this.flushStrategy == FlushStrategy.ENTITY || context.isForceEntity() || !flusher.supportsQueryFlush()) {
            return flusher.flushEntity(context, entity, updatableProxy, updatableProxy, updatableProxy, null);
        }
        int orphanRemovalStartIndex = context.getOrphanRemovalDeleters().size();
        Query query = flusher.flushQuery(context, null, this, null, updatableProxy, updatableProxy, updatableProxy, null, flusher);
        if (query != null && (updated = query.executeUpdate()) != 1) {
            throw new OptimisticLockException("The update operation did not return the expected update count!", entity, (Object)updatableProxy);
        }
        context.removeOrphans(orphanRemovalStartIndex);
        return true;
    }

    @Override
    public Object executePersist(UpdateContext context, MutableStateTrackable updatableProxy) {
        Object entity = this.fullEntityLoader.toEntity(context, updatableProxy, null);
        return this.executePersist(context, entity, updatableProxy);
    }

    @Override
    public Object executePersist(UpdateContext context, Object entity, MutableStateTrackable updatableProxy) {
        this.fullFlusher.flushEntity(context, entity, (Object)updatableProxy, (Object)updatableProxy, updatableProxy, (Runnable)null);
        return entity;
    }

    @Override
    public void remove(UpdateContext context, EntityViewProxy entityView) {
        if (this.flushStrategy == FlushStrategy.ENTITY) {
            // empty if block
        }
        this.fullFlusher.remove(context, (Object)null, (Object)entityView, entityView);
    }

    @Override
    public void remove(UpdateContext context, Object viewId) {
        this.fullFlusher.remove(context, viewId);
    }

    private DirtyAttributeFlusher<?, ?, ?> createAttributeFlusher(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewTypeImplementor<?> viewType, String idAttributeName, FlushStrategy flushStrategy, AbstractMethodAttribute<?, ?> attribute, DirtyAttributeFlusher<?, ?, ?> ownerIdFlusher, EntityViewUpdaterImpl owner, String ownerMapping) {
        if (attribute.isCollection()) {
            String idMapping = owner == null ? idAttributeName : (owner.idFlusher instanceof EmbeddableAttributeFlusher ? ((EmbeddableAttributeFlusher)owner.idFlusher).getMapping() : ((BasicAttributeFlusher)owner.idFlusher).getMapping());
            return this.createPluralAttributeFlusher(evm, localCache, viewType, idMapping, flushStrategy, attribute, owner == null ? ownerIdFlusher : owner.idFlusher, owner, ownerMapping);
        }
        return this.createSingularAttributeFlusher(evm, localCache, viewType, attribute, owner, ownerMapping);
    }

    private DirtyAttributeFlusher<?, ?, ?> createPluralAttributeFlusher(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewTypeImplementor<?> viewType, String idAttributeName, FlushStrategy flushStrategy, AbstractMethodAttribute<?, ?> attribute, DirtyAttributeFlusher<?, ?, ?> ownerIdFlusher, EntityViewUpdaterImpl owner, String ownerMapping) {
        DirtyAttributeFlusher<?, ?, ?> attributeOwnerFlusher;
        EntityType ownerEntityType;
        EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
        Class<?> entityClass = viewType.getEntityClass();
        ExtendedManagedType managedType = (ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, (Class)entityClass);
        String attributeName = attribute.getName();
        String attributeMapping = attribute.getMapping();
        AttributeAccessor entityAttributeAccessor = Accessors.forEntityMapping(evm, attribute);
        boolean cascadeDelete = attribute.isDeleteCascaded();
        boolean viewOnlyDeleteCascaded = cascadeDelete && !managedType.getAttribute(attributeMapping).isDeleteCascaded();
        boolean optimisticLockProtected = attribute.isOptimisticLockProtected();
        JpaProvider jpaProvider = evm.getJpaProvider();
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        InitialValueAttributeAccessor viewAttributeAccessor = Accessors.forMutableViewAttribute(evm, attribute);
        ManagedType<?> ownerManagedType = owner == null ? viewType.getJpaManagedType() : owner.managedViewType.getJpaManagedType();
        EntityType entityType = ownerEntityType = ownerManagedType instanceof EntityType ? (EntityType)ownerManagedType : null;
        if (attributeMapping == null || ownerEntityType == null) {
            attributeOwnerFlusher = ownerIdFlusher;
        } else {
            Map joinTableOwnerProperties = ownerMapping == null ? jpaProvider.getJoinMappingPropertyNames(ownerEntityType, ownerMapping, attributeMapping) : jpaProvider.getJoinMappingPropertyNames(ownerEntityType, ownerMapping, ownerMapping + "." + attributeMapping);
            if (joinTableOwnerProperties.size() != 1) {
                String idMapping = ownerIdFlusher.getMapping();
                String prefix = idMapping.endsWith(".") ? idMapping : idMapping + ".";
                for (String joinTableOwnerProperty : joinTableOwnerProperties.keySet()) {
                    if (joinTableOwnerProperty.startsWith(prefix)) continue;
                    throw new IllegalArgumentException("Multiple joinable owner properties for attribute '" + attributeName + "' of " + ownerEntityType.getJavaType().getName() + " found which is not yet supported. Consider using the primary key instead!");
                }
                attributeOwnerFlusher = ownerIdFlusher;
            } else {
                attributeOwnerFlusher = ownerIdFlusher.getMapping().equals(joinTableOwnerProperties.values().iterator().next()) ? ownerIdFlusher : this.findSingularAttributeFlusherByMapping(evm, localCache, owner, viewType, attributeName, (String)joinTableOwnerProperties.keySet().iterator().next());
            }
        }
        TypeDescriptor elementDescriptor = TypeDescriptor.forType(evm, localCache, this, attribute, pluralAttribute.getElementType(), owner, ownerMapping);
        boolean collectionUpdatable = attribute.isUpdatable();
        CollectionRemoveListener elementRemoveListener = EntityViewUpdaterImpl.createOrphanRemoveListener(attribute, elementDescriptor);
        CollectionRemoveListener elementCascadeDeleteListener = EntityViewUpdaterImpl.createCascadeDeleteListener(attribute, elementDescriptor);
        boolean supportsCollectionDml = jpaProvider.supportsInsertStatement();
        boolean jpaProviderDeletesCollection = elementDescriptor.getAttributeIdAttributeName() != null ? jpaProvider.supportsJoinTableCleanupOnDelete() : jpaProvider.supportsCollectionTableCleanupOnDelete();
        if (attribute instanceof MapAttribute) {
            MapAttribute mapAttribute = (MapAttribute)attribute;
            TypeDescriptor keyDescriptor = TypeDescriptor.forType(evm, localCache, this, attribute, mapAttribute.getKeyType(), owner, ownerMapping);
            CollectionRemoveListener keyRemoveListener = null;
            CollectionRemoveListener keyCascadeDeleteListener = null;
            if (collectionUpdatable || keyDescriptor.shouldFlushMutations() || elementDescriptor.shouldFlushMutations() || EntityViewUpdaterImpl.shouldPassThrough(evm, viewType, attribute)) {
                SimpleMapViewToEntityMapper mapper = new SimpleMapViewToEntityMapper(keyDescriptor.getViewToEntityMapper(), elementDescriptor.getViewToEntityMapper());
                SimpleMapViewToEntityMapper loadOnlyMapper = new SimpleMapViewToEntityMapper(keyDescriptor.getLoadOnlyViewToEntityMapper(), elementDescriptor.getLoadOnlyViewToEntityMapper());
                MapInstantiatorImplementor<?, ?> mapInstantiator = attribute.getMapInstantiator();
                return new MapAttributeFlusher(attributeName, attributeMapping, owner == null ? entityClass : owner.fullEntityLoader.getEntityClass(), idAttributeName, ownerMapping, attributeOwnerFlusher, this.createPluralAttributeSubFlusher(evm, localCache, viewType, attribute, "element", mapAttribute.getElementType(), owner, ownerMapping), supportsCollectionDml, flushStrategy, entityAttributeAccessor, viewAttributeAccessor, optimisticLockProtected, collectionUpdatable, keyCascadeDeleteListener, elementCascadeDeleteListener, keyRemoveListener, elementRemoveListener, viewOnlyDeleteCascaded, jpaProviderDeletesCollection, keyDescriptor, elementDescriptor, mapper, loadOnlyMapper, mapInstantiator);
            }
            return null;
        }
        if (collectionUpdatable || elementDescriptor.shouldFlushMutations() || EntityViewUpdaterImpl.shouldPassThrough(evm, viewType, attribute)) {
            InverseFlusher inverseFlusher = InverseFlusher.forAttribute(evm, localCache, viewType, attribute, elementDescriptor, owner, ownerMapping);
            InverseRemoveStrategy inverseRemoveStrategy = attribute.getInverseRemoveStrategy();
            CollectionInstantiatorImplementor<?, ?> collectionInstantiator = attribute.getCollectionInstantiator();
            if (pluralAttribute.isIndexed()) {
                return new IndexedListAttributeFlusher(attributeName, attributeMapping, owner == null ? entityClass : owner.fullEntityLoader.getEntityClass(), idAttributeName, ownerMapping, attributeOwnerFlusher, this.createPluralAttributeSubFlusher(evm, localCache, viewType, attribute, "element", pluralAttribute.getElementType(), owner, ownerMapping), supportsCollectionDml, flushStrategy, entityAttributeAccessor, viewAttributeAccessor, optimisticLockProtected, collectionUpdatable, viewOnlyDeleteCascaded, jpaProviderDeletesCollection, elementCascadeDeleteListener, elementRemoveListener, collectionInstantiator, elementDescriptor, inverseFlusher, inverseRemoveStrategy);
            }
            return new CollectionAttributeFlusher(attributeName, attributeMapping, owner == null ? entityClass : owner.fullEntityLoader.getEntityClass(), idAttributeName, ownerMapping, attributeOwnerFlusher, this.createPluralAttributeSubFlusher(evm, localCache, viewType, attribute, "element", pluralAttribute.getElementType(), owner, ownerMapping), supportsCollectionDml, flushStrategy, entityAttributeAccessor, viewAttributeAccessor, optimisticLockProtected, collectionUpdatable, viewOnlyDeleteCascaded, jpaProviderDeletesCollection, elementCascadeDeleteListener, elementRemoveListener, collectionInstantiator, elementDescriptor, inverseFlusher, inverseRemoveStrategy);
        }
        return null;
    }

    private DirtyAttributeFlusher<?, ?, ?> findSingularAttributeFlusherByMapping(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, EntityViewUpdaterImpl owner, ManagedViewTypeImplementor<?> viewType, String attributeName, String mapping) {
        ManagedViewTypeImplementor<?> managedViewTypeImplementor = owner == null ? viewType : owner.managedViewType;
        for (MethodAttribute attribute : managedViewTypeImplementor.getAttributes()) {
            if (!(attribute instanceof com.blazebit.persistence.view.metamodel.SingularAttribute) || !mapping.equals(((MappingAttribute)attribute).getMapping())) continue;
            return EntityViewUpdaterImpl.createIdFlusher(evm, localCache, (ViewType)managedViewTypeImplementor, EntityViewUpdaterImpl.createViewIdMapper(evm, localCache, (com.blazebit.persistence.view.metamodel.SingularAttribute)attribute), (AbstractMethodAttribute)attribute);
        }
        throw new IllegalArgumentException("Can't create plural attribute flusher for entity view attribute " + attributeName + " because owner entity view " + managedViewTypeImplementor.getJavaType().getName() + " is missing an attribute for the join key attributes: " + mapping);
    }

    private DirtyAttributeFlusher<?, ?, ?> createPluralAttributeSubFlusher(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewTypeImplementor<?> viewType, AbstractMethodAttribute<?, ?> attribute, String name, Type<?> type, EntityViewUpdaterImpl owner, String ownerMapping) {
        EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
        String attributeName = attribute.getName() + WHERE_CLAUSE_PREFIX + name;
        String attributeMapping = attribute.getMapping();
        String attributeLocation = attribute.getLocation();
        Set readOnlyAllowedSubtypes = attribute.getReadOnlyAllowedSubtypes();
        Set persistAllowedSubtypes = attribute.getPersistCascadeAllowedSubtypes();
        Set<Type<?>> updateAllowedSubtypes = attribute.getUpdateCascadeAllowedSubtypes();
        if (type instanceof ManagedViewType) {
            List<String> idComponentMappings;
            String attributeElementIdMapping;
            EntityType ownerEntityType;
            ManagedViewTypeImplementor subviewType = (ManagedViewTypeImplementor)type;
            if (!(subviewType.getJpaManagedType() instanceof EntityType)) {
                EmbeddableUpdaterBasedViewToEntityMapper viewToEntityMapper = new EmbeddableUpdaterBasedViewToEntityMapper(attributeLocation, evm, subviewType.getJavaType(), readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, EntityLoaders.referenceLoaderForAttribute(evm, localCache, subviewType, attribute), false, null, owner, ownerMapping == null ? attributeMapping : ownerMapping + "." + attributeMapping, localCache);
                String parameterName = attributeName + WHERE_CLAUSE_PREFIX;
                String updateFragment = attributeMapping + ".";
                return new EmbeddableAttributeFlusher(attributeName, attributeMapping, updateFragment, parameterName, false, false, false, null, null, viewToEntityMapper);
            }
            ViewTypeImplementor attributeViewType = (ViewTypeImplementor)subviewType;
            InitialValueAttributeAccessor viewAttributeAccessor = Accessors.forMutableViewAttribute(evm, attribute);
            ManagedType<?> ownerManagedType = owner == null ? viewType.getJpaManagedType() : owner.managedViewType.getJpaManagedType();
            EntityType entityType = ownerEntityType = ownerManagedType instanceof EntityType ? (EntityType)ownerManagedType : null;
            if (ownerEntityType != null && attribute.getMapping() != null) {
                ExtendedManagedType extendedManagedType = (ExtendedManagedType)evm.getMetamodel().getEntityMetamodel().getManagedType(ExtendedManagedType.class, attributeViewType.getEntityClass());
                attributeElementIdMapping = TypeDescriptor.getAttributeElementIdentifier(evm, ownerEntityType, attribute.getName(), ownerMapping, attribute.getMapping(), extendedManagedType.getType());
            } else {
                attributeElementIdMapping = ((MappingAttribute)attributeViewType.getIdAttribute()).getMapping();
            }
            AttributeAccessor subviewIdAccessor = Accessors.forSubviewAssociationId(evm, attributeViewType, attributeElementIdMapping, true);
            Attribute attributeIdAttribute = attributeViewType.getJpaManagedType().getAttribute(attributeElementIdMapping);
            jakarta.persistence.metamodel.Type attributeIdAttributeType = entityMetamodel.type(JpaMetamodelUtils.resolveFieldClass((Class)attributeViewType.getEntityClass(), (Attribute)attributeIdAttribute));
            boolean requiresComponentWiseSetInUpdate = true;
            if (requiresComponentWiseSetInUpdate && attributeIdAttributeType instanceof EmbeddableType) {
                Set idAttributeComponents = ((EmbeddableType)attributeIdAttributeType).getAttributes();
                idComponentMappings = new ArrayList<String>(idAttributeComponents.size());
                for (Attribute idAttributeComponent : idAttributeComponents) {
                    idComponentMappings.add(attributeMapping + "." + attributeElementIdMapping + "." + idAttributeComponent);
                }
            } else {
                idComponentMappings = Collections.singletonList(attributeMapping + "." + attributeElementIdMapping);
            }
            String[] idAttributeMappings = idComponentMappings.toArray(new String[idComponentMappings.size()]);
            ViewToEntityMapper viewToEntityMapper = EntityViewUpdaterImpl.createViewToEntityMapper(attributeLocation, evm, localCache, ownerEntityType, attributeName, attributeMapping, attributeViewType, false, false, readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, EntityLoaders.referenceLoaderForAttribute(evm, localCache, attributeViewType, attribute.getViewTypes(), attributeElementIdMapping), owner, ownerMapping);
            String parameterName = attributeName;
            return new SubviewAttributeFlusher(attributeName, attributeMapping, false, true, false, false, false, subviewType.getConverter(), false, idAttributeMappings, parameterName, false, owner != null, null, viewAttributeAccessor, subviewIdAccessor, viewToEntityMapper, null, null);
        }
        TypeDescriptor elementDescriptor = TypeDescriptor.forType(evm, localCache, this, attribute, type, owner, ownerMapping);
        String parameterName = attributeName;
        String updateFragment = attributeMapping;
        boolean supportsQueryFlush = !elementDescriptor.isJpaEmbeddable();
        return new BasicAttributeFlusher(attributeName, attributeMapping, supportsQueryFlush, false, true, false, false, false, null, evm.getJpaProvider(), elementDescriptor, updateFragment, parameterName, null, null, null, null, null);
    }

    private DirtyAttributeFlusher<?, ?, ?> createSingularAttributeFlusher(EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewTypeImplementor<?> viewType, AbstractMethodAttribute<?, ?> attribute, EntityViewUpdaterImpl owner, String ownerMapping) {
        EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
        Class entityClass = viewType.getEntityClass();
        String attributeName = attribute.getName();
        String attributeMapping = attribute.getMapping();
        AttributeAccessor entityAttributeAccessor = Accessors.forEntityMapping(evm, attribute);
        String attributeLocation = attribute.getLocation();
        boolean cascadePersist = attribute.isPersistCascaded();
        boolean cascadeUpdate = attribute.isUpdateCascaded();
        boolean cascadeDelete = attribute.isDeleteCascaded();
        boolean viewOnlyDeleteCascaded = cascadeDelete && !((ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, entityClass)).getAttribute(attributeMapping).isDeleteCascaded();
        boolean optimisticLockProtected = attribute.isOptimisticLockProtected();
        Set readOnlyAllowedSubtypes = attribute.getReadOnlyAllowedSubtypes();
        Set persistAllowedSubtypes = attribute.getPersistCascadeAllowedSubtypes();
        Set<Type<?>> updateAllowedSubtypes = attribute.getUpdateCascadeAllowedSubtypes();
        JpaProvider jpaProvider = evm.getJpaProvider();
        if (attribute.isSubview()) {
            boolean shouldFlushUpdates = cascadeUpdate && !updateAllowedSubtypes.isEmpty();
            boolean shouldFlushPersists = cascadePersist && !persistAllowedSubtypes.isEmpty();
            ManagedViewTypeImplementor subviewType = (ManagedViewTypeImplementor)((com.blazebit.persistence.view.metamodel.SingularAttribute)attribute).getType();
            boolean passThrough = false;
            if (attribute.isUpdatable() || shouldFlushUpdates || (passThrough = EntityViewUpdaterImpl.shouldPassThrough(evm, viewType, attribute))) {
                ViewToEntityMapper viewToEntityMapper;
                List<String> idComponentMappings;
                String attributeElementIdMapping;
                if (!(subviewType.getJpaManagedType() instanceof EntityType)) {
                    String updateFragment;
                    String parameterName;
                    boolean supportsQueryFlush;
                    AttributeAccessor viewAttributeAccessor = Accessors.forViewAttribute(evm, attribute, true);
                    EmbeddableUpdaterBasedViewToEntityMapper viewToEntityMapper2 = new EmbeddableUpdaterBasedViewToEntityMapper(attributeLocation, evm, subviewType.getJavaType(), readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, EntityLoaders.referenceLoaderForAttribute(evm, localCache, subviewType, attribute), shouldFlushPersists, null, owner == null ? this : owner, ownerMapping == null ? attributeMapping : ownerMapping + "." + attributeMapping, localCache);
                    CompositeAttributeFlusher nestedFlusher = (CompositeAttributeFlusher)viewToEntityMapper2.getFullGraphNode();
                    boolean bl = supportsQueryFlush = nestedFlusher.supportsQueryFlush() && jpaProvider.supportsUpdateSetEmbeddable();
                    if (supportsQueryFlush) {
                        parameterName = attributeName;
                        updateFragment = attributeMapping;
                    } else {
                        parameterName = attributeName + WHERE_CLAUSE_PREFIX;
                        updateFragment = attributeMapping + ".";
                    }
                    return new EmbeddableAttributeFlusher(attributeName, attributeMapping, updateFragment, parameterName, optimisticLockProtected, passThrough, supportsQueryFlush, entityAttributeAccessor, viewAttributeAccessor, viewToEntityMapper2);
                }
                ViewTypeImplementor attributeViewType = (ViewTypeImplementor)subviewType;
                InitialValueAttributeAccessor viewAttributeAccessor = Accessors.forMutableViewAttribute(evm, attribute);
                InverseFlusher inverseFlusher = InverseFlusher.forAttribute(evm, localCache, viewType, attribute, TypeDescriptor.forType(evm, localCache, this, attribute, subviewType, owner, ownerMapping), owner, ownerMapping);
                InverseRemoveStrategy inverseRemoveStrategy = attribute.getInverseRemoveStrategy();
                ManagedType<?> ownerEntityType = owner == null ? viewType.getJpaManagedType() : owner.managedViewType.getJpaManagedType();
                boolean fetch = shouldFlushUpdates;
                String parameterName = null;
                if (ownerEntityType instanceof EntityType && attribute.getMapping() != null) {
                    ExtendedManagedType extendedManagedType = (ExtendedManagedType)evm.getMetamodel().getEntityMetamodel().getManagedType(ExtendedManagedType.class, attributeViewType.getEntityClass());
                    attributeElementIdMapping = TypeDescriptor.getAttributeElementIdentifier(evm, (EntityType)ownerEntityType, attribute.getName(), ownerMapping, attribute.getMapping(), extendedManagedType.getType());
                } else {
                    attributeElementIdMapping = ((MappingAttribute)attributeViewType.getIdAttribute()).getMapping();
                }
                AttributeAccessor subviewIdAccessor = Accessors.forSubviewAssociationId(evm, attributeViewType, attributeElementIdMapping, true);
                Attribute attributeIdAttribute = attributeViewType.getJpaManagedType().getAttribute(attributeElementIdMapping);
                jakarta.persistence.metamodel.Type attributeIdAttributeType = entityMetamodel.type(JpaMetamodelUtils.resolveFieldClass((Class)attributeViewType.getEntityClass(), (Attribute)attributeIdAttribute));
                boolean requiresComponentWiseSetInUpdate = true;
                if (requiresComponentWiseSetInUpdate && attributeIdAttributeType instanceof EmbeddableType) {
                    Set idAttributeComponents = ((EmbeddableType)attributeIdAttributeType).getAttributes();
                    idComponentMappings = new ArrayList<String>(idAttributeComponents.size());
                    for (Attribute idAttributeComponent : idAttributeComponents) {
                        idComponentMappings.add(attributeMapping + "." + attributeElementIdMapping + "." + idAttributeComponent.getName());
                    }
                } else {
                    idComponentMappings = Collections.singletonList(attributeMapping + "." + attributeElementIdMapping);
                }
                String[] idAttributeMappings = idComponentMappings.toArray(new String[idComponentMappings.size()]);
                if (attribute.isUpdatable() && ownerEntityType instanceof EntityType) {
                    viewToEntityMapper = EntityViewUpdaterImpl.createViewToEntityMapper(attributeLocation, evm, localCache, (EntityType)ownerEntityType, attributeName, attributeMapping, attributeViewType, cascadePersist, cascadeUpdate, readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, EntityLoaders.referenceLoaderForAttribute(evm, localCache, attributeViewType, attribute.getViewTypes(), attributeElementIdMapping), owner, ownerMapping);
                    parameterName = attributeName;
                } else {
                    String elementIdentifier = ownerEntityType instanceof EntityType ? TypeDescriptor.getAttributeElementIdentifier(evm, (EntityType)ownerEntityType, attributeName, ownerMapping, attributeMapping, attributeViewType.getJpaManagedType()) : null;
                    AttributeAccessor entityIdAccessor = Accessors.forEntityMapping(evm, attributeViewType.getEntityClass(), elementIdentifier);
                    viewToEntityMapper = shouldFlushUpdates ? new UpdaterBasedViewToEntityMapper(attributeLocation, evm, subviewType.getJavaType(), readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, EntityLoaders.referenceLoaderForAttribute(evm, localCache, subviewType, attribute), subviewIdAccessor, entityIdAccessor, shouldFlushPersists, owner, ownerMapping, localCache) : (!shouldFlushPersists && EntityViewUpdaterImpl.shouldPassThrough(evm, viewType, attribute) ? new LoadOnlyViewToEntityMapper(EntityLoaders.referenceLoaderForAttribute(evm, localCache, subviewType, attribute), subviewIdAccessor, entityIdAccessor) : new LoadOrPersistViewToEntityMapper(attributeLocation, evm, subviewType.getJavaType(), readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, EntityLoaders.referenceLoaderForAttribute(evm, localCache, subviewType, attribute), subviewIdAccessor, entityIdAccessor, shouldFlushPersists, owner, ownerMapping, localCache));
                }
                return new SubviewAttributeFlusher(attributeName, attributeMapping, optimisticLockProtected, attribute.isUpdatable(), cascadeDelete, attribute.isOrphanRemoval(), viewOnlyDeleteCascaded, subviewType.getConverter(), fetch, idAttributeMappings, parameterName, passThrough, owner != null, entityAttributeAccessor, viewAttributeAccessor, subviewIdAccessor, viewToEntityMapper, inverseFlusher, inverseRemoveStrategy);
            }
            return null;
        }
        BasicTypeImpl attributeType = (BasicTypeImpl)((com.blazebit.persistence.view.metamodel.SingularAttribute)attribute).getType();
        TypeDescriptor elementDescriptor = TypeDescriptor.forType(evm, localCache, this, attribute, attributeType, owner, ownerMapping);
        boolean updatable = attribute.isUpdatable();
        if (updatable || elementDescriptor.shouldFlushMutations() || EntityViewUpdaterImpl.shouldPassThrough(evm, viewType, attribute)) {
            UnmappedBasicAttributeCascadeDeleter deleter;
            ManagedType<?> ownerEntityType;
            InverseFlusher inverseFlusher = InverseFlusher.forAttribute(evm, localCache, viewType, attribute, elementDescriptor, owner, ownerMapping);
            InverseRemoveStrategy inverseRemoveStrategy = attribute.getInverseRemoveStrategy();
            String parameterName = attributeName;
            String updateFragment = attributeMapping;
            ManagedType<?> managedType = ownerEntityType = owner == null ? viewType.getJpaManagedType() : owner.managedViewType.getJpaManagedType();
            if (elementDescriptor.isJpaEntity() && cascadeDelete && ownerEntityType instanceof EntityType) {
                String elementIdAttributeName = TypeDescriptor.getAttributeElementIdentifier(evm, (EntityType)ownerEntityType, attributeName, ownerMapping, attributeMapping, attributeType.getManagedType());
                deleter = new UnmappedBasicAttributeCascadeDeleter(evm, attributeName, ((ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, entityClass)).getAttribute(attributeMapping), attributeMapping + "." + elementIdAttributeName, false);
            } else {
                deleter = null;
            }
            AttributeAccessor viewAttributeAccessor = elementDescriptor.shouldFlushMutations() ? Accessors.forMutableViewAttribute(evm, attribute) : Accessors.forViewAttribute(evm, attribute, true);
            Map.Entry[] componentFlusherEntries = null;
            if (elementDescriptor.isJpaEmbeddable() && !jpaProvider.supportsUpdateSetEmbeddable()) {
                Set attributes = attributeType.getManagedType().getAttributes();
                HashMap<AttributeAccessor, BasicAttributeFlusher> componentFlushers = new HashMap<AttributeAccessor, BasicAttributeFlusher>(attributes.size());
                EntityViewUpdaterImpl.buildComponentFlushers(evm, viewType.getEntityClass(), attributeType.getJavaType(), attributeName + WHERE_CLAUSE_PREFIX, attributeMapping + ".", "", attributes, componentFlushers);
                componentFlusherEntries = componentFlushers.entrySet().toArray(new Map.Entry[componentFlushers.size()]);
            }
            return new BasicAttributeFlusher(attributeName, attributeMapping, true, optimisticLockProtected, updatable, cascadeDelete, attribute.isOrphanRemoval(), viewOnlyDeleteCascaded, componentFlusherEntries, evm.getJpaProvider(), elementDescriptor, updateFragment, parameterName, entityAttributeAccessor, viewAttributeAccessor, deleter, inverseFlusher, inverseRemoveStrategy);
        }
        return null;
    }

    private static CollectionRemoveListener createOrphanRemoveListener(AbstractMethodAttribute<?, ?> attribute, TypeDescriptor elementDescriptor) {
        if (!attribute.isOrphanRemoval()) {
            return null;
        }
        return EntityViewUpdaterImpl.createCollectionRemoveListener(elementDescriptor);
    }

    private static CollectionRemoveListener createCascadeDeleteListener(AbstractMethodAttribute<?, ?> attribute, TypeDescriptor elementDescriptor) {
        if (!attribute.isDeleteCascaded()) {
            return null;
        }
        return EntityViewUpdaterImpl.createCollectionRemoveListener(elementDescriptor);
    }

    private static CollectionRemoveListener createCollectionRemoveListener(TypeDescriptor elementDescriptor) {
        if (elementDescriptor.isSubview()) {
            return new ViewCollectionRemoveListener(elementDescriptor.getLoadOnlyViewToEntityMapper());
        }
        return EntityCollectionRemoveListener.INSTANCE;
    }

    private static boolean shouldPassThrough(EntityViewManagerImpl evm, ManagedViewType<?> viewType, AbstractMethodAttribute<?, ?> attribute) {
        return evm.getMetamodel().getEntityMetamodel().getEntity(viewType.getEntityClass()) == null && attribute.isUpdateMappable();
    }

    private static ViewToEntityMapper createViewToEntityMapper(String attributeLocation, EntityViewManagerImpl evm, Map<Object, EntityViewUpdaterImpl> localCache, EntityType<?> ownerEntityType, String attributeName, String attributeMapping, ViewTypeImplementor<?> viewType, boolean cascadePersist, boolean cascadeUpdate, Set<Type<?>> readOnlyAllowedSubtypes, Set<Type<?>> persistAllowedSubtypes, Set<Type<?>> updateAllowedSubtypes, EntityLoader entityLoader, EntityViewUpdaterImpl owner, String ownerMapping) {
        boolean mutable;
        String elementIdentifier = ownerEntityType == null ? null : TypeDescriptor.getAttributeElementIdentifier(evm, ownerEntityType, attributeName, ownerMapping, attributeMapping, viewType.getJpaManagedType());
        AttributeAccessor viewIdAccessor = Accessors.forSubviewAssociationId(evm, viewType, elementIdentifier, true);
        AttributeAccessor entityIdAccessor = Accessors.forEntityMapping(evm, viewType.getEntityClass(), elementIdentifier);
        Class viewTypeClass = viewType.getJavaType();
        boolean bl = mutable = viewType.isUpdatable() || viewType.isCreatable() || !persistAllowedSubtypes.isEmpty() || !updateAllowedSubtypes.isEmpty();
        if (!mutable || !cascadeUpdate) {
            return new LoadOrPersistViewToEntityMapper(attributeLocation, evm, viewTypeClass, readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, entityLoader, viewIdAccessor, entityIdAccessor, cascadePersist, owner, ownerMapping, localCache);
        }
        return new UpdaterBasedViewToEntityMapper(attributeLocation, evm, viewTypeClass, readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, entityLoader, viewIdAccessor, entityIdAccessor, cascadePersist, owner, ownerMapping, localCache);
    }
}

