/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update;

import com.blazebit.persistence.view.ViewTransition;
import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import com.blazebit.persistence.view.impl.tx.SynchronizationRegistry;
import com.blazebit.persistence.view.impl.update.InitialStateResetter;
import com.blazebit.persistence.view.impl.update.ListenerManager;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionSupport;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import com.blazebit.persistence.view.spi.type.DirtyTracker;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import jakarta.persistence.EntityManager;
import jakarta.transaction.Synchronization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class ResetInitialStateSynchronization
implements Synchronization,
InitialStateResetter {
    private static final Object NO_ID_MARKER = new Object();
    private final UpdateContext updateContext;
    private final ListenerManager listenerManager;
    private List<Object[]> coalescedInitialStates;
    private List<Object> coalescedRecordingActions;
    private List<Object> persistedViews;
    private List<Object> updatedViews;
    private List<Object> removedViews;
    private List<Object> versionedViews;

    public ResetInitialStateSynchronization(UpdateContext updateContext, ListenerManager listenerManager) {
        this.updateContext = updateContext;
        this.listenerManager = listenerManager;
    }

    @Override
    public void addRecordingCollection(RecordingCollection<?, ?> recordingCollection, List<? extends CollectionAction<?>> actions, Map<?, ?> addedElements, Map<?, ?> removedElements) {
        if (this.coalescedRecordingActions == null) {
            this.coalescedRecordingActions = new ArrayList<Object>();
        }
        this.coalescedRecordingActions.add(recordingCollection);
        this.coalescedRecordingActions.add(actions);
        this.coalescedRecordingActions.add(addedElements);
        this.coalescedRecordingActions.add(removedElements);
    }

    @Override
    public void addRecordingMap(RecordingMap<?, ?, ?> recordingMap, List<? extends MapAction<?>> actions, Map<?, ?> addedKeys, Map<?, ?> removedKeys, Map<?, ?> addedElements, Map<?, ?> removedElements) {
        if (this.coalescedRecordingActions == null) {
            this.coalescedRecordingActions = new ArrayList<Object>();
        }
        this.coalescedRecordingActions.add(recordingMap);
        this.coalescedRecordingActions.add(actions);
        this.coalescedRecordingActions.add(addedKeys);
        this.coalescedRecordingActions.add(removedKeys);
        this.coalescedRecordingActions.add(addedElements);
        this.coalescedRecordingActions.add(removedElements);
    }

    @Override
    public int addPersistedView(MutableStateTrackable persistedView) {
        if (this.persistedViews == null) {
            this.persistedViews = new ArrayList<Object>();
        }
        persistedView.$$_setIsNew(false);
        this.persistedViews.add(persistedView);
        this.persistedViews.add(null);
        this.persistedViews.add(NO_ID_MARKER);
        this.persistedViews.add(persistedView.$$_getParent());
        this.persistedViews.add(persistedView.$$_getParentIndex());
        this.persistedViews.add(persistedView.$$_getReadOnlyParents() == null || persistedView.$$_getReadOnlyParents().isEmpty() ? Collections.emptyList() : new ArrayList(persistedView.$$_getReadOnlyParents()));
        this.persistedViews.add(persistedView.$$_resetDirty());
        return this.persistedViews.size() - 6;
    }

    @Override
    public int addPersistedView(MutableStateTrackable persistedView, Object oldId) {
        if (this.persistedViews == null) {
            this.persistedViews = new ArrayList<Object>();
        }
        persistedView.$$_setIsNew(false);
        this.persistedViews.add(persistedView);
        this.persistedViews.add(null);
        this.persistedViews.add(oldId);
        this.persistedViews.add(persistedView.$$_getParent());
        this.persistedViews.add(persistedView.$$_getParentIndex());
        this.persistedViews.add(persistedView.$$_getReadOnlyParents() == null || persistedView.$$_getReadOnlyParents().isEmpty() ? Collections.emptyList() : new ArrayList(persistedView.$$_getReadOnlyParents()));
        this.persistedViews.add(persistedView.$$_resetDirty());
        return this.persistedViews.size() - 6;
    }

    @Override
    public void addPersistedViewNewObject(int newObjectIndex, Object newObject) {
        this.persistedViews.set(newObjectIndex, newObject);
    }

    @Override
    public long[] addUpdatedView(MutableStateTrackable updatedView) {
        if (this.updatedViews == null) {
            this.updatedViews = new ArrayList<Object>();
        }
        long[] dirtyMask = updatedView.$$_resetDirty();
        this.updatedViews.add(updatedView);
        this.updatedViews.add(dirtyMask);
        return dirtyMask;
    }

    @Override
    public void addRemovedView(EntityViewProxy view) {
        if (this.removedViews == null) {
            this.removedViews = new ArrayList<Object>();
        }
        this.removedViews.add(view);
        if (view instanceof MutableStateTrackable) {
            MutableStateTrackable removedView = (MutableStateTrackable)view;
            this.removedViews.add(removedView.$$_getParent());
            this.removedViews.add(removedView.$$_getParentIndex());
            this.removedViews.add(removedView.$$_resetDirty());
            removedView.$$_unsetParent();
        } else {
            this.removedViews.add(null);
            this.removedViews.add(null);
            this.removedViews.add(null);
        }
    }

    @Override
    public void addVersionedView(MutableStateTrackable updatedView, Object oldVersion) {
        if (this.versionedViews == null) {
            this.versionedViews = new ArrayList<Object>();
        }
        this.versionedViews.add(updatedView);
        this.versionedViews.add(oldVersion);
    }

    @Override
    public void addState(Object[] reference, Object[] copy) {
        if (this.coalescedInitialStates == null) {
            this.coalescedInitialStates = new ArrayList<Object[]>();
        }
        this.coalescedInitialStates.add(reference);
        this.coalescedInitialStates.add(copy);
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (status != 3) {
            MutableStateTrackable view;
            int i;
            IdentityHashMap<EntityViewProxy, ViewTransition> objects = this.listenerManager.hasPostRollbackListeners() ? new IdentityHashMap<EntityViewProxy, ViewTransition>() : null;
            if (this.coalescedInitialStates != null) {
                for (i = 0; i < this.coalescedInitialStates.size(); i += 2) {
                    Object[] initialState = this.coalescedInitialStates.get(i);
                    Object[] originalInitialState = this.coalescedInitialStates.get(i + 1);
                    for (int j = 0; j < initialState.length; ++j) {
                        initialState[j] = originalInitialState[j];
                    }
                }
            }
            if (this.coalescedRecordingActions != null) {
                for (i = 0; i < this.coalescedRecordingActions.size(); i += 4) {
                    Object collectionReference = this.coalescedRecordingActions.get(i);
                    Object actionList = this.coalescedRecordingActions.get(i + 1);
                    Map added = (Map)this.coalescedRecordingActions.get(i + 2);
                    Map removed = (Map)this.coalescedRecordingActions.get(i + 3);
                    if (collectionReference instanceof RecordingCollection) {
                        RecordingCollection collection = (RecordingCollection)collectionReference;
                        collection.setActions((List)actionList, added, removed);
                        collection.$$_markDirty(-1);
                        continue;
                    }
                    Map addedElements = (Map)this.coalescedRecordingActions.get(i + 4);
                    Map removedElements = (Map)this.coalescedRecordingActions.get(i + 5);
                    RecordingMap collection = (RecordingMap)collectionReference;
                    collection.setActions((List)actionList, added, removed, addedElements, removedElements);
                    collection.$$_markDirty(-1);
                    i += 2;
                }
            }
            if (this.persistedViews != null) {
                for (i = 0; i < this.persistedViews.size(); i += 7) {
                    view = (MutableStateTrackable)this.persistedViews.get(i);
                    Object newObject = this.persistedViews.get(i + 1);
                    view.$$_setIsNew(true);
                    Object id = this.persistedViews.get(i + 2);
                    DirtyTracker parent = (DirtyTracker)this.persistedViews.get(i + 3);
                    int parentIndex = (Integer)this.persistedViews.get(i + 4);
                    List readOnlyParents = (List)this.persistedViews.get(i + 5);
                    if (id != NO_ID_MARKER) {
                        view.$$_setId(id);
                    }
                    if (parent != null) {
                        if (!(parent instanceof RecordingCollection) && !(parent instanceof RecordingMap)) {
                            parent.$$_replaceAttribute(newObject, parentIndex, (Object)view);
                        }
                        for (int j = 0; j < readOnlyParents.size(); j += 2) {
                            DirtyTracker readOnlyParent = (DirtyTracker)readOnlyParents.get(j);
                            int readOnlyParentIndex = (Integer)readOnlyParents.get(j + 1);
                            readOnlyParent.$$_replaceAttribute(newObject, readOnlyParentIndex, (Object)view);
                        }
                    }
                    view.$$_setDirty((long[])this.persistedViews.get(i + 6));
                    if (objects == null) continue;
                    objects.put((EntityViewProxy)view, ViewTransition.PERSIST);
                }
            }
            if (this.updatedViews != null) {
                for (i = 0; i < this.updatedViews.size(); i += 2) {
                    view = (MutableStateTrackable)this.updatedViews.get(i);
                    view.$$_setDirty((long[])this.updatedViews.get(i + 1));
                    if (objects == null) continue;
                    objects.put((EntityViewProxy)view, ViewTransition.UPDATE);
                }
            }
            if (this.removedViews != null) {
                for (i = 0; i < this.removedViews.size(); i += 4) {
                    view = (EntityViewProxy)this.removedViews.get(i);
                    if (view instanceof MutableStateTrackable) {
                        long[] dirtyArray;
                        MutableStateTrackable removedView = view;
                        DirtyTracker parent = (DirtyTracker)this.removedViews.get(i + 1);
                        if (parent != null) {
                            removedView.$$_setParent((BasicDirtyTracker)parent, ((Integer)this.removedViews.get(i + 2)).intValue());
                        }
                        if ((dirtyArray = (long[])this.removedViews.get(i + 3)) != null) {
                            removedView.$$_setDirty(dirtyArray);
                        }
                    }
                    if (objects == null) continue;
                    objects.put((EntityViewProxy)view, ViewTransition.REMOVE);
                }
            }
            if (this.versionedViews != null) {
                for (i = 0; i < this.versionedViews.size(); i += 2) {
                    view = (MutableStateTrackable)this.versionedViews.get(i);
                    view.$$_setVersion(this.versionedViews.get(i + 1));
                }
            }
            if (objects != null) {
                PostRollbackInvoker postRollbackInvoker = new PostRollbackInvoker(this.updateContext, this.listenerManager, objects);
                TransactionSupport txSupport = this.updateContext.getEntityViewManager().getService(TransactionSupport.class);
                if (txSupport == null) {
                    TransactionAccess transactionAccess = this.updateContext.getTransactionAccess();
                    if (transactionAccess instanceof SynchronizationRegistry) {
                        transactionAccess = ((SynchronizationRegistry)transactionAccess).getTransactionAccess();
                    }
                    if (transactionAccess instanceof TransactionSupport) {
                        ((TransactionSupport)transactionAccess).transactional((Runnable)postRollbackInvoker);
                    } else {
                        postRollbackInvoker.run();
                    }
                } else {
                    txSupport.transactional((Runnable)postRollbackInvoker);
                }
            }
        } else if (this.listenerManager.hasPostCommitListeners()) {
            int i;
            if (this.persistedViews != null) {
                for (i = 0; i < this.persistedViews.size(); i += 7) {
                    this.listenerManager.invokePostCommit(this.updateContext, (EntityViewProxy)((MutableStateTrackable)this.persistedViews.get(i)), ViewTransition.PERSIST);
                }
            }
            if (this.updatedViews != null) {
                for (i = 0; i < this.updatedViews.size(); i += 2) {
                    this.listenerManager.invokePostCommit(this.updateContext, (EntityViewProxy)((MutableStateTrackable)this.updatedViews.get(i)), ViewTransition.UPDATE);
                }
            }
            if (this.removedViews != null) {
                for (i = 0; i < this.removedViews.size(); i += 4) {
                    this.listenerManager.invokePostCommit(this.updateContext, (EntityViewProxy)this.removedViews.get(i), ViewTransition.REMOVE);
                }
            }
        }
    }

    private static class PostRollbackInvoker
    implements Runnable {
        private final UpdateContext updateContext;
        private final ListenerManager listenerManager;
        private final Map<EntityViewProxy, ViewTransition> objects;

        public PostRollbackInvoker(UpdateContext updateContext, ListenerManager listenerManager, Map<EntityViewProxy, ViewTransition> objects) {
            this.updateContext = updateContext;
            this.listenerManager = listenerManager;
            this.objects = objects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (EntityManager em = null;){
                em = this.updateContext.getEntityManager().getEntityManagerFactory().createEntityManager();
                for (Map.Entry<EntityViewProxy, ViewTransition> entry : this.objects.entrySet()) {
                    this.listenerManager.invokePostRollback(this.updateContext, entry.getKey(), entry.getValue(), em);
                }
            }
        }
    }
}

