/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;

public class BasicDirtyChecker<V>
implements DirtyChecker<V> {
    protected final TypeDescriptor elementDescriptor;

    public BasicDirtyChecker(TypeDescriptor elementDescriptor) {
        this.elementDescriptor = elementDescriptor;
    }

    @Override
    public <X> DirtyChecker<X>[] getNestedCheckers(V current) {
        return null;
    }

    @Override
    public DirtyChecker.DirtyKind getDirtyKind(V initial, V current) {
        if (current == null) {
            if (initial == null) {
                return DirtyChecker.DirtyKind.NONE;
            }
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (initial == null) {
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (this.elementDescriptor.shouldFlushMutations()) {
            if (this.elementDescriptor.getBasicUserType().supportsDirtyChecking()) {
                String[] dirtyProperties = this.elementDescriptor.getBasicUserType().getDirtyProperties(current);
                if (dirtyProperties == null) {
                    if (this.elementDescriptor.getBasicUserType().isEqual(initial, current)) {
                        return DirtyChecker.DirtyKind.NONE;
                    }
                    return DirtyChecker.DirtyKind.UPDATED;
                }
                return DirtyChecker.DirtyKind.UPDATED;
            }
            if (this.elementDescriptor.getBasicUserType().isDeepEqual(initial, current)) {
                return DirtyChecker.DirtyKind.NONE;
            }
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (this.elementDescriptor.getBasicUserType().isEqual(initial, current)) {
            return DirtyChecker.DirtyKind.NONE;
        }
        return DirtyChecker.DirtyKind.UPDATED;
    }
}

