/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import java.util.ArrayList;
import java.util.List;

public class EmbeddableAttributeFetchGraphNode<X extends EmbeddableAttributeFetchGraphNode<X, T>, T extends FetchGraphNode<?>>
implements FetchGraphNode<X> {
    protected final String attributeName;
    protected final String mapping;
    protected final T nestedGraphNode;

    public EmbeddableAttributeFetchGraphNode(String attributeName, String mapping, T nestedGraphNode) {
        this.attributeName = attributeName;
        this.mapping = mapping;
        this.nestedGraphNode = nestedGraphNode;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public String getMapping() {
        return this.mapping;
    }

    @Override
    public void appendFetchJoinQueryFragment(String base, StringBuilder sb) {
        if (this.nestedGraphNode != null) {
            String newBase = base + "." + this.mapping;
            this.nestedGraphNode.appendFetchJoinQueryFragment(newBase, sb);
        }
    }

    @Override
    public FetchGraphNode<?> mergeWith(List<X> fetchGraphNodes) {
        ArrayList<T> nestedFlushers = new ArrayList<T>(fetchGraphNodes.size());
        for (int i = 0; i < fetchGraphNodes.size(); ++i) {
            EmbeddableAttributeFetchGraphNode node = (EmbeddableAttributeFetchGraphNode)fetchGraphNodes.get(i);
            if (node.nestedGraphNode == null) continue;
            nestedFlushers.add(node.nestedGraphNode);
        }
        if (nestedFlushers.isEmpty()) {
            return this;
        }
        FetchGraphNode firstFlusher = (FetchGraphNode)nestedFlushers.get(0);
        FetchGraphNode<?> fetchGraphNode = firstFlusher.mergeWith(nestedFlushers);
        if (fetchGraphNode == firstFlusher) {
            return this;
        }
        return new EmbeddableAttributeFetchGraphNode(this.attributeName, this.mapping, fetchGraphNode);
    }
}

