/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.AbstractUnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleterUtil;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UnmappedBasicAttributeCascadeDeleter
extends AbstractUnmappedAttributeCascadeDeleter {
    private final String ownerIdAttributeName;
    private final String deleteQuery;
    private final String deleteByOwnerIdQuery;
    private final boolean requiresDeleteCascadeAfterRemove;
    private final boolean requiresDeleteAsEntity;
    private final UnmappedAttributeCascadeDeleter[] unmappedPreRemoveCascadeDeleters;
    private final UnmappedAttributeCascadeDeleter[] unmappedPostRemoveCascadeDeleters;

    public UnmappedBasicAttributeCascadeDeleter(EntityViewManagerImpl evm, String attributeName, ExtendedAttribute<?, ?> attribute, String ownerIdAttributeName, boolean disallowCycle) {
        super(evm, attributeName, attribute);
        EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
        ExtendedManagedType extendedManagedType = (ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, this.elementEntityClass);
        EntityType entityType = (EntityType)extendedManagedType.getType();
        this.requiresDeleteCascadeAfterRemove = !attribute.isForeignJoinColumn();
        String ownerIdPath = ownerIdAttributeName == null || attribute.getMappedBy() == null ? ownerIdAttributeName : attribute.getMappedBy() + "." + ownerIdAttributeName;
        this.ownerIdAttributeName = ownerIdPath;
        this.deleteQuery = "DELETE FROM " + entityType.getName() + " e WHERE e." + this.elementIdAttributeName + " = :id";
        this.deleteByOwnerIdQuery = "DELETE FROM " + entityType.getName() + " e WHERE e." + ownerIdPath + " = :ownerId";
        if (this.elementIdAttributeName == null) {
            this.requiresDeleteAsEntity = false;
            this.unmappedPostRemoveCascadeDeleters = EMPTY;
            this.unmappedPreRemoveCascadeDeleters = EMPTY;
        } else if (disallowCycle && attribute.hasCascadingDeleteCycle()) {
            this.requiresDeleteAsEntity = true;
            this.unmappedPostRemoveCascadeDeleters = EMPTY;
            this.unmappedPreRemoveCascadeDeleters = EMPTY;
        } else {
            List<UnmappedAttributeCascadeDeleter> unmappedCascadeDeleters = UnmappedAttributeCascadeDeleterUtil.createUnmappedCascadeDeleters(evm, this.elementEntityClass, this.elementIdAttributeName);
            ArrayList<UnmappedAttributeCascadeDeleter> unmappedPreRemoveCascadeDeleters = new ArrayList<UnmappedAttributeCascadeDeleter>(unmappedCascadeDeleters.size());
            ArrayList<UnmappedAttributeCascadeDeleter> unmappedPostRemoveCascadeDeleters = new ArrayList<UnmappedAttributeCascadeDeleter>(unmappedCascadeDeleters.size());
            for (UnmappedAttributeCascadeDeleter deleter : unmappedCascadeDeleters) {
                if (deleter.requiresDeleteCascadeAfterRemove()) {
                    unmappedPostRemoveCascadeDeleters.add(deleter);
                    continue;
                }
                unmappedPreRemoveCascadeDeleters.add(deleter);
            }
            this.requiresDeleteAsEntity = false;
            this.unmappedPreRemoveCascadeDeleters = unmappedPreRemoveCascadeDeleters.toArray(new UnmappedAttributeCascadeDeleter[unmappedPreRemoveCascadeDeleters.size()]);
            this.unmappedPostRemoveCascadeDeleters = unmappedPostRemoveCascadeDeleters.toArray(new UnmappedAttributeCascadeDeleter[unmappedPostRemoveCascadeDeleters.size()]);
        }
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        return this.requiresDeleteCascadeAfterRemove;
    }

    @Override
    public void removeById(UpdateContext context, Object id) {
        if (context.invokePreRemove(this.elementEntityClass, id)) {
            for (int i = 0; i < this.unmappedPreRemoveCascadeDeleters.length; ++i) {
                this.unmappedPreRemoveCascadeDeleters[i].removeByOwnerId(context, id);
            }
            this.removeWithoutPreCascadeDelete(context, null, null, id);
        }
    }

    public void remove(UpdateContext context, Object o) {
        if (context.hasRemoveListeners(this.elementEntityClass)) {
            PersistenceUnitUtil persistenceUnitUtil = context.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            Object identifier = persistenceUnitUtil.getIdentifier(o);
            if (context.invokePreRemove(this.elementEntityClass, identifier)) {
                context.getEntityManager().remove(o);
                context.invokePostRemove(this.elementEntityClass, identifier);
            }
        } else {
            context.getEntityManager().remove(o);
        }
    }

    @Override
    public void removeByOwnerId(UpdateContext context, Object ownerId) {
        if (this.requiresDeleteAsEntity) {
            CriteriaBuilder cb = context.getEntityViewManager().getCriteriaBuilderFactory().create(context.getEntityManager(), this.elementEntityClass);
            cb.where(this.ownerIdAttributeName).eq(ownerId);
            if (context.hasRemoveListeners(this.elementEntityClass)) {
                PersistenceUnitUtil persistenceUnitUtil = context.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
                for (Object e : cb.getResultList()) {
                    Object identifier = persistenceUnitUtil.getIdentifier(e);
                    if (!context.invokePreRemove(this.elementEntityClass, identifier)) continue;
                    context.getEntityManager().remove(e);
                    context.invokePostRemove(this.elementEntityClass, identifier);
                }
            } else {
                for (Object o : cb.getResultList()) {
                    context.getEntityManager().remove(o);
                }
            }
            context.getEntityManager().flush();
        } else if (this.unmappedPreRemoveCascadeDeleters.length != 0) {
            ArrayList<String> returningAttributes = new ArrayList<String>();
            for (int i = 0; i < this.unmappedPostRemoveCascadeDeleters.length; ++i) {
                returningAttributes.add(this.unmappedPostRemoveCascadeDeleters[i].getAttributeValuePath());
            }
            CriteriaBuilder cb = context.getEntityViewManager().getCriteriaBuilderFactory().create(context.getEntityManager(), Object[].class);
            cb.from(this.elementEntityClass);
            cb.where(this.ownerIdAttributeName).eq(ownerId);
            for (String string : returningAttributes) {
                cb.select(string);
            }
            cb.select(this.elementIdAttributeName);
            List resultList = cb.getResultList();
            if (!resultList.isEmpty() && resultList.get(0) instanceof Object[]) {
                if (context.hasRemoveListeners(this.elementEntityClass)) {
                    for (Object[] returnedValues : resultList) {
                        Object id = returnedValues[returnedValues.length - 1];
                        if (!context.invokePreRemove(this.elementEntityClass, id)) continue;
                        for (int i = 0; i < this.unmappedPreRemoveCascadeDeleters.length; ++i) {
                            this.unmappedPreRemoveCascadeDeleters[i].removeByOwnerId(context, id);
                        }
                        this.removeWithoutPreCascadeDelete(context, ownerId, returnedValues, id);
                    }
                } else {
                    for (Object[] returnedValues : resultList) {
                        Object id = returnedValues[returnedValues.length - 1];
                        for (int i = 0; i < this.unmappedPreRemoveCascadeDeleters.length; ++i) {
                            this.unmappedPreRemoveCascadeDeleters[i].removeByOwnerId(context, id);
                        }
                        this.removeWithoutPreCascadeDelete(context, ownerId, returnedValues, id);
                    }
                }
            } else if (context.hasRemoveListeners(this.elementEntityClass)) {
                for (Object id : resultList) {
                    if (!context.invokePreRemove(this.elementEntityClass, id)) continue;
                    for (int i = 0; i < this.unmappedPreRemoveCascadeDeleters.length; ++i) {
                        this.unmappedPreRemoveCascadeDeleters[i].removeByOwnerId(context, id);
                    }
                    this.removeWithoutPreCascadeDelete(context, ownerId, null, id);
                }
            } else {
                for (Object id : resultList) {
                    for (int i = 0; i < this.unmappedPreRemoveCascadeDeleters.length; ++i) {
                        this.unmappedPreRemoveCascadeDeleters[i].removeByOwnerId(context, id);
                    }
                    this.removeWithoutPreCascadeDelete(context, ownerId, null, id);
                }
            }
        } else if (context.hasRemoveListeners(this.elementEntityClass)) {
            CriteriaBuilder cb = context.getEntityViewManager().getCriteriaBuilderFactory().create(context.getEntityManager(), Object[].class);
            cb.from(this.elementEntityClass);
            cb.where(this.ownerIdAttributeName).eq(ownerId);
            cb.select(this.elementIdAttributeName);
            List resultList = cb.getResultList();
            for (Object e : resultList) {
                if (!context.invokePreRemove(this.elementEntityClass, e)) continue;
                this.removeWithoutPreCascadeDelete(context, ownerId, null, e);
            }
        } else {
            this.removeWithoutPreCascadeDelete(context, ownerId, null, null);
        }
    }

    private void removeWithoutPreCascadeDelete(UpdateContext context, Object ownerId, Object[] returnedValues, Object id) {
        List<Object> returnedValuesList;
        if (this.unmappedPostRemoveCascadeDeleters.length != 0 && returnedValues == null) {
            CriteriaBuilder cb;
            ArrayList<String> returningAttributes = new ArrayList<String>();
            for (int i = 0; i < this.unmappedPostRemoveCascadeDeleters.length; ++i) {
                returningAttributes.add(this.unmappedPostRemoveCascadeDeleters[i].getAttributeValuePath());
            }
            EntityViewManagerImpl evm = context.getEntityViewManager();
            if (evm.getDbmsDialect().supportsReturningColumns()) {
                cb = evm.getCriteriaBuilderFactory().delete(context.getEntityManager(), this.elementEntityClass);
                if (id == null) {
                    cb.where(this.ownerIdAttributeName).eq(ownerId);
                } else {
                    cb.where(this.elementIdAttributeName).eq(id);
                }
                ReturningResult result = cb.executeWithReturning(returningAttributes.toArray(new String[returningAttributes.size()]));
                context.invokePostRemove(this.elementEntityClass, id);
                returnedValuesList = new ArrayList();
                for (Tuple tuple : result.getResultList()) {
                    returnedValues = tuple.toArray();
                    returnedValuesList.add(returnedValues);
                }
            } else {
                cb = evm.getCriteriaBuilderFactory().create(context.getEntityManager(), Object[].class);
                cb.from(this.elementEntityClass);
                if (id == null) {
                    cb.where(this.ownerIdAttributeName).eq(ownerId);
                } else {
                    cb.where(this.elementIdAttributeName).eq(id);
                }
                for (String attribute : returningAttributes) {
                    cb.select(attribute);
                }
                cb.select(this.elementIdAttributeName);
                returnedValuesList = new ArrayList();
                for (Object[] objects : cb.getResultList()) {
                    returnedValues = objects;
                    returnedValuesList.add(returnedValues);
                    id = returnedValues[returnedValues.length - 1];
                    this.deleteElement(context, ownerId, id);
                    context.invokePostRemove(this.elementEntityClass, id);
                }
            }
        } else {
            this.deleteElement(context, ownerId, id);
            context.invokePostRemove(this.elementEntityClass, id);
            returnedValuesList = returnedValues == null ? Collections.emptyList() : Collections.singletonList(returnedValues);
        }
        for (int i = 0; i < returnedValuesList.size(); ++i) {
            Object[] objects = (Object[])returnedValuesList.get(i);
            for (int j = 0; j < this.unmappedPostRemoveCascadeDeleters.length; ++j) {
                if (objects[j] == null) continue;
                this.unmappedPostRemoveCascadeDeleters[j].removeById(context, objects[j]);
            }
        }
    }

    private void deleteElement(UpdateContext context, Object ownerId, Object id) {
        if (this.requiresDeleteAsEntity) {
            if (id == null) {
                throw new UnsupportedOperationException("Delete by owner id should not be invoked!");
            }
            context.getEntityManager().remove(context.getEntityManager().getReference(this.elementEntityClass, id));
        } else if (id == null) {
            Query query = context.getEntityManager().createQuery(this.deleteByOwnerIdQuery);
            query.setParameter("ownerId", ownerId);
            query.executeUpdate();
        } else {
            Query query = context.getEntityManager().createQuery(this.deleteQuery);
            query.setParameter("id", id);
            query.executeUpdate();
        }
    }

    @Override
    public UnmappedAttributeCascadeDeleter createFlusherWiseDeleter() {
        return this;
    }
}

