/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.ForeignPackageMethodParameter;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;

public class ForeignPackageMethod {
    private final String name;
    private final String returnType;
    private final String realReturnType;
    private final boolean packagePrivate;
    private final boolean generic;
    private final List<ForeignPackageMethodParameter> parameters;

    public ForeignPackageMethod(MetaEntityView entity, ExecutableElement element, Context context) {
        this.name = element.getSimpleName().toString();
        this.packagePrivate = !element.getModifiers().contains((Object)Modifier.PROTECTED);
        this.realReturnType = TypeUtils.toTypeString((DeclaredType)entity.getTypeElement().asType(), element.getReturnType(), context);
        boolean isGeneric = false;
        List<? extends VariableElement> parameters = element.getParameters();
        ArrayList<ForeignPackageMethodParameter> parameterList = new ArrayList<ForeignPackageMethodParameter>(parameters.size());
        for (VariableElement variableElement : parameters) {
            isGeneric = isGeneric || variableElement.asType().getKind() == TypeKind.TYPEVAR;
            String realType = TypeUtils.toTypeString((DeclaredType)entity.getTypeElement().asType(), variableElement.asType(), context);
            String type = variableElement.asType().getKind() == TypeKind.TYPEVAR ? variableElement.asType().toString() : realType;
            parameterList.add(new ForeignPackageMethodParameter(variableElement.getSimpleName().toString(), realType, type));
        }
        this.generic = isGeneric;
        this.returnType = isGeneric ? element.getReturnType().toString() : this.realReturnType;
        this.parameters = parameterList;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getRealReturnType() {
        return this.realReturnType;
    }

    public boolean isPackagePrivate() {
        return this.packagePrivate;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public List<ForeignPackageMethodParameter> getParameters() {
        return this.parameters;
    }
}

