/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.ForeignPackageMethod;
import com.blazebit.persistence.view.processor.JavaTypeVariable;
import com.blazebit.persistence.view.processor.MetaEntityView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class ForeignPackageType {
    private final String name;
    private final String simpleName;
    private final List<JavaTypeVariable> typeVariables;
    private final List<ForeignPackageMethod> methods;

    public ForeignPackageType(MetaEntityView entity, TypeElement typeElement, Context context) {
        this.name = typeElement.getQualifiedName().toString();
        this.simpleName = typeElement.getSimpleName().toString();
        List<? extends TypeMirror> typeParameters = ((DeclaredType)typeElement.asType()).getTypeArguments();
        if (typeParameters.isEmpty()) {
            this.typeVariables = Collections.emptyList();
        } else {
            ArrayList<JavaTypeVariable> typeVariables = new ArrayList<JavaTypeVariable>(typeParameters.size());
            for (TypeVariable typeVariable : typeParameters) {
                typeVariables.add(new JavaTypeVariable(typeVariable));
            }
            this.typeVariables = typeVariables;
        }
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        ArrayList<ForeignPackageMethod> methods = new ArrayList<ForeignPackageMethod>(enclosedElements.size());
        for (Element element : enclosedElements) {
            Set<Modifier> modifiers = element.getModifiers();
            if (!(element instanceof ExecutableElement) || !modifiers.contains((Object)Modifier.ABSTRACT) || modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PRIVATE) || element.getKind() != ElementKind.METHOD) continue;
            methods.add(new ForeignPackageMethod(entity, (ExecutableElement)element, context));
        }
        this.methods = methods;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public List<JavaTypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    public List<ForeignPackageMethod> getMethods() {
        return this.methods;
    }
}

