/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import java.util.Map;
import javax.lang.model.type.TypeMirror;

public final class OptionalParameterUtils {
    private OptionalParameterUtils() {
    }

    public static void addOptionalParameters(final Map<String, String> optionalParameters, String mapping, final Context context) {
        OptionalParameterUtils.addOptionalParameters(new OptionalParameterConsumer(){

            @Override
            public void addOptionalParameter(String name, TypeMirror typeMirror) {
                if (!optionalParameters.containsKey(name)) {
                    if (typeMirror == null) {
                        typeMirror = context.getTypeElement("java.lang.Object").asType();
                    }
                    optionalParameters.put(name, typeMirror.toString());
                }
            }
        }, mapping, context);
    }

    public static void addOptionalParametersTypeElement(final Map<String, TypeMirror> optionalParameters, String mapping, final Context context) {
        OptionalParameterUtils.addOptionalParameters(new OptionalParameterConsumer(){

            @Override
            public void addOptionalParameter(String name, TypeMirror typeMirror) {
                if (!optionalParameters.containsKey(name)) {
                    if (typeMirror == null) {
                        typeMirror = context.getTypeElement("java.lang.Object").asType();
                    }
                    optionalParameters.put(name, typeMirror);
                }
            }
        }, mapping, context);
    }

    private static void addOptionalParameters(OptionalParameterConsumer optionalParameters, String mapping, Context context) {
        if (mapping == null || mapping.isEmpty()) {
            return;
        }
        int idx = -1;
        StringBuilder sb = null;
        Object objectTypeElement = null;
        while ((idx = mapping.indexOf(58, idx + 1)) != -1) {
            char c;
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.setLength(0);
            }
            for (int i = idx + 1; i < mapping.length() && Character.isJavaIdentifierPart(c = mapping.charAt(i)); ++i) {
                sb.append(c);
            }
            if (sb.length() == 0) continue;
            String name = sb.toString();
            TypeMirror existingTypeElement = context.getOptionalParameters().get(name);
            optionalParameters.addOptionalParameter(name, existingTypeElement);
        }
    }

    private static interface OptionalParameterConsumer {
        public void addOptionalParameter(String var1, TypeMirror var2);
    }
}

