/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.AttributeFilter;
import com.blazebit.persistence.view.processor.ClassWriter;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaEntityView;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import javax.tools.FileObject;

public final class RelationClassWriter
extends ClassWriter {
    public static final String RELATION_CLASS_NAME_SUFFIX = "Relation";
    private static final String NEW_LINE = System.lineSeparator();

    public RelationClassWriter(FileObject fileObject, MetaEntityView entity, Context context, Collection<Runnable> mainThreadQueue, LongAdder elapsedTime) {
        super(fileObject, entity, entity.getRelationImportContext(), context, mainThreadQueue, elapsedTime);
    }

    public static void writeFile(MetaEntityView entity, Context context, ExecutorService executorService, Collection<Runnable> mainThreadQueue, LongAdder relationTime) {
        FileObject fileObject = ClassWriter.createFile(entity.getPackageName(), entity.getSimpleName() + RELATION_CLASS_NAME_SUFFIX, context, entity.getOriginatingElements());
        if (fileObject == null) {
            return;
        }
        executorService.submit(new RelationClassWriter(fileObject, entity, context, mainThreadQueue, relationTime));
    }

    @Override
    public void generateBody(StringBuilder sb, MetaEntityView entity, Context context) {
        if (context.addGeneratedAnnotation()) {
            ClassWriter.writeGeneratedAnnotation(sb, entity.getRelationImportContext(), context);
            sb.append(NEW_LINE);
        }
        if (context.isAddSuppressWarningsAnnotation()) {
            sb.append(ClassWriter.writeSuppressWarnings());
            sb.append(NEW_LINE);
        }
        String entityViewFqcn = entity.relationImportType(entity.getQualifiedName().toString());
        sb.append("@").append(entity.relationImportType("com.blazebit.persistence.view.StaticRelation")).append("(").append(entity.relationImportType(entity.getQualifiedName())).append(".class)");
        sb.append(NEW_LINE);
        sb.append("public class ").append(entity.getSimpleName()).append(RELATION_CLASS_NAME_SUFFIX).append("<T, A extends ").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append("<?, ?>> extends ").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.AttributePathWrapper")).append("<T, ").append(entityViewFqcn).append(", ").append(entityViewFqcn).append("> {").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    public ").append(entity.getSimpleName()).append(RELATION_CLASS_NAME_SUFFIX).append("(").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.AttributePath")).append("<T, ").append(entityViewFqcn).append(", ").append(entityViewFqcn).append("> path) {").append(NEW_LINE);
        sb.append("        super(path);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        Collection<MetaAttribute> members = entity.getMembers();
        for (MetaAttribute metaMember : members) {
            if (metaMember.isSynthetic()) continue;
            if (metaMember.isSubview()) {
                String relationType = entity.relationImportType(metaMember.getGeneratedTypePrefix() + (metaMember.isMultiCollection() ? "MultiRelation" : RELATION_CLASS_NAME_SUFFIX));
                sb.append("    public ").append(relationType).append("<T, ");
                if (metaMember.isMultiCollection()) {
                    metaMember.appendElementType(sb, entity.getRelationImportContext());
                    sb.append(", ");
                }
                metaMember.appendMetamodelAttributeType(sb, entity.getRelationImportContext());
                sb.append("> ").append(metaMember.getPropertyName()).append("() {").append(NEW_LINE);
                sb.append("        ").append(relationType).append("<").append(entityViewFqcn).append(", ");
                if (metaMember.isMultiCollection()) {
                    metaMember.appendElementType(sb, entity.getRelationImportContext());
                    sb.append(", ");
                }
                metaMember.appendMetamodelAttributeType(sb, entity.getRelationImportContext());
                sb.append("> relation = ").append(entity.getSimpleName()).append("_");
                sb.append('.').append(metaMember.getPropertyName()).append(";").append(NEW_LINE);
                sb.append("        return new ").append(relationType).append("<>(relation == null ? getWrapped().<");
                if (metaMember.isMultiCollection()) {
                    sb.append(entity.relationImportType(metaMember.getModelType()));
                    sb.append(", ");
                }
                metaMember.appendElementType(sb, entity.getRelationImportContext());
                if (metaMember.isMultiCollection()) {
                    sb.append(">getMulti(\"");
                } else {
                    sb.append(">get(\"");
                }
                sb.append(metaMember.getPropertyName()).append("\") : getWrapped().get(relation));").append(NEW_LINE);
            } else {
                sb.append("    public ").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.AttributePath")).append("<T, ");
                sb.append(entity.relationImportType(metaMember.getModelType()));
                sb.append(", ");
                metaMember.appendElementType(sb, entity.getRelationImportContext());
                sb.append("> ").append(metaMember.getPropertyName()).append("() {").append(NEW_LINE);
                sb.append("        ");
                metaMember.appendMetamodelAttributeType(sb, entity.getRelationImportContext());
                sb.append(" attribute = ").append(entity.getSimpleName()).append("_");
                sb.append('.').append(metaMember.getPropertyName()).append(';').append(NEW_LINE);
                sb.append("        return attribute == null ? getWrapped().<");
                if (metaMember.isMultiCollection()) {
                    sb.append(entity.relationImportType(metaMember.getModelType()));
                    sb.append(", ");
                }
                metaMember.appendElementType(sb, entity.getRelationImportContext());
                if (metaMember.isMultiCollection()) {
                    sb.append(">getMulti(\"");
                } else {
                    sb.append(">get(\"");
                }
                sb.append(metaMember.getPropertyName()).append("\") : getWrapped().get(attribute);").append(NEW_LINE);
            }
            sb.append("    }").append(NEW_LINE);
            sb.append(NEW_LINE);
        }
        sb.append("    public A attr() {").append(NEW_LINE);
        sb.append("        return (A) getWrapped().getAttributes().get(getWrapped().getAttributes().size() - 1);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (metaMember.isSynthetic()) continue;
            for (AttributeFilter filter : metaMember.getFilters()) {
                sb.append(NEW_LINE);
                sb.append("    public ").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<T, ");
                filter.getFilterValueType().append(entity.getRelationImportContext(), sb);
                sb.append("> ").append(metaMember.getPropertyName()).append('_');
                if (filter.getName().isEmpty()) {
                    sb.append("filter");
                } else {
                    sb.append(filter.getName());
                }
                sb.append("() {").append(NEW_LINE);
                if (metaMember.isSubview()) {
                    String relationType = entity.relationImportType(metaMember.getGeneratedTypePrefix() + (metaMember.isMultiCollection() ? "MultiRelation" : RELATION_CLASS_NAME_SUFFIX));
                    sb.append("        ").append(relationType).append("<").append(entityViewFqcn).append(", ");
                    metaMember.appendMetamodelAttributeType(sb, entity.getRelationImportContext());
                    sb.append("> relation = ").append(entity.getSimpleName()).append("_");
                    sb.append('.').append(metaMember.getPropertyName()).append(";").append(NEW_LINE);
                    sb.append("        return relation == null ? new ").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<>(getWrapped().get(\"").append(metaMember.getPropertyName()).append("\"), \"").append(filter.getName()).append("\") : new ").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<>(getWrapped().get(relation), relation.").append(metaMember.getPropertyName()).append("_");
                    if (filter.getName().isEmpty()) {
                        sb.append("filter");
                    } else {
                        sb.append(filter.getName());
                    }
                    sb.append("());").append(NEW_LINE);
                } else {
                    sb.append("        ");
                    metaMember.appendMetamodelAttributeType(sb, entity.getRelationImportContext());
                    sb.append(" attribute = ").append(entity.getSimpleName()).append("_");
                    sb.append('.').append(metaMember.getPropertyName()).append(';').append(NEW_LINE);
                    sb.append("        return attribute == null ? new ").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<>(getWrapped().get(\"").append(metaMember.getPropertyName()).append("\"), \"").append(filter.getName()).append("\") : new ").append(entity.relationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<>(getWrapped().get(attribute), ").append(entity.getSimpleName()).append("_").append(".").append(metaMember.getPropertyName()).append("_");
                    if (filter.getName().isEmpty()) {
                        sb.append("filter");
                    } else {
                        sb.append(filter.getName());
                    }
                    sb.append(");").append(NEW_LINE);
                }
                sb.append("    }").append(NEW_LINE);
            }
        }
        sb.append(NEW_LINE);
        sb.append("}");
        sb.append(NEW_LINE);
    }
}

