/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

public final class TypeUtils {
    private static final Map<TypeKind, String> PRIMITIVE_WRAPPERS = new HashMap<TypeKind, String>();

    private TypeUtils() {
    }

    public static String toWrapperTypeString(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            return PRIMITIVE_WRAPPERS.get((Object)type.getKind());
        }
        return type.toString();
    }

    public static String extractClosestRealTypeAsString(TypeMirror type, Context context) {
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeMirror compositeUpperBound = ((TypeVariable)type).getUpperBound();
            return TypeUtils.extractClosestRealTypeAsString(compositeUpperBound, context);
        }
        TypeMirror erasureType = context.getTypeUtils().erasure(type);
        return TypeRenderingVisitor.toString(erasureType, context);
    }

    public static String toTypeString(DeclaredType declaredType, TypeMirror typeMirror, Context context) {
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            Element typeVarElement = ((TypeVariable)typeMirror).asElement();
            typeMirror = TypeUtils.asMemberOf(context, declaredType, typeVarElement);
        }
        return TypeRenderingVisitor.toString(typeMirror, context);
    }

    public static TypeMirror asMemberOf(Context context, DeclaredType containing, Element element) {
        Types typeUtils = context.getTypeUtils();
        return typeUtils.asMemberOf(containing, element);
    }

    public static boolean containsAnnotation(Element element, String ... annotations) {
        assert (element != null);
        assert (annotations != null);
        HashSet annotationClassNames = new HashSet();
        Collections.addAll(annotationClassNames, annotations);
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public static List<AnnotationMirror> getAnnotationMirrors(Element element, String ... annotations) {
        assert (element != null);
        assert (annotations != null);
        HashSet annotationClassNames = new HashSet();
        Collections.addAll(annotationClassNames, annotations);
        ArrayList<AnnotationMirror> found = new ArrayList<AnnotationMirror>(annotations.length);
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            found.add(annotationMirror);
        }
        return found;
    }

    public static AnnotationMirror getAnnotationMirror(Element element, String fqcn) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(fqcn)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static String getDefaultValue(TypeKind kind) {
        switch (kind) {
            case INT: {
                return "0";
            }
            case BOOLEAN: {
                return "false";
            }
            case BYTE: {
                return "(byte) 0";
            }
            case CHAR: {
                return "'\\0'";
            }
            case DOUBLE: {
                return "0D";
            }
            case FLOAT: {
                return "0F";
            }
            case LONG: {
                return "0L";
            }
            case SHORT: {
                return "(short) 0";
            }
        }
        return "null";
    }

    public static String getSimpleTypeName(TypeElement element) {
        Element parent = element.getEnclosingElement();
        if (parent.getKind() == ElementKind.PACKAGE) {
            return element.getSimpleName().toString();
        }
        StringBuilder sb = new StringBuilder();
        while (parent.getKind() != ElementKind.PACKAGE) {
            sb.insert(0, parent.getSimpleName().toString());
            parent = parent.getEnclosingElement();
        }
        sb.append(element.getSimpleName().toString());
        return sb.toString();
    }

    public static String getDerivedTypeName(TypeElement element) {
        Element parent = element.getEnclosingElement();
        if (parent.getKind() == ElementKind.PACKAGE) {
            return element.getQualifiedName().toString();
        }
        StringBuilder sb = new StringBuilder();
        while (parent.getKind() != ElementKind.PACKAGE) {
            sb.insert(0, parent.getSimpleName().toString());
            parent = parent.getEnclosingElement();
        }
        sb.insert(0, parent.toString() + ".");
        sb.append(element.getSimpleName().toString());
        return sb.toString();
    }

    public static Collection<Element> getAllMembers(TypeElement element, Context context) {
        ArrayList<? extends TypeMirror> superClasses = new ArrayList<TypeMirror>();
        superClasses.add(element.asType());
        TreeMap<String, Element> members = new TreeMap<String, Element>();
        for (int i = 0; i < superClasses.size(); ++i) {
            TypeMirror superClass = (TypeMirror)superClasses.get(i);
            Element superClassElement = ((DeclaredType)superClass).asElement();
            for (Element element2 : superClassElement.getEnclosedElements()) {
                Element old;
                String name = element2.getSimpleName().toString();
                if ("<init>".equals(name)) {
                    if (element != superClassElement) continue;
                    name = element2.toString();
                }
                if ((old = members.put(name, element2)) == null || !context.getTypeUtils().isAssignable(old.getEnclosingElement().asType(), superClass)) continue;
                members.put(name, old);
            }
            superClass = ((TypeElement)superClassElement).getSuperclass();
            if (superClass.getKind() == TypeKind.DECLARED) {
                superClasses.add(superClass);
            }
            superClasses.addAll(((TypeElement)superClassElement).getInterfaces());
        }
        return members.values();
    }

    public static <T> T getAnnotationValue(AnnotationMirror mirror, String name) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!name.equals(entry.getKey().getSimpleName().toString())) continue;
            return (T)entry.getValue().getValue();
        }
        return null;
    }

    public static String getType(Element element, Context context) {
        DeclaredType entityDeclaredType = (DeclaredType)element.asType();
        TypeElement returnedElement = (TypeElement)context.getTypeUtils().asElement(entityDeclaredType);
        return returnedElement.getQualifiedName().toString();
    }

    public static String getRealType(Element element, Context context) {
        DeclaredType entityDeclaredType = (DeclaredType)element.asType();
        if (element instanceof ExecutableElement) {
            return TypeUtils.toTypeString(entityDeclaredType, ((ExecutableElement)element).getReturnType(), context);
        }
        return TypeUtils.toTypeString(entityDeclaredType, element.asType(), context);
    }

    public static String getPackageName(Context context, Element element) {
        Element parent = element.getEnclosingElement();
        while (parent.getKind() != ElementKind.PACKAGE) {
            parent = parent.getEnclosingElement();
        }
        return parent.toString();
    }

    static {
        PRIMITIVE_WRAPPERS.put(TypeKind.CHAR, "java.lang.Character");
        PRIMITIVE_WRAPPERS.put(TypeKind.BYTE, "java.lang.Byte");
        PRIMITIVE_WRAPPERS.put(TypeKind.SHORT, "java.lang.Short");
        PRIMITIVE_WRAPPERS.put(TypeKind.INT, "java.lang.Integer");
        PRIMITIVE_WRAPPERS.put(TypeKind.LONG, "java.lang.Long");
        PRIMITIVE_WRAPPERS.put(TypeKind.BOOLEAN, "java.lang.Boolean");
        PRIMITIVE_WRAPPERS.put(TypeKind.FLOAT, "java.lang.Float");
        PRIMITIVE_WRAPPERS.put(TypeKind.DOUBLE, "java.lang.Double");
    }

    public static final class TypeRenderingVisitor
    extends SimpleTypeVisitor8<Object, Object> {
        private final Context context;
        private final StringBuilder sb = new StringBuilder();
        private final Set<TypeVariable> visitedTypeVariables = new HashSet<TypeVariable>();

        private TypeRenderingVisitor(Context context) {
            this.context = context;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static String toString(TypeMirror typeMirror, Context context) {
            if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                Element typeVariableElement = ((TypeVariable)typeMirror).asElement();
                if (typeVariableElement instanceof TypeParameterElement) {
                    TypeParameterElement typeParameter = (TypeParameterElement)typeVariableElement;
                    if (typeParameter.getEnclosingElement().getKind() != ElementKind.METHOD) return typeParameter.toString();
                    typeMirror = ((TypeVariable)typeMirror).getUpperBound();
                } else {
                    typeMirror = typeVariableElement.asType();
                }
            } else if (typeMirror instanceof IntersectionType) {
                typeMirror = ((IntersectionType)typeMirror).getBounds().get(0);
            }
            TypeRenderingVisitor typeRenderingVisitor = new TypeRenderingVisitor(context);
            typeMirror.accept(typeRenderingVisitor, null);
            return typeRenderingVisitor.sb.toString();
        }

        @Override
        public Object visitPrimitive(PrimitiveType t, Object o) {
            String primitiveTypeName = TypeRenderingVisitor.getPrimitiveTypeName(t.getKind());
            if (primitiveTypeName != null) {
                this.sb.append(primitiveTypeName);
            }
            return null;
        }

        private static String getPrimitiveTypeName(TypeKind kind) {
            switch (kind) {
                case INT: {
                    return "int";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case BYTE: {
                    return "byte";
                }
                case CHAR: {
                    return "char";
                }
                case DOUBLE: {
                    return "double";
                }
                case FLOAT: {
                    return "float";
                }
                case LONG: {
                    return "long";
                }
                case SHORT: {
                    return "short";
                }
                case VOID: {
                    return "void";
                }
            }
            return null;
        }

        @Override
        public Object visitNull(NullType t, Object o) {
            return null;
        }

        @Override
        public Object visitArray(ArrayType t, Object o) {
            t.getComponentType().accept(this, null);
            this.sb.append("[]");
            return t;
        }

        @Override
        public Object visitDeclared(DeclaredType t, Object o) {
            this.sb.append(t.asElement().toString());
            List<? extends TypeMirror> typeArguments = t.getTypeArguments();
            if (!typeArguments.isEmpty()) {
                this.sb.append('<');
                typeArguments.get(0).accept(this, null);
                for (int i = 1; i < typeArguments.size(); ++i) {
                    this.sb.append(", ");
                    typeArguments.get(i).accept(this, null);
                }
                this.sb.append('>');
            }
            return null;
        }

        @Override
        public Object visitTypeVariable(TypeVariable t, Object o) {
            Element typeVariableElement = t.asElement();
            if (typeVariableElement instanceof TypeParameterElement) {
                TypeParameterElement typeParameter = (TypeParameterElement)typeVariableElement;
                this.sb.append(typeParameter);
                if (!"java.lang.Object".equals(t.getUpperBound().toString()) && this.visitedTypeVariables.add(t)) {
                    this.sb.append(" extends ");
                    t.getUpperBound().accept(this, null);
                    this.visitedTypeVariables.remove(t);
                }
            } else {
                typeVariableElement.asType().accept(this, null);
            }
            return null;
        }

        @Override
        public Object visitWildcard(WildcardType t, Object o) {
            this.sb.append('?');
            if (t.getExtendsBound() != null) {
                this.sb.append(" extends ");
                t.getExtendsBound().accept(this, null);
            }
            if (t.getSuperBound() != null) {
                this.sb.append(" super ");
                t.getSuperBound().accept(this, null);
            }
            return null;
        }

        @Override
        public Object visitUnion(UnionType t, Object o) {
            return null;
        }

        @Override
        public Object visitIntersection(IntersectionType t, Object o) {
            List<? extends TypeMirror> bounds = t.getBounds();
            bounds.get(0).accept(this, null);
            for (int i = 0; i < bounds.size(); ++i) {
                this.sb.append(" & ");
                bounds.get(i).accept(this, null);
            }
            return null;
        }

        @Override
        public Object visitExecutable(ExecutableType t, Object o) {
            return null;
        }

        @Override
        public Object visitNoType(NoType t, Object o) {
            this.sb.append("void");
            return null;
        }
    }
}

