/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.Hibernate5LimitHandlingDialect;
import com.blazebit.persistence.integration.hibernate.Hibernate5SessionFactoryInvocationHandler;
import com.blazebit.persistence.integration.hibernate.Hibernate5SessionInvocationHandler;
import com.blazebit.persistence.integration.hibernate.JdbcCoordinatorInvocationHandler;
import com.blazebit.persistence.integration.hibernate.StatementPreparerImpl;
import com.blazebit.persistence.integration.hibernate.base.HibernateAccess;
import com.blazebit.persistence.integration.hibernate.base.HibernateExtendedQuerySupport;
import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import com.blazebit.persistence.integration.hibernate.base.ScrollableResultsIterator;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.reflection.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.ast.ParameterTranslationsImpl;
import org.hibernate.hql.internal.ast.exec.BasicExecutor;
import org.hibernate.hql.internal.ast.exec.StatementExecutor;
import org.hibernate.hql.spi.ParameterTranslations;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.hql.QueryLoader;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorImpl;
import org.hibernate.type.Type;

public class Hibernate5Access
implements HibernateAccess {
    private static final Logger LOG = Logger.getLogger(HibernateExtendedQuerySupport.class.getName());
    private static final Method DO_EXECUTE_METHOD;

    public SessionImplementor wrapSession(SessionImplementor session, DbmsDialect dbmsDialect, String[][] columns, int[] returningSqlTypes, HibernateReturningResult<?> returningResult) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        Object jdbcCoordinatorProxy = Proxy.newProxyInstance(jdbcCoordinator.getClass().getClassLoader(), new Class[]{JdbcCoordinator.class}, (InvocationHandler)new JdbcCoordinatorInvocationHandler(jdbcCoordinator, new StatementPreparerImpl(jdbcCoordinator, session.getFactory(), dbmsDialect, columns, returningSqlTypes, returningResult)));
        Object sessionProxy = Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{SessionImplementor.class, EventSource.class}, (InvocationHandler)new Hibernate5SessionInvocationHandler(session, jdbcCoordinatorProxy));
        return (SessionImplementor)sessionProxy;
    }

    public SessionFactoryImplementor wrapSessionFactory(SessionFactoryImplementor sessionFactory, DbmsDialect dbmsDialect) {
        Hibernate5LimitHandlingDialect dialectProxy = new Hibernate5LimitHandlingDialect(sessionFactory.getDialect(), dbmsDialect);
        Object sessionFactoryProxy = Proxy.newProxyInstance(sessionFactory.getClass().getClassLoader(), new Class[]{SessionFactoryImplementor.class}, (InvocationHandler)new Hibernate5SessionFactoryInvocationHandler(sessionFactory, (Object)dialectProxy));
        return (SessionFactoryImplementor)sessionFactoryProxy;
    }

    public void checkTransactionSynchStatus(SessionImplementor session) {
        TransactionCoordinator coordinator = session.getTransactionCoordinator();
        coordinator.pulse();
        if (coordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)coordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    public void afterTransaction(SessionImplementor session, boolean success) {
        TransactionCoordinator coordinator = session.getTransactionCoordinator();
        if (!session.isTransactionInProgress()) {
            session.getJdbcCoordinator().afterTransaction();
        }
        if (coordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)coordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    public List<Object[]> list(QueryLoader queryLoader, SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return queryLoader.list(sessionImplementor, queryParameters);
    }

    public int performExecuteUpdate(HQLQueryPlan queryPlan, SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return queryPlan.performExecuteUpdate(queryParameters, sessionImplementor);
    }

    public List<Object> performList(HQLQueryPlan queryPlan, SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        return queryPlan.performList(queryParameters, sessionImplementor);
    }

    public Object performStream(HQLQueryPlan queryPlan, SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        final ScrollableResults scrollableResults = queryPlan.performScroll(queryParameters, sessionImplementor);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return StreamSupport.stream(spliterator, false).onClose(new Runnable(){

            @Override
            public void run() {
                scrollableResults.close();
            }
        });
    }

    public void doExecute(StatementExecutor executor, String delete, QueryParameters parameters, SessionImplementor session, List<ParameterSpecification> parameterSpecifications) {
        try {
            DO_EXECUTE_METHOD.invoke((Object)executor, parameters, session, delete, parameterSpecifications);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public QueryParameters getQueryParameters(Query hibernateQuery, Map<String, TypedValue> namedParams) {
        return ((AbstractQueryImpl)hibernateQuery).getQueryParameters(namedParams);
    }

    public Map<String, TypedValue> getNamedParams(Query hibernateQuery) {
        return (Map)this.getField(hibernateQuery, "namedParameters");
    }

    public String expandParameterLists(SessionImplementor session, Query hibernateQuery, Map<String, TypedValue> namedParamsCopy) {
        String query = hibernateQuery.getQueryString();
        ParameterMetadata parameterMetadata = this.getParameterMetadata(hibernateQuery);
        for (Map.Entry<String, TypedValue> me : this.getNamedParamLists(hibernateQuery).entrySet()) {
            query = this.expandParameterList(session, parameterMetadata, query, me.getKey(), me.getValue(), namedParamsCopy);
        }
        return query;
    }

    private ParameterMetadata getParameterMetadata(Query hibernateQuery) {
        return (ParameterMetadata)this.getField(hibernateQuery, "parameterMetadata");
    }

    private Map<String, TypedValue> getNamedParamLists(Query hibernateQuery) {
        return (Map)this.getField(hibernateQuery, "namedParameterLists");
    }

    private String expandParameterList(SessionImplementor session, ParameterMetadata parameterMetadata, String query, String name, TypedValue typedList, Map<String, TypedValue> namedParamsCopy) {
        boolean isEnclosedInParens;
        Collection vals = (Collection)typedList.getValue();
        Dialect dialect = session.getFactory().getDialect();
        int inExprLimit = dialect.getInExpressionCountLimit();
        if (inExprLimit > 0 && vals.size() > inExprLimit) {
            LOG.warning(String.format("Dialect [%s] limits the number of elements in an IN predicate to %s entries.  However, the given parameter list [%s] contained %s entries, which will likely cause failures to execute the query in the database", dialect.getClass().getName(), inExprLimit, name, vals.size()));
        }
        Type type = typedList.getType();
        boolean isJpaPositionalParam = parameterMetadata.getNamedParameterDescriptor(name).isJpaStyle();
        String paramPrefix = isJpaPositionalParam ? "?" : ":";
        String placeholder = new StringBuilder(paramPrefix.length() + name.length()).append(paramPrefix).append(name).toString();
        if (query == null) {
            return query;
        }
        int loc = query.indexOf(placeholder);
        if (loc < 0) {
            return query;
        }
        String beforePlaceholder = query.substring(0, loc);
        String afterPlaceholder = query.substring(loc + placeholder.length());
        boolean bl = isEnclosedInParens = StringHelper.getLastNonWhitespaceCharacter((String)beforePlaceholder) == '(' && StringHelper.getFirstNonWhitespaceCharacter((String)afterPlaceholder) == ')';
        if (vals.size() == 1 && isEnclosedInParens) {
            namedParamsCopy.put(name, new TypedValue(type, vals.iterator().next()));
            return query;
        }
        StringBuilder list = new StringBuilder(16);
        Iterator iter = vals.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String alias = (isJpaPositionalParam ? 'x' + name : name) + '_' + i++ + '_';
            if (namedParamsCopy.put(alias, new TypedValue(type, iter.next())) != null) {
                throw new HibernateException("Repeated usage of alias '" + alias + "' while expanding list parameter.");
            }
            list.append(":").append(alias);
            if (!iter.hasNext()) continue;
            list.append(", ");
        }
        return StringHelper.replace((String)beforePlaceholder, (String)afterPlaceholder, (String)placeholder.toString(), (String)list.toString(), (boolean)true, (boolean)true);
    }

    private <T> T getField(Object object, String field) {
        boolean madeAccessible = false;
        Field f = null;
        try {
            f = ReflectionUtils.getField(object.getClass(), (String)field);
            boolean bl = madeAccessible = !f.isAccessible();
            if (madeAccessible) {
                f.setAccessible(true);
            }
            Object object2 = f.get(object);
            return (T)object2;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        finally {
            if (madeAccessible) {
                f.setAccessible(false);
            }
        }
    }

    private HibernateEntityManagerImplementor getEntityManager(EntityManager em) {
        return (HibernateEntityManagerImplementor)em.unwrap(EntityManager.class);
    }

    public RuntimeException convert(EntityManager em, HibernateException e) {
        return this.getEntityManager(em).convert(e);
    }

    public void handlePersistenceException(EntityManager em, PersistenceException e) {
        this.getEntityManager(em).handlePersistenceException(e);
    }

    public void throwPersistenceException(EntityManager em, HibernateException e) {
        this.getEntityManager(em).throwPersistenceException(e);
    }

    public QueryParameters createQueryParameters(Type[] positionalParameterTypes, Object[] positionalParameterValues, Map<String, TypedValue> namedParameters, LockOptions lockOptions, RowSelection rowSelection, boolean isReadOnlyInitialized, boolean readOnly, boolean cacheable, String cacheRegion, String comment, List<String> queryHints, Serializable[] collectionKeys) {
        return new QueryParameters(positionalParameterTypes, positionalParameterValues, namedParameters, lockOptions, rowSelection, isReadOnlyInitialized, readOnly, cacheable, cacheRegion, comment, queryHints, collectionKeys, null);
    }

    public ParameterTranslations createParameterTranslations(List<ParameterSpecification> queryParameterSpecifications) {
        return new ParameterTranslationsImpl(queryParameterSpecifications);
    }

    static {
        try {
            Method m = BasicExecutor.class.getDeclaredMethod("doExecute", QueryParameters.class, SessionImplementor.class, String.class, List.class);
            m.setAccessible(true);
            DO_EXECUTE_METHOD = m;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

