/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.CTE;
import com.blazebit.persistence.integration.hibernate.CustomPersisterClassResolver;
import com.blazebit.persistence.integration.hibernate.NativeTableNameFormatter;
import com.blazebit.persistence.integration.hibernate.base.Database;
import com.blazebit.persistence.integration.hibernate.base.MultiIterator;
import com.blazebit.persistence.integration.hibernate.base.SimpleDatabase;
import com.blazebit.persistence.integration.hibernate.base.TableNameFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.service.Service;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class Hibernate5Integrator
implements Integrator {
    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        StringBuilder sb;
        ArrayList<PersistentClass> invalidPolymorphicCtes = new ArrayList<PersistentClass>();
        ArrayList<String> invalidFormulaCtes = new ArrayList<String>();
        for (PersistentClass clazz : metadata.getEntityBindings()) {
            Class entityClass = clazz.getMappedClass();
            if (entityClass == null || !entityClass.isAnnotationPresent(CTE.class)) continue;
            if (clazz.isPolymorphic()) {
                invalidPolymorphicCtes.add(clazz);
            }
            Iterator iterator = clazz.getSubclassPropertyClosureIterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (!property.getValue().hasFormula()) continue;
                invalidFormulaCtes.add(clazz.getClassName() + "#" + property.getName());
            }
            clazz.getTable().setSubselect("select * from " + clazz.getJpaEntityName());
        }
        if (!invalidPolymorphicCtes.isEmpty()) {
            sb = new StringBuilder();
            sb.append("Found invalid polymorphic CTE entity definitions. CTE entities may not extend other entities:");
            for (PersistentClass invalidPolymorphicCte : invalidPolymorphicCtes) {
                sb.append("\n - ").append(invalidPolymorphicCte.getMappedClass().getName());
            }
            throw new RuntimeException(sb.toString());
        }
        if (!invalidFormulaCtes.isEmpty()) {
            sb = new StringBuilder();
            sb.append("Found uses of @Formula in CTE entity definitions. CTE entities can't use @Formula:");
            for (String invalidFormulaCte : invalidFormulaCtes) {
                sb.append("\n - ").append(invalidFormulaCte);
            }
            throw new RuntimeException(sb.toString());
        }
        serviceRegistry.locateServiceBinding(PersisterClassResolver.class).setService((Service)new CustomPersisterClassResolver());
        NativeTableNameFormatter formatter = new NativeTableNameFormatter(sessionFactory.getJdbcServices().getJdbcEnvironment().getQualifiedObjectNameFormatter());
        serviceRegistry.locateServiceBinding(Database.class).setService((Service)new SimpleDatabase(this.getTableIterator(metadata.getDatabase().getNamespaces()), sessionFactory.getDialect(), (TableNameFormatter)formatter, (Mapping)metadata));
    }

    private Iterator<Table> getTableIterator(Iterable<Namespace> namespaces) {
        ArrayList iterators = new ArrayList();
        Iterator<Namespace> namespaceIterator = namespaces.iterator();
        while (namespaceIterator.hasNext()) {
            iterators.add(namespaceIterator.next().getTables().iterator());
        }
        return new MultiIterator(iterators);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

