/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.CustomMultiTableBulkIdStrategy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.service.Service;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceBinding;
import org.jboss.jandex.IndexView;

public class Hibernate5MetadataContributor
implements MetadataContributor,
Service,
Configurable {
    private static final Logger LOG = Logger.getLogger(Hibernate5MetadataContributor.class.getName());
    private Map<String, Object> configurationValues;

    public void configure(Map configurationValues) {
        this.configurationValues = configurationValues;
    }

    public void contribute(InFlightMetadataCollector metadataCollector, IndexView jandexIndex) {
        ServiceBinding.ServiceLifecycleOwner lifecycleOwner = (ServiceBinding.ServiceLifecycleOwner)metadataCollector.getMetadataBuildingOptions().getServiceRegistry();
        lifecycleOwner.configureService(new ServiceBinding(lifecycleOwner, Hibernate5MetadataContributor.class, (Service)this));
        Object existingStrategy = this.configurationValues.get("hibernate.hql.bulk_id_strategy");
        if (existingStrategy == null) {
            JdbcServices jdbcService = (JdbcServices)metadataCollector.getMetadataBuildingOptions().getServiceRegistry().getService(JdbcServices.class);
            MultiTableBulkIdStrategy defaultMultiTableBulkIdStrategy = jdbcService.getDialect().getDefaultMultiTableBulkIdStrategy();
            this.configurationValues.put("hibernate.hql.bulk_id_strategy", new CustomMultiTableBulkIdStrategy(defaultMultiTableBulkIdStrategy));
        } else {
            LOG.warning("Can't replace hibernate.hql.bulk_id_strategy because it was overridden by the user with: " + existingStrategy);
        }
        if (metadataCollector.getEntityBinding("com.blazebit.persistence.impl.function.entity.ValuesEntity") != null) {
            return;
        }
        MetadataBuildingOptions options = metadataCollector.getMetadataBuildingOptions();
        ClassLoaderService classLoaderService = (ClassLoaderService)options.getServiceRegistry().getService(ClassLoaderService.class);
        ClassLoaderAccessImpl classLoaderAccess = new ClassLoaderAccessImpl(options.getTempClassLoader(), classLoaderService);
        MetadataBuildingContextRootImpl metadataBuildingContext = new MetadataBuildingContextRootImpl(options, (ClassLoaderAccess)classLoaderAccess, metadataCollector);
        this.addEntity("com.blazebit.persistence.impl.function.entity.ValuesEntity", (MetadataBuildingContext)metadataBuildingContext);
    }

    private void addEntity(String className, MetadataBuildingContext metadataBuildingContext) {
        try {
            MetadataBuildingOptions options = metadataBuildingContext.getBuildingOptions();
            Object reflectionManager = MetadataBuildingOptions.class.getMethod("getReflectionManager", new Class[0]).invoke((Object)options, new Object[0]);
            Method classForName = reflectionManager.getClass().getMethod("classForName", String.class);
            Object clazz = classForName.invoke(reflectionManager, className);
            HashMap<Object, InheritanceState> inheritanceStatePerClass = new HashMap<Object, InheritanceState>(1);
            InheritanceState state = (InheritanceState)InheritanceState.class.getConstructor(classForName.getReturnType(), Map.class, MetadataBuildingContext.class).newInstance(clazz, inheritanceStatePerClass, metadataBuildingContext);
            inheritanceStatePerClass.put(clazz, state);
            AnnotationBinder.class.getMethod("bindClass", classForName.getReturnType(), Map.class, MetadataBuildingContext.class).invoke(null, clazz, inheritanceStatePerClass, metadataBuildingContext);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not add entity", ex);
        }
    }
}

