/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.CustomTableBasedUpdateHandlerImpl;
import java.util.logging.Logger;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.UpdateStatement;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.TableBasedUpdateHandlerImpl;
import org.hibernate.persister.entity.AbstractEntityPersister;

public class CustomMultiTableBulkIdStrategy
implements MultiTableBulkIdStrategy {
    private static final Logger LOG = Logger.getLogger(CustomMultiTableBulkIdStrategy.class.getName());
    private final MultiTableBulkIdStrategy delegate;

    public CustomMultiTableBulkIdStrategy(MultiTableBulkIdStrategy delegate) {
        this.delegate = delegate;
    }

    public MultiTableBulkIdStrategy.UpdateHandler buildUpdateHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        MultiTableBulkIdStrategy.UpdateHandler updateHandler = this.delegate.buildUpdateHandler(factory, walker);
        UpdateStatement updateStatement = (UpdateStatement)walker.getAST();
        FromElement fromElement = updateStatement.getFromClause().getFromElement();
        AbstractEntityPersister targetedPersister = (AbstractEntityPersister)fromElement.getQueryable();
        if (targetedPersister.getConstraintOrderedTableNameClosure().length > 1) {
            if (updateHandler instanceof TableBasedUpdateHandlerImpl) {
                return new CustomTableBasedUpdateHandlerImpl((TableBasedUpdateHandlerImpl)updateHandler, walker);
            }
            LOG.warning("Unsupported update handler that can't be adapted to support updates to secondary tables: " + updateHandler);
        }
        return updateHandler;
    }

    public MultiTableBulkIdStrategy.DeleteHandler buildDeleteHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        return this.delegate.buildDeleteHandler(factory, walker);
    }

    public void prepare(JdbcServices jdbcServices, JdbcConnectionAccess connectionAccess, MetadataImplementor metadata, SessionFactoryOptions sessionFactoryOptions) {
        this.delegate.prepare(jdbcServices, connectionAccess, metadata, sessionFactoryOptions);
    }

    public void release(JdbcServices jdbcServices, JdbcConnectionAccess connectionAccess) {
        this.delegate.release(jdbcServices, connectionAccess);
    }
}

