/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import com.blazebit.persistence.integration.hibernate.base.ResultSetInvocationHandler;
import com.blazebit.persistence.spi.DbmsDialect;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class PreparedStatementInvocationHandler
implements InvocationHandler {
    private final PreparedStatement delegate;
    private final DbmsDialect dbmsDialect;
    private final Map<String, Integer> aliasIndex;
    private final HibernateReturningResult<?> returningResult;

    public PreparedStatementInvocationHandler(PreparedStatement delegate, DbmsDialect dbmsDialect, String[][] columns, HibernateReturningResult<?> returningResult) {
        this.delegate = delegate;
        this.dbmsDialect = dbmsDialect;
        this.aliasIndex = new HashMap<String, Integer>(columns.length);
        this.returningResult = returningResult;
        for (int i = 0; i < columns.length; ++i) {
            this.aliasIndex.put(columns[i][1], i + 1);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("executeQuery".equals(method.getName()) && method.getParameterTypes().length == 0) {
            HibernateReturningResult<?> result;
            ResultSet rs;
            if (this.delegate.execute()) {
                rs = this.delegate.getResultSet();
                result = this.returningResult;
            } else {
                result = null;
                this.returningResult.setUpdateCount(this.delegate.getUpdateCount());
                rs = this.dbmsDialect.extractReturningResult(this.delegate);
            }
            return Proxy.newProxyInstance(rs.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(rs, this.aliasIndex, result));
        }
        return method.invoke((Object)this.delegate, args);
    }
}

