/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.Hibernate6EntityTransactionSynchronizationStrategy;
import com.blazebit.persistence.integration.hibernate.Hibernate6JtaPlatformTransactionSynchronizationStrategy;
import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionAccessFactory;
import jakarta.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class Hibernate6TransactionAccessFactory
implements TransactionAccessFactory {
    public TransactionAccess createTransactionAccess(EntityManager entityManager) {
        try {
            return new Hibernate6EntityTransactionSynchronizationStrategy(entityManager.getTransaction(), entityManager);
        }
        catch (IllegalStateException ex) {
            JtaPlatform jtaPlatform = Hibernate6TransactionAccessFactory.getHibernateJtaPlatform(entityManager);
            return new Hibernate6JtaPlatformTransactionSynchronizationStrategy(jtaPlatform);
        }
    }

    public int getPriority() {
        return 100;
    }

    private static JtaPlatform getHibernateJtaPlatform(EntityManager em) {
        Session hibernateSession = (Session)em.unwrap(Session.class);
        SessionFactory hibernateSessionFactory = hibernateSession.getSessionFactory();
        ServiceRegistryImplementor hibernateServiceRegistry = ((SessionFactoryImplementor)hibernateSessionFactory).getServiceRegistry();
        return (JtaPlatform)hibernateServiceRegistry.getService(JtaPlatform.class);
    }
}

