/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base.function;

import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class HibernateSqmFunctionDescriptorAdapter
implements JpqlFunction {
    private static final Method GENERATE_SQM_EXPRESSION;
    private static final Constructor<QueryLiteral> QUERY_LITERAL_CONSTRUCTOR;
    private final SessionFactoryImplementor sfi;
    private final SqmFunctionDescriptor function;

    public HibernateSqmFunctionDescriptorAdapter(SessionFactoryImplementor sfi, SqmFunctionDescriptor function) {
        this.sfi = sfi;
        this.function = function;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(final Class<?> firstArgumentType) {
        ReturnableType returnableType;
        if (firstArgumentType == null) {
            return null;
        }
        Object type = this.sfi.getTypeConfiguration().getBasicTypeForJavaType(firstArgumentType);
        if (type == null) {
            final JavaType javaType = this.sfi.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(firstArgumentType);
            type = new ReturnableType<Object>(){

                public JavaType<Object> getExpressibleJavaType() {
                    return javaType;
                }

                public Class<Object> getBindableJavaType() {
                    return firstArgumentType;
                }

                public Type.PersistenceType getPersistenceType() {
                    return Type.PersistenceType.BASIC;
                }

                public Class<Object> getJavaType() {
                    return firstArgumentType;
                }
            };
        }
        ArrayList arguments = new ArrayList(1);
        arguments.add(new CustomSqmTypedNode((SqmExpressible)type));
        if (this.function instanceof AbstractSqmFunctionDescriptor && (returnableType = ((AbstractSqmFunctionDescriptor)this.function).getReturnTypeResolver().resolveFunctionReturnType(null, arguments, this.sfi.getTypeConfiguration())) != null) {
            return returnableType.getBindableJavaType();
        }
        try {
            SqmExpressible expressionType = ((SelfRenderingSqmFunction)GENERATE_SQM_EXPRESSION.invoke((Object)this.function, arguments, null, this.sfi.getQueryEngine(), this.sfi.getTypeConfiguration())).getNodeType();
            return expressionType == null ? null : expressionType.getBindableJavaType();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not generate SQM expression for function. Please report your version of hibernate so we can provide support for it!", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException("Could not generate SQM expression", e);
        }
    }

    public void render(FunctionRenderContext context) {
        throw new UnsupportedOperationException("Rendering functions through this API is not possible!");
    }

    static {
        Constructor queryLiteralConstructor;
        Method generateSqmExpression;
        try {
            generateSqmExpression = SqmFunctionDescriptor.class.getMethod("generateSqmExpression", List.class, ReturnableType.class, QueryEngine.class);
        }
        catch (NoSuchMethodException e1) {
            try {
                generateSqmExpression = SqmFunctionDescriptor.class.getMethod("generateSqmExpression", List.class, ReturnableType.class, QueryEngine.class, TypeConfiguration.class);
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException("Could not find method to generate SQM expression for functions. Please report your version of hibernate so we can provide support for it!", e1);
            }
        }
        GENERATE_SQM_EXPRESSION = generateSqmExpression;
        try {
            queryLiteralConstructor = QueryLiteral.class.getConstructor(Object.class, SqlExpressible.class);
        }
        catch (NoSuchMethodException e1) {
            try {
                queryLiteralConstructor = QueryLiteral.class.getConstructor(Object.class, BasicValuedMapping.class);
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException("Could not find constructor for QueryLiteral. Please report your version of hibernate so we can provide support for it!", e1);
            }
        }
        QUERY_LITERAL_CONSTRUCTOR = queryLiteralConstructor;
    }

    private static class CustomSqmTypedNode<T>
    implements SqmTypedNode<T>,
    SqmVisitableNode {
        private final SqmExpressible<T> type;

        private CustomSqmTypedNode(SqmExpressible<T> type) {
            this.type = type;
        }

        public <X> X accept(SemanticQueryWalker<X> walker) {
            try {
                return (X)QUERY_LITERAL_CONSTRUCTOR.newInstance(null, this.type);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public SqmTypedNode<T> copy(SqmCopyContext context) {
            return this;
        }

        public SqmExpressible<T> getNodeType() {
            return this.type;
        }

        public NodeBuilder nodeBuilder() {
            return null;
        }

        public void appendHqlString(StringBuilder sb) {
        }
    }
}

