/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.querydsl;

import com.blazebit.persistence.parser.expression.WindowFrameMode;
import com.blazebit.persistence.parser.expression.WindowFramePositionType;
import com.blazebit.persistence.querydsl.JPQLNextOps;
import com.blazebit.persistence.querydsl.WindowRows;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MutableExpressionBase;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimpleOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class WindowDefinition<Q extends WindowDefinition<Q, ?>, T>
extends MutableExpressionBase<T> {
    private static final String ORDER_BY = "order by ";
    private static final String PARTITION_BY = "partition by ";
    private static final long serialVersionUID = -7571649894320894998L;
    private final List<OrderSpecifier<?>> orderBy = new ArrayList();
    private final List<Expression<?>> partitionBy = new ArrayList();
    @Nullable
    private volatile transient SimpleExpression value;
    private String baseWindowName;
    private WindowFrameMode frameMode;
    private WindowFramePositionType frameStartType;
    private Expression<?> frameStartExpression;
    private WindowFramePositionType frameEndType;
    private Expression<?> frameEndExpression;

    public WindowDefinition(Class<? extends T> clasz) {
        super(clasz);
    }

    public WindowDefinition(Class<? extends T> clasz, String baseWindowName) {
        this(clasz);
        this.baseWindowName = baseWindowName;
    }

    public List<OrderSpecifier<?>> getOrderBy() {
        return this.orderBy;
    }

    public List<Expression<?>> getPartitionBy() {
        return this.partitionBy;
    }

    @Nullable
    public Object accept(Visitor v, @Nullable Object context) {
        return this.getValue().accept(v, context);
    }

    public Expression<T> getValue() {
        if (this.value == null) {
            JPQLNextOps windowOperator;
            ArrayList<SimpleOperation> arguments = new ArrayList<SimpleOperation>();
            if (this.baseWindowName != null) {
                SimpleOperation baseWindow = Expressions.operation(Object.class, (Operator)JPQLNextOps.WINDOW_BASE, (Expression[])new Expression[]{Expressions.constant((Object)this.baseWindowName)});
                arguments.add(baseWindow);
            }
            if (!this.partitionBy.isEmpty()) {
                SimpleOperation partitionByOperation = Expressions.operation(Object.class, (Operator)JPQLNextOps.WINDOW_PARTITION_BY, (Expression[])new Expression[]{Expressions.list((Expression[])this.partitionBy.toArray(new Expression[0]))});
                arguments.add(partitionByOperation);
            }
            if (!this.orderBy.isEmpty()) {
                Expression[] orderByTemplates = new Expression[this.orderBy.size()];
                for (int i = 0; i < this.orderBy.size(); ++i) {
                    OrderSpecifier<?> orderSpecifier = this.orderBy.get(i);
                    Object[] objectArray = new Object[3];
                    objectArray[0] = orderSpecifier.getTarget();
                    objectArray[1] = orderSpecifier.getOrder();
                    objectArray[2] = orderSpecifier.getNullHandling() != null && orderSpecifier.getNullHandling() != OrderSpecifier.NullHandling.Default ? (orderSpecifier.getNullHandling() == OrderSpecifier.NullHandling.NullsFirst ? "NULLS FIRST" : "NULLS LAST") : "";
                    orderByTemplates[i] = Expressions.template(Object.class, (String)"{0} {1s} {2s}", (Object[])objectArray);
                }
                SimpleOperation orderByOperation = Expressions.operation(Object.class, (Operator)JPQLNextOps.WINDOW_ORDER_BY, (Expression[])new Expression[]{Expressions.list((Expression[])orderByTemplates)});
                arguments.add(orderByOperation);
            }
            if (this.frameMode != null) {
                JPQLNextOps frameOperator;
                switch (this.frameMode) {
                    case RANGE: {
                        frameOperator = JPQLNextOps.WINDOW_RANGE;
                        break;
                    }
                    case ROWS: {
                        frameOperator = JPQLNextOps.WINDOW_ROWS;
                        break;
                    }
                    case GROUPS: {
                        frameOperator = JPQLNextOps.WINDOW_GROUPS;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                Operator frameStartOperator = this.getOperatorForWindowFramePositionType(this.frameStartType);
                SimpleOperation rangeClause = this.frameStartExpression != null ? Expressions.operation(Object.class, (Operator)frameStartOperator, (Expression[])new Expression[]{this.frameStartExpression}) : Expressions.operation(Object.class, (Operator)frameStartOperator, (Expression[])new Expression[0]);
                SimpleOperation frameStart = rangeClause;
                if (this.frameEndType != null) {
                    Operator frameEndOperator = this.getOperatorForWindowFramePositionType(this.frameEndType);
                    SimpleOperation frameEnd = this.frameEndExpression != null ? Expressions.operation(Object.class, (Operator)frameEndOperator, (Expression[])new Expression[]{this.frameEndExpression}) : Expressions.operation(Object.class, (Operator)frameEndOperator, (Expression[])new Expression[0]);
                    rangeClause = Expressions.operation(Object.class, (Operator)JPQLNextOps.WINDOW_BETWEEN, (Expression[])new Expression[]{frameStart, frameEnd});
                }
                SimpleOperation frameClauseOperation = Expressions.operation(Object.class, (Operator)frameOperator, (Expression[])new Expression[]{rangeClause});
                arguments.add(frameClauseOperation);
            }
            switch (arguments.size()) {
                case 1: {
                    windowOperator = JPQLNextOps.WINDOW_DEFINITION_1;
                    break;
                }
                case 2: {
                    windowOperator = JPQLNextOps.WINDOW_DEFINITION_2;
                    break;
                }
                case 3: {
                    windowOperator = JPQLNextOps.WINDOW_DEFINITION_3;
                    break;
                }
                case 4: {
                    windowOperator = JPQLNextOps.WINDOW_DEFINITION_4;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.value = Expressions.operation(Object.class, (Operator)windowOperator, (Expression[])arguments.toArray(new Expression[0]));
        }
        return this.value;
    }

    private Operator getOperatorForWindowFramePositionType(WindowFramePositionType frameStartType) {
        JPQLNextOps frameStartOperator = null;
        switch (frameStartType) {
            case UNBOUNDED_PRECEDING: {
                frameStartOperator = JPQLNextOps.WINDOW_UNBOUNDED_PRECEDING;
                break;
            }
            case BOUNDED_PRECEDING: {
                frameStartOperator = JPQLNextOps.WINDOW_PRECEDING;
                break;
            }
            case CURRENT_ROW: {
                frameStartOperator = JPQLNextOps.WINDOW_CURRENT_ROW;
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                frameStartOperator = JPQLNextOps.WINDOW_UNBOUNDED_FOLLOWING;
                break;
            }
            case BOUNDED_FOLLOWING: {
                frameStartOperator = JPQLNextOps.WINDOW_FOLLOWING;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame type " + frameStartType);
            }
        }
        return frameStartOperator;
    }

    public Q orderBy(ComparableExpressionBase<?> orderBy) {
        this.value = null;
        this.orderBy.add(orderBy.asc());
        return (Q)((Object)this);
    }

    public Q orderBy(ComparableExpressionBase<?> ... orderBy) {
        this.value = null;
        for (ComparableExpressionBase<?> e : orderBy) {
            this.orderBy.add(e.asc());
        }
        return (Q)((Object)this);
    }

    public Q orderBy(OrderSpecifier<?> orderBy) {
        this.value = null;
        this.orderBy.add(orderBy);
        return (Q)((Object)this);
    }

    public Q orderBy(OrderSpecifier<?> ... orderBy) {
        this.value = null;
        Collections.addAll(this.orderBy, orderBy);
        return (Q)((Object)this);
    }

    public Q partitionBy(Expression<?> partitionBy) {
        this.value = null;
        this.partitionBy.add(partitionBy);
        return (Q)((Object)this);
    }

    public Q partitionBy(Expression<?> ... partitionBy) {
        this.value = null;
        Collections.addAll(this.partitionBy, partitionBy);
        return (Q)((Object)this);
    }

    Q withFrame(WindowFrameMode frame, WindowFramePositionType frameStartType, Expression<?> frameStartExpression, WindowFramePositionType frameEndType, Expression<?> frameEndExpression) {
        this.frameMode = frame;
        this.frameStartType = frameStartType;
        this.frameStartExpression = frameStartExpression;
        this.frameEndType = frameEndType;
        this.frameEndExpression = frameEndExpression;
        return (Q)((Object)this);
    }

    public String getBaseWindowName() {
        return this.baseWindowName;
    }

    public WindowFrameMode getFrameMode() {
        return this.frameMode;
    }

    public WindowFramePositionType getFrameStartType() {
        return this.frameStartType;
    }

    public Expression<?> getFrameStartExpression() {
        return this.frameStartExpression;
    }

    public WindowFramePositionType getFrameEndType() {
        return this.frameEndType;
    }

    public Expression<?> getFrameEndExpression() {
        return this.frameEndExpression;
    }

    public WindowRows<Q> rows() {
        this.value = null;
        int offset = this.orderBy.size() + this.partitionBy.size() + 1;
        return new WindowRows<WindowDefinition>(this, WindowFrameMode.ROWS);
    }

    public WindowRows<Q> range() {
        this.value = null;
        int offset = this.orderBy.size() + this.partitionBy.size() + 1;
        return new WindowRows<WindowDefinition>(this, WindowFrameMode.RANGE);
    }

    public WindowRows<Q> groups() {
        this.value = null;
        int offset = this.orderBy.size() + this.partitionBy.size() + 1;
        return new WindowRows<WindowDefinition>(this, WindowFrameMode.GROUPS);
    }
}

