/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl;

import com.blazebit.persistence.BaseSubqueryBuilder;
import com.blazebit.persistence.CommonQueryBuilder;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FromBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.GroupByBuilder;
import com.blazebit.persistence.HavingBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.OrderByBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.WhereBuilder;
import com.blazebit.persistence.criteria.BlazeAbstractQuery;
import com.blazebit.persistence.criteria.BlazeCommonAbstractCriteria;
import com.blazebit.persistence.criteria.BlazeJoin;
import com.blazebit.persistence.criteria.BlazeOrder;
import com.blazebit.persistence.criteria.BlazeRoot;
import com.blazebit.persistence.criteria.BlazeSubquery;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ImplicitParameterBinding;
import com.blazebit.persistence.criteria.impl.JpaTupleObjectBuilder;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.RenderContextImpl;
import com.blazebit.persistence.criteria.impl.expression.AbstractSelection;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractJoin;
import com.blazebit.persistence.criteria.impl.path.EntityJoin;
import com.blazebit.persistence.criteria.impl.path.RootImpl;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InternalQuery<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BlazeAbstractQuery<T> owner;
    private final BlazeCriteriaBuilderImpl criteriaBuilder;
    private final boolean isSubQuery;
    private boolean distinct;
    private Selection<? extends T> selection;
    private final Set<RootImpl<?>> roots = new LinkedHashSet();
    private Set<AbstractFrom<?, ?>> correlationRoots;
    private Predicate restriction;
    private List<Expression<?>> groupList = Collections.emptyList();
    private Predicate having;
    private List<BlazeOrder> orderList = Collections.emptyList();
    private List<Subquery<?>> subqueries;

    public InternalQuery(BlazeAbstractQuery<T> owner, BlazeCriteriaBuilderImpl criteriaBuilder) {
        this.owner = owner;
        this.criteriaBuilder = criteriaBuilder;
        this.isSubQuery = owner instanceof Subquery;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    public void setSelection(Selection<? extends T> selection) {
        this.selection = selection;
    }

    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    public Set<BlazeRoot<?>> getBlazeRoots() {
        return this.roots;
    }

    public <X> BlazeRoot<X> from(Class<X> entityClass, String alias) {
        EntityType entityType = this.criteriaBuilder.getEntityMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return this.from(entityType, alias);
    }

    public <X> BlazeRoot<X> from(EntityType<X> entityType, String alias) {
        RootImpl<X> root = new RootImpl<X>(this.criteriaBuilder, entityType, alias, true);
        this.roots.add(root);
        return root;
    }

    public void addCorrelationRoot(AbstractFrom<?, ?> fromImplementor) {
        if (!this.isSubQuery) {
            throw new IllegalStateException("Query is not identified as sub-query");
        }
        if (this.correlationRoots == null) {
            this.correlationRoots = new HashSet();
        }
        this.correlationRoots.add(fromImplementor);
    }

    public Set<Join<?, ?>> collectCorrelatedJoins() {
        Set<Join<?, ?>> correlatedJoins;
        if (!this.isSubQuery) {
            throw new IllegalStateException("Query is not identified as sub-query");
        }
        if (this.correlationRoots != null) {
            correlatedJoins = new HashSet();
            for (AbstractFrom<?, ?> correlationRoot : this.correlationRoots) {
                correlatedJoins.addAll(correlationRoot.getJoins());
            }
        } else {
            correlatedJoins = Collections.emptySet();
        }
        return correlatedJoins;
    }

    public Predicate getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Predicate restriction) {
        this.restriction = restriction;
    }

    public List<Expression<?>> getGroupList() {
        return this.groupList;
    }

    public void setGroupList(List<Expression<?>> groupList) {
        this.groupList = groupList;
    }

    public Predicate getGroupRestriction() {
        return this.having;
    }

    public void setHaving(Predicate having) {
        this.having = having;
    }

    public List<BlazeOrder> getBlazeOrderList() {
        return this.orderList;
    }

    public void setBlazeOrderList(List<BlazeOrder> orderList) {
        this.orderList = orderList;
    }

    public List<Order> getOrderList() {
        return this.orderList;
    }

    public void setOrderList(List<Order> orderList) {
        this.orderList = orderList;
    }

    public Set<ParameterExpression<?>> getParameters() {
        ParameterVisitor visitor = new ParameterVisitor();
        visitor.visit(this.selection);
        visitor.visit((Selection<?>)this.restriction);
        if (this.subqueries != null) {
            for (Subquery subquery : this.subqueries) {
                visitor.visit((Selection<?>)subquery);
            }
        }
        for (RootImpl rootImpl : this.roots) {
            rootImpl.visit(visitor);
        }
        for (AbstractFrom abstractFrom : this.correlationRoots) {
            abstractFrom.visit(visitor);
        }
        visitor.visit((Selection<?>)this.having);
        if (this.groupList != null) {
            for (Expression expression : this.groupList) {
                visitor.visit((Selection<?>)expression);
            }
        }
        if (this.orderList != null) {
            for (Order order : this.orderList) {
                visitor.visit((Selection<?>)order.getExpression());
            }
        }
        return visitor.getParameters();
    }

    public List<Subquery<?>> internalGetSubqueries() {
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        return this.subqueries;
    }

    public <U> BlazeSubquery<U> subquery(Class<U> subqueryType) {
        SubqueryExpression<U> subquery = new SubqueryExpression<U>(this.criteriaBuilder, subqueryType, (BlazeCommonAbstractCriteria)this.owner);
        this.internalGetSubqueries().add(subquery);
        return subquery;
    }

    public CriteriaBuilder<T> render(CriteriaBuilder<T> cb) {
        if (this.distinct) {
            cb.distinct();
        }
        RenderContextImpl context = new RenderContextImpl();
        this.renderFrom((FromBuilder<?>)cb, context);
        List<TreatedPath<?>> treatedSelections = this.renderSelect((SelectBuilder<?>)cb, context);
        this.renderWhere((WhereBuilder<?>)cb, context, treatedSelections);
        this.renderGroupBy((GroupByBuilder<?>)cb, context);
        this.renderHaving((HavingBuilder<?>)cb, context);
        this.renderOrderBy((OrderByBuilder<?>)cb, context);
        for (ImplicitParameterBinding implicitParameterBinding : context.getImplicitParameterBindings()) {
            implicitParameterBinding.bind((CommonQueryBuilder<?>)cb);
        }
        for (Map.Entry entry : context.getExplicitParameterMapping().entrySet()) {
            cb.registerCriteriaParameter((String)entry.getValue(), (ParameterExpression)entry.getKey());
        }
        return cb;
    }

    public void renderSubquery(RenderContext context) {
        RenderContextImpl contextImpl = (RenderContextImpl)context;
        SubqueryInitiator<?> initiator = context.getSubqueryInitiator();
        SubqueryBuilder<?> cb = this.renderSubqueryFrom(initiator, contextImpl);
        if (this.distinct) {
            cb.distinct();
        }
        List<TreatedPath<?>> treatedSelections = this.renderSelect((SelectBuilder<?>)cb, contextImpl);
        this.renderWhere((WhereBuilder<?>)cb, contextImpl, treatedSelections);
        this.renderGroupBy((GroupByBuilder<?>)cb, contextImpl);
        this.renderHaving((HavingBuilder<?>)cb, contextImpl);
        this.renderOrderBy((OrderByBuilder<?>)cb, contextImpl);
        cb.end();
    }

    private List<TreatedPath<?>> renderSelect(SelectBuilder<?> cb, final RenderContextImpl context) {
        if (this.selection == null) {
            return Collections.emptyList();
        }
        final ArrayList treatedSelections = new ArrayList();
        context.setClauseType(RenderContext.ClauseType.SELECT);
        if (this.selection.isCompoundSelection()) {
            Class selectionType = this.selection.getJavaType();
            if (selectionType.isArray()) {
                for (Selection s : this.selection.getCompoundSelectionItems()) {
                    this.renderSelection(cb, context, s, treatedSelections);
                }
            } else if (Tuple.class.isAssignableFrom(selectionType)) {
                if (cb instanceof CriteriaBuilder) {
                    ((CriteriaBuilder)cb).selectNew((ObjectBuilder)new JpaTupleObjectBuilder(this.criteriaBuilder, this.selection.getCompoundSelectionItems()){

                        @Override
                        protected void renderSelection(SelectBuilder<?> cb, Selection<?> s) {
                            InternalQuery.this.renderSelection(cb, context, s, treatedSelections);
                        }
                    });
                } else {
                    for (Selection s : this.selection.getCompoundSelectionItems()) {
                        this.renderSelection(cb, context, s, treatedSelections);
                    }
                }
            } else {
                if (!(cb instanceof FullQueryBuilder)) {
                    throw new IllegalArgumentException("Invalid subquery found that uses select new!");
                }
                SelectObjectBuilder b = ((FullQueryBuilder)cb).selectNew(selectionType);
                for (Selection s : this.selection.getCompoundSelectionItems()) {
                    if (s instanceof Subquery) {
                        if (s.getAlias() != null) {
                            context.pushSubqueryInitiator(b.withSubquery(s.getAlias()));
                        } else {
                            context.pushSubqueryInitiator(b.withSubquery());
                        }
                        ((SubqueryExpression)s).renderSubquery(context);
                        context.popSubqueryInitiator();
                        continue;
                    }
                    ((AbstractSelection)s).render(context);
                    String expr = context.takeBuffer();
                    Map<String, InternalQuery<?>> aliasToSubqueries = context.takeAliasToSubqueryMap();
                    if (aliasToSubqueries.isEmpty()) {
                        if (s.getAlias() != null && !(s instanceof AbstractFrom)) {
                            b.with(expr, s.getAlias());
                            continue;
                        }
                        b.with(expr);
                        continue;
                    }
                    MultipleSubqueryInitiator initiator = s.getAlias() != null ? b.withSubqueries(expr, s.getAlias()) : b.withSubqueries(expr);
                    for (Map.Entry<String, InternalQuery<?>> subqueryEntry : aliasToSubqueries.entrySet()) {
                        context.pushSubqueryInitiator(initiator.with(subqueryEntry.getKey()));
                        subqueryEntry.getValue().renderSubquery(context);
                        context.popSubqueryInitiator();
                    }
                    initiator.end();
                }
                b.end();
            }
        } else {
            this.renderSelection(cb, context, this.selection, treatedSelections);
        }
        return treatedSelections;
    }

    private void renderSelection(SelectBuilder<?> cb, RenderContextImpl context, Selection<?> s, List<TreatedPath<?>> treatedSelections) {
        if (s instanceof Subquery) {
            if (s.getAlias() != null) {
                context.pushSubqueryInitiator(cb.selectSubquery(s.getAlias()));
            } else {
                context.pushSubqueryInitiator(cb.selectSubquery());
            }
            ((SubqueryExpression)s).renderSubquery(context);
            context.popSubqueryInitiator();
        } else {
            if (s instanceof TreatedPath) {
                TreatedPath treatedPath = (TreatedPath)s;
                treatedSelections.add(treatedPath);
                treatedPath.getTreatedPath().render(context);
            } else {
                ((AbstractSelection)s).render(context);
            }
            String expr = context.takeBuffer();
            Map<String, InternalQuery<?>> aliasToSubqueries = context.takeAliasToSubqueryMap();
            if (aliasToSubqueries.isEmpty()) {
                if (s.getAlias() != null && !(s instanceof AbstractFrom)) {
                    cb.select(expr, s.getAlias());
                } else {
                    cb.select(expr);
                }
            } else {
                MultipleSubqueryInitiator initiator = s.getAlias() != null ? cb.selectSubqueries(expr, s.getAlias()) : cb.selectSubqueries(expr);
                for (Map.Entry<String, InternalQuery<?>> subqueryEntry : aliasToSubqueries.entrySet()) {
                    context.pushSubqueryInitiator(initiator.with(subqueryEntry.getKey()));
                    subqueryEntry.getValue().renderSubquery(context);
                    context.popSubqueryInitiator();
                }
                initiator.end();
            }
        }
    }

    private void renderFrom(FromBuilder<?> cb, RenderContextImpl context) {
        context.setClauseType(RenderContext.ClauseType.FROM);
        for (RootImpl<?> r : this.roots) {
            String alias = ((AbstractFrom)r).resolveAlias(context);
            cb.from(r.getModel(), alias);
        }
        for (RootImpl<?> r : this.roots) {
            this.renderJoins(cb, context, r, true);
        }
    }

    private void renderJoins(FromBuilder<?> cb, RenderContextImpl context, AbstractFrom<?, ?> r, boolean fetching) {
        String path = r.resolveAlias(context);
        this.renderJoins(cb, null, true, context, path, r.getBlazeJoins());
        Collection<TreatedPath<?>> treatedPaths = r.getTreatedPaths();
        if (treatedPaths != null && treatedPaths.size() > 0) {
            for (TreatedPath<?> treatedPath : treatedPaths) {
                RootImpl treatedRoot = (RootImpl)((Object)treatedPath);
                String treatedParentPath = "TREAT(" + path + " AS " + treatedPath.getTreatType().getName() + ')';
                this.renderJoins(cb, null, fetching, context, treatedParentPath, treatedRoot.getBlazeJoins());
            }
        }
    }

    private SubqueryBuilder<?> renderSubqueryFrom(SubqueryInitiator<?> initiator, RenderContextImpl context) {
        String alias;
        SubqueryBuilder cb = null;
        context.setClauseType(RenderContext.ClauseType.FROM);
        for (RootImpl<?> rootImpl : this.roots) {
            alias = rootImpl.resolveAlias(context);
            if (cb == null) {
                cb = initiator.from(rootImpl.getJavaType(), alias);
                continue;
            }
            cb.from(rootImpl.getJavaType(), alias);
        }
        if (this.correlationRoots != null) {
            for (AbstractFrom abstractFrom : this.correlationRoots) {
                alias = abstractFrom.resolveAlias(context);
                Set joins = abstractFrom.getBlazeJoins();
                for (BlazeJoin j : joins) {
                    AbstractJoin join = (AbstractJoin)j;
                    String joinAlias = join.resolveAlias(context);
                    EntityType treatJoinType = join.getTreatJoinType();
                    String path = this.getPath(alias, j, treatJoinType);
                    if (j.getAttribute() != null && j.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                        cb = (SubqueryBuilder)this.renderJoins((FromBuilder<?>)cb, initiator, false, context, path, j.getBlazeJoins());
                        continue;
                    }
                    if (cb == null) {
                        cb = initiator.from(path, joinAlias);
                        continue;
                    }
                    cb.from(path, joinAlias);
                }
            }
        }
        for (RootImpl rootImpl : this.roots) {
            this.renderJoins((FromBuilder<?>)cb, context, rootImpl, false);
        }
        if (this.correlationRoots != null) {
            for (AbstractFrom abstractFrom : this.correlationRoots) {
                Set joins = abstractFrom.getBlazeJoins();
                for (BlazeJoin j : joins) {
                    if (j.getAttribute() == null || j.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) continue;
                    this.renderJoins((FromBuilder<?>)cb, context, (AbstractFrom)j, false);
                }
            }
        }
        return cb;
    }

    private FromBuilder<?> renderJoins(FromBuilder<?> cb, SubqueryInitiator<?> subqueryInitiator, boolean fetching, RenderContextImpl context, String parentPath, Set<BlazeJoin<?, ?>> joins) {
        if (joins.isEmpty()) {
            return cb;
        }
        for (BlazeJoin<?, ?> j : joins) {
            AbstractJoin join = (AbstractJoin)j;
            EntityType treatJoinType = join.getTreatJoinType();
            String alias = join.resolveAlias(context);
            String path = this.getPath(parentPath, j, treatJoinType);
            JoinOnBuilder onBuilder = null;
            if (j.getAttribute() != null && j.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                alias = path;
            } else if (j.getOn() != null) {
                if (fetching && j.isFetch()) {
                    throw new IllegalArgumentException("Fetch joining with on-condition is not allowed!" + j);
                }
                onBuilder = j instanceof EntityJoin ? cb.joinOn(path, (EntityType)j.getModel(), alias, this.getJoinType(j.getJoinType())) : cb.joinOn(path, alias, this.getJoinType(j.getJoinType()));
            } else if (fetching && j.isFetch()) {
                ((FullQueryBuilder)cb).join(path, alias, this.getJoinType(j.getJoinType()), true);
            } else {
                if (j instanceof EntityJoin) {
                    throw new IllegalArgumentException("Entity join without on-condition is not allowed! " + j);
                }
                if (cb == null) {
                    cb = subqueryInitiator.from(path, alias);
                } else if (cb instanceof BaseSubqueryBuilder && j.isCorrelated()) {
                    cb.from(path, alias);
                } else {
                    cb.join(path, alias, this.getJoinType(j.getJoinType()));
                }
            }
            if (onBuilder != null) {
                context.setClauseType(RenderContext.ClauseType.ON);
                context.getBuffer().setLength(0);
                ((AbstractSelection)j.getOn()).render(context);
                String expression = context.takeBuffer();
                Map<String, InternalQuery<?>> aliasToSubqueries = context.takeAliasToSubqueryMap();
                if (aliasToSubqueries.isEmpty()) {
                    onBuilder.setOnExpression(expression);
                } else {
                    MultipleSubqueryInitiator initiator = onBuilder.setOnExpressionSubqueries(expression);
                    for (Map.Entry<String, InternalQuery<?>> subqueryEntry : aliasToSubqueries.entrySet()) {
                        context.pushSubqueryInitiator(initiator.with(subqueryEntry.getKey()));
                        subqueryEntry.getValue().renderSubquery(context);
                        context.popSubqueryInitiator();
                    }
                    initiator.end();
                }
            }
            this.renderJoins((FromBuilder<?>)cb, null, fetching, context, alias, j.getBlazeJoins());
            Collection treatedPaths = join.getTreatedPaths();
            if (treatedPaths == null || treatedPaths.size() <= 0) continue;
            for (TreatedPath treatedPath : treatedPaths) {
                AbstractJoin treatedJoin = (AbstractJoin)((Object)treatedPath);
                String treatedParentPath = "TREAT(" + alias + " AS " + treatedPath.getTreatType().getName() + ')';
                this.renderJoins((FromBuilder<?>)cb, null, fetching, context, treatedParentPath, treatedJoin.getBlazeJoins());
            }
        }
        return cb;
    }

    private String getPath(String parentPath, BlazeJoin<?, ?> j, EntityType<?> treatJoinType) {
        if (j.getAttribute() == null) {
            return parentPath;
        }
        String path = j.getAttribute().getName();
        if (parentPath == null || parentPath.isEmpty()) {
            if (treatJoinType != null) {
                return "TREAT(" + path + " AS " + treatJoinType.getName() + ')';
            }
            return path;
        }
        if (treatJoinType != null) {
            return "TREAT(" + parentPath + "." + path + " AS " + treatJoinType.getName() + ')';
        }
        return parentPath + "." + path;
    }

    private JoinType getJoinType(jakarta.persistence.criteria.JoinType joinType) {
        switch (joinType) {
            case INNER: {
                return JoinType.INNER;
            }
            case LEFT: {
                return JoinType.LEFT;
            }
            case RIGHT: {
                return JoinType.RIGHT;
            }
        }
        throw new IllegalArgumentException("Unsupported join type: " + joinType);
    }

    private void renderWhere(WhereBuilder<?> wb, RenderContextImpl context, List<TreatedPath<?>> treatedSelections) {
        if (this.restriction == null) {
            if (!treatedSelections.isEmpty()) {
                this.renderTreatTypeRestrictions(context, treatedSelections);
                String expression = context.takeBuffer();
                wb.setWhereExpression(expression);
            }
            return;
        }
        context.setClauseType(RenderContext.ClauseType.WHERE);
        context.getBuffer().setLength(0);
        ((AbstractSelection)this.restriction).render(context);
        this.renderTreatTypeRestrictions(context, treatedSelections);
        String expression = context.takeBuffer();
        Map<String, InternalQuery<?>> aliasToSubqueries = context.takeAliasToSubqueryMap();
        if (aliasToSubqueries.isEmpty()) {
            wb.setWhereExpression(expression);
        } else {
            MultipleSubqueryInitiator initiator = wb.setWhereExpressionSubqueries(expression);
            for (Map.Entry<String, InternalQuery<?>> subqueryEntry : aliasToSubqueries.entrySet()) {
                context.pushSubqueryInitiator(initiator.with(subqueryEntry.getKey()));
                subqueryEntry.getValue().renderSubquery(context);
                context.popSubqueryInitiator();
            }
            initiator.end();
        }
    }

    private void renderTreatTypeRestrictions(RenderContextImpl context, List<TreatedPath<?>> treatedSelections) {
        StringBuilder buffer = context.getBuffer();
        boolean first = buffer.length() == 0;
        for (TreatedPath<?> p : treatedSelections) {
            if (first) {
                first = false;
            } else {
                buffer.append(" AND ");
            }
            buffer.append("TYPE(").append(p.getAlias()).append(") = ").append(p.getTreatType().getName());
        }
    }

    private void renderGroupBy(GroupByBuilder<?> gb, RenderContextImpl context) {
        if (this.groupList == null) {
            return;
        }
        context.setClauseType(RenderContext.ClauseType.GROUP_BY);
        for (Expression<?> expr : this.groupList) {
            context.getBuffer().setLength(0);
            ((AbstractSelection)expr).render(context);
            String expression = context.takeBuffer();
            Map<String, InternalQuery<?>> aliasToSubqueries = context.takeAliasToSubqueryMap();
            if (aliasToSubqueries.isEmpty()) {
                gb.groupBy(expression);
                continue;
            }
            throw new IllegalArgumentException("Subqueries are not supported in the group by clause!");
        }
    }

    private void renderHaving(HavingBuilder<?> hb, RenderContextImpl context) {
        if (this.having == null) {
            return;
        }
        context.setClauseType(RenderContext.ClauseType.HAVING);
        context.getBuffer().setLength(0);
        ((AbstractSelection)this.having).render(context);
        String expression = context.takeBuffer();
        Map<String, InternalQuery<?>> aliasToSubqueries = context.takeAliasToSubqueryMap();
        if (aliasToSubqueries.isEmpty()) {
            hb.setHavingExpression(expression);
        } else {
            MultipleSubqueryInitiator initiator = hb.setHavingExpressionSubqueries(expression);
            for (Map.Entry<String, InternalQuery<?>> subqueryEntry : aliasToSubqueries.entrySet()) {
                context.pushSubqueryInitiator(initiator.with(subqueryEntry.getKey()));
                subqueryEntry.getValue().renderSubquery(context);
                context.popSubqueryInitiator();
            }
            initiator.end();
        }
    }

    private void renderOrderBy(OrderByBuilder<?> ob, RenderContextImpl context) {
        if (this.orderList == null) {
            return;
        }
        context.setClauseType(RenderContext.ClauseType.ORDER_BY);
        for (Order order : this.orderList) {
            context.getBuffer().setLength(0);
            ((AbstractSelection)order.getExpression()).render(context);
            String expression = context.takeBuffer();
            Map<String, InternalQuery<?>> aliasToSubqueries = context.takeAliasToSubqueryMap();
            if (aliasToSubqueries.isEmpty()) {
                boolean nullsFirst = false;
                if (order instanceof BlazeOrder) {
                    nullsFirst = ((BlazeOrder)order).isNullsFirst();
                }
                ob.orderBy(expression, order.isAscending(), nullsFirst);
                continue;
            }
            throw new IllegalArgumentException("Subqueries are not supported in the order by clause!");
        }
    }
}

