/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import com.blazebit.persistence.criteria.impl.expression.AbstractSimplePredicate;
import com.blazebit.persistence.criteria.impl.path.PluralAttributePath;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;

public class MemberOfPredicate<E, C extends Collection<E>>
extends AbstractSimplePredicate {
    private static final long serialVersionUID = 1L;
    private final Expression<E> elementExpression;
    private final PluralAttributePath<C> collectionPath;

    public MemberOfPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, boolean negated, Expression<E> elementExpression, PluralAttributePath<C> collectionPath) {
        super(criteriaBuilder, negated);
        this.elementExpression = elementExpression;
        this.collectionPath = collectionPath;
    }

    @Override
    public AbstractPredicate copyNegated() {
        return new MemberOfPredicate<E, C>(this.criteriaBuilder, !this.isNegated(), this.elementExpression, this.collectionPath);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.elementExpression);
        visitor.visit(this.collectionPath);
    }

    @Override
    public void render(RenderContext context) {
        context.apply((Selection<?>)this.elementExpression);
        if (this.isNegated()) {
            context.getBuffer().append(" NOT");
        }
        context.getBuffer().append(" MEMBER OF ");
        context.apply(this.collectionPath);
    }
}

