/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;

public class QuantifiableSubqueryExpression<Y>
extends AbstractExpression<Y>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Subquery<Y> subquery;
    private final Quantor quantor;

    public QuantifiableSubqueryExpression(BlazeCriteriaBuilderImpl criteriaBuilder, Class<Y> javaType, Subquery<Y> subquery, Quantor modifier) {
        super(criteriaBuilder, javaType);
        this.subquery = subquery;
        this.quantor = modifier;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
    }

    @Override
    public void render(RenderContext context) {
        context.getBuffer().append(this.quantor.getOperator());
        context.apply((Selection<?>)this.subquery);
    }

    public static enum Quantor {
        ALL{

            @Override
            String getOperator() {
                return "ALL ";
            }
        }
        ,
        SOME{

            @Override
            String getOperator() {
                return "SOME ";
            }
        }
        ,
        ANY{

            @Override
            String getOperator() {
                return "ANY ";
            }
        };


        abstract String getOperator();
    }
}

