/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.BlazeAbstractQuery;
import com.blazebit.persistence.criteria.BlazeCollectionJoin;
import com.blazebit.persistence.criteria.BlazeCommonAbstractCriteria;
import com.blazebit.persistence.criteria.BlazeJoin;
import com.blazebit.persistence.criteria.BlazeListJoin;
import com.blazebit.persistence.criteria.BlazeMapJoin;
import com.blazebit.persistence.criteria.BlazeOrder;
import com.blazebit.persistence.criteria.BlazeRoot;
import com.blazebit.persistence.criteria.BlazeSetJoin;
import com.blazebit.persistence.criteria.BlazeSubquery;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.InternalQuery;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractJoin;
import com.blazebit.persistence.criteria.impl.path.CollectionAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.ListAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.MapAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.RootImpl;
import com.blazebit.persistence.criteria.impl.path.SetAttributeJoin;
import com.blazebit.persistence.criteria.impl.support.SubquerySupport;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.metamodel.EntityType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SubqueryExpression<T>
extends AbstractExpression<T>
implements BlazeSubquery<T>,
SubquerySupport<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BlazeCommonAbstractCriteria parent;
    private final InternalQuery<T> query;

    public SubqueryExpression(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> javaType, BlazeCommonAbstractCriteria parent) {
        super(criteriaBuilder, javaType);
        this.parent = parent;
        this.query = new InternalQuery(this, criteriaBuilder);
    }

    public BlazeAbstractQuery<?> getParent() {
        if (this.parent instanceof BlazeAbstractQuery) {
            return (BlazeAbstractQuery)this.parent;
        }
        throw new IllegalStateException("Update or delete criteria do not have a parent, but a containing query!");
    }

    public Class<T> getResultType() {
        return this.getJavaType();
    }

    public boolean isDistinct() {
        return this.query.isDistinct();
    }

    public BlazeSubquery<T> distinct(boolean distinct) {
        this.query.setDistinct(distinct);
        return this;
    }

    public BlazeSubquery<T> select(Expression<T> selection) {
        this.query.setSelection(this.criteriaBuilder.wrapSelection(selection));
        return this;
    }

    public Expression<T> getSelection() {
        return (Expression)this.query.getSelection();
    }

    public Set<Root<?>> getRoots() {
        return this.query.getRoots();
    }

    public Set<BlazeRoot<?>> getBlazeRoots() {
        return this.query.getBlazeRoots();
    }

    public <X> BlazeRoot<X> from(Class<X> entityClass) {
        return this.query.from(entityClass, null);
    }

    public <X> BlazeRoot<X> from(EntityType<X> entityType) {
        return this.query.from(entityType, null);
    }

    public <X> BlazeRoot<X> from(Class<X> entityClass, String alias) {
        return this.query.from(entityClass, alias);
    }

    public <X> BlazeRoot<X> from(EntityType<X> entityType, String alias) {
        return this.query.from(entityType, alias);
    }

    public Set<Join<?, ?>> getCorrelatedJoins() {
        return this.query.collectCorrelatedJoins();
    }

    public <Y> BlazeRoot<Y> correlate(Root<Y> source) {
        AbstractFrom correlation = ((RootImpl)source).correlateTo(this);
        this.query.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, Y> BlazeJoin<X, Y> correlate(Join<X, Y> source) {
        AbstractFrom correlation = ((AbstractJoin)source).correlateTo(this);
        this.query.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, Y> BlazeCollectionJoin<X, Y> correlate(CollectionJoin<X, Y> source) {
        AbstractJoin correlation = ((CollectionAttributeJoin)source).correlateTo(this);
        this.query.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, Y> BlazeSetJoin<X, Y> correlate(SetJoin<X, Y> source) {
        AbstractJoin correlation = ((SetAttributeJoin)source).correlateTo(this);
        this.query.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, Y> BlazeListJoin<X, Y> correlate(ListJoin<X, Y> source) {
        AbstractJoin correlation = ((ListAttributeJoin)source).correlateTo(this);
        this.query.addCorrelationRoot(correlation);
        return correlation;
    }

    public <X, K, V> BlazeMapJoin<X, K, V> correlate(MapJoin<X, K, V> source) {
        AbstractJoin correlation = ((MapAttributeJoin)source).correlateTo(this);
        this.query.addCorrelationRoot(correlation);
        return correlation;
    }

    public Predicate getRestriction() {
        return this.query.getRestriction();
    }

    public BlazeSubquery<T> where(Expression<Boolean> restriction) {
        this.query.setRestriction(restriction == null ? null : this.criteriaBuilder.wrap(restriction));
        return this;
    }

    public BlazeSubquery<T> where(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            this.query.setRestriction(null);
        } else {
            this.query.setRestriction(this.criteriaBuilder.and(restrictions));
        }
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return this.query.getGroupList();
    }

    public BlazeSubquery<T> groupBy(Expression<?> ... groupings) {
        if (groupings == null || groupings.length == 0) {
            this.query.setGroupList(Collections.EMPTY_LIST);
        } else {
            this.query.setGroupList(Arrays.asList(groupings));
        }
        return this;
    }

    public BlazeSubquery<T> groupBy(List<Expression<?>> groupings) {
        this.query.setGroupList(groupings);
        return this;
    }

    public Predicate getGroupRestriction() {
        return this.query.getGroupRestriction();
    }

    public BlazeSubquery<T> having(Expression<Boolean> restriction) {
        this.query.setHaving(this.criteriaBuilder.wrap(restriction));
        return this;
    }

    public BlazeSubquery<T> having(Predicate ... restrictions) {
        this.query.setHaving(this.criteriaBuilder.and(restrictions));
        return this;
    }

    public List<BlazeOrder> getBlazeOrderList() {
        return this.query.getBlazeOrderList();
    }

    public List<Order> getOrderList() {
        return this.query.getOrderList();
    }

    public BlazeSubquery<T> orderBy(Order ... orders) {
        if (orders == null || orders.length == 0) {
            this.query.setOrderList(Collections.EMPTY_LIST);
        } else {
            this.query.setOrderList(Arrays.asList(orders));
        }
        return this;
    }

    public BlazeSubquery<T> orderBy(BlazeOrder ... orders) {
        if (orders == null || orders.length == 0) {
            this.query.setOrderList(Collections.EMPTY_LIST);
        } else {
            this.query.setBlazeOrderList(Arrays.asList(orders));
        }
        return this;
    }

    public BlazeSubquery<T> orderBy(List<BlazeOrder> orderList) {
        this.query.setBlazeOrderList(orderList);
        return this;
    }

    public Set<ParameterExpression<?>> getParameters() {
        return this.query.getParameters();
    }

    public <U> BlazeSubquery<U> subquery(Class<U> type) {
        return this.query.subquery(type);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        for (ParameterExpression<?> param : this.query.getParameters()) {
            visitor.add(param);
        }
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        buffer.append(context.generateSubqueryAlias(this.query));
    }

    public void renderSubquery(RenderContext context) {
        this.query.renderSubquery(context);
    }

    public BlazeCommonAbstractCriteria getContainingQuery() {
        return this.parent;
    }
}

