/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression.function;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.List;

public class CoalesceFunction<T>
extends AbstractExpression<T>
implements CriteriaBuilder.Coalesce<T> {
    private static final long serialVersionUID = 1L;
    private final List<Expression<? extends T>> expressions;
    private Class<T> javaType;

    public CoalesceFunction(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> javaType) {
        super(criteriaBuilder, javaType);
        this.javaType = javaType;
        this.expressions = new ArrayList<Expression<? extends T>>();
    }

    @Override
    public Class<T> getJavaType() {
        return this.javaType;
    }

    public CriteriaBuilder.Coalesce<T> value(T value) {
        return this.value((Expression<? extends T>)this.criteriaBuilder.value(value));
    }

    public CriteriaBuilder.Coalesce<T> value(Expression<? extends T> value) {
        this.expressions.add(value);
        if (this.javaType == null) {
            this.javaType = value.getJavaType();
        }
        return this;
    }

    public List<Expression<? extends T>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        for (Expression<T> expr : this.getExpressions()) {
            visitor.visit((Selection<?>)expr);
        }
    }

    @Override
    public void render(RenderContext context) {
        List<Expression<T>> exprs = this.getExpressions();
        StringBuilder buffer = context.getBuffer();
        buffer.append("COALESCE(");
        for (int i = 0; i < exprs.size(); ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            context.apply((Selection)exprs.get(i));
        }
        buffer.append(')');
    }
}

