/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression.function;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.function.AbstractFunctionExpression;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.Arrays;
import java.util.List;

public class FunctionExpressionImpl<X>
extends AbstractFunctionExpression<X> {
    private static final long serialVersionUID = 1L;
    private final List<Expression<?>> argumentExpressions;

    public FunctionExpressionImpl(BlazeCriteriaBuilderImpl criteriaBuilder, Class<X> javaType, String functionName, Expression<?> ... argumentExpressions) {
        super(criteriaBuilder, javaType, functionName);
        this.argumentExpressions = Arrays.asList(argumentExpressions);
    }

    public List<Expression<?>> getArgumentExpressions() {
        return this.argumentExpressions;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        for (Expression<?> argument : this.getArgumentExpressions()) {
            visitor.visit((Selection<?>)argument);
        }
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        List<Expression<?>> args = this.getArgumentExpressions();
        buffer.append(this.getFunctionName()).append('(');
        for (int i = 0; i < args.size(); ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            context.apply((Selection)args.get(i));
        }
        buffer.append(')');
    }
}

