/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression.function;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.function.AbstractFunctionExpression;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;

public class SubstringFunction
extends AbstractFunctionExpression<String> {
    public static final String NAME = "SUBSTRING";
    private static final long serialVersionUID = 1L;
    private final Expression<String> value;
    private final Expression<Integer> start;
    private final Expression<Integer> length;

    public SubstringFunction(BlazeCriteriaBuilderImpl criteriaBuilder, Expression<String> value, Expression<Integer> start, Expression<Integer> length) {
        super(criteriaBuilder, String.class, NAME);
        this.value = value;
        this.start = start;
        this.length = length;
    }

    public SubstringFunction(BlazeCriteriaBuilderImpl criteriaBuilder, Expression<String> value, Expression<Integer> start) {
        this(criteriaBuilder, value, start, (Expression<Integer>)((Expression)null));
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.value);
        visitor.visit((Selection<?>)this.start);
        visitor.visit((Selection<?>)this.length);
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        buffer.append("SUBSTRING(");
        context.apply((Selection<?>)this.value);
        buffer.append(',');
        context.apply((Selection<?>)this.start);
        if (this.length != null) {
            buffer.append(',');
            context.apply((Selection<?>)this.length);
        }
        buffer.append(')');
    }
}

