/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.BlazeFetch;
import com.blazebit.persistence.criteria.BlazeFrom;
import com.blazebit.persistence.criteria.BlazeJoin;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.support.JoinSupport;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;

public abstract class AbstractJoin<Z, X>
extends AbstractFrom<Z, X>
implements BlazeJoin<Z, X>,
BlazeFetch<Z, X>,
JoinSupport<Z, X> {
    private static final long serialVersionUID = 1L;
    protected EntityType<? extends X> treatJoinType;
    private final Attribute<? super Z, ?> joinAttribute;
    private final JoinType joinType;
    private boolean fetch;
    private Predicate suppliedJoinCondition;

    protected AbstractJoin(BlazeCriteriaBuilderImpl criteriaBuilder, AbstractJoin<Z, ? super X> original, EntityType<X> treatType) {
        super(criteriaBuilder, treatType.getJavaType(), original.getBasePath());
        this.joinAttribute = original.getAttribute();
        this.joinType = original.getJoinType();
    }

    public AbstractJoin(BlazeCriteriaBuilderImpl criteriaBuilder, Class<X> javaType, AbstractPath<Z> pathSource, Attribute<? super Z, ?> joinAttribute, JoinType joinType) {
        super(criteriaBuilder, javaType, pathSource);
        this.joinAttribute = joinAttribute;
        this.joinType = joinType;
    }

    @Override
    public void visit(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.suppliedJoinCondition);
        super.visit(visitor);
    }

    @Override
    public AbstractPath<Z> getBasePath() {
        return super.getBasePath();
    }

    @Override
    public Attribute<? super Z, ?> getAttribute() {
        return this.joinAttribute;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public BlazeFrom<?, Z> getParent() {
        return (BlazeFrom)this.getBasePath();
    }

    public BlazeJoin<Z, X> fetch() {
        ((AbstractFrom)this.getBasePath()).getJoinScope().addFetch(this);
        return this;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    @Override
    public AbstractJoin<Z, X> correlateTo(SubqueryExpression<?> subquery) {
        return (AbstractJoin)super.correlateTo(subquery);
    }

    public abstract <T extends X> AbstractJoin<Z, T> treatJoin(Class<T> var1);

    protected final void setTreatType(Class<? extends X> treatType) {
        if (treatType.isAssignableFrom(this.getJavaType())) {
            return;
        }
        if (this.treatJoinType != null) {
            throw new IllegalArgumentException("Invalid multiple invocations of treat on join: " + this.getPathExpression());
        }
        this.treatJoinType = this.criteriaBuilder.getEntityMetamodel().entity(treatType);
        this.setJavaType(this.treatJoinType.getJavaType());
    }

    @Override
    public abstract <T extends X> AbstractJoin<Z, T> treatAs(Class<T> var1);

    public EntityType<? extends X> getTreatJoinType() {
        return this.treatJoinType;
    }

    protected final void onPredicates(Predicate ... restrictions) {
        this.suppliedJoinCondition = restrictions != null && restrictions.length > 0 ? this.criteriaBuilder.and(restrictions) : null;
    }

    protected final void onExpression(Expression<Boolean> restriction) {
        this.suppliedJoinCondition = this.criteriaBuilder.wrap(restriction);
    }

    public Predicate getOn() {
        return this.suppliedJoinCondition;
    }
}

