/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.BlazeExpression;
import com.blazebit.persistence.criteria.BlazePath;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import com.blazebit.persistence.criteria.impl.expression.PathTypeExpression;
import com.blazebit.persistence.criteria.impl.path.PluralAttributePath;
import com.blazebit.persistence.criteria.impl.path.SingularAttributePath;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPath<X>
extends AbstractExpression<X>
implements BlazePath<X> {
    private static final long serialVersionUID = 1L;
    private final AbstractPath<?> basePath;
    private final BlazeExpression<Class<? extends X>> typeExpression;
    private Map<String, Path<?>> attributePathCache;

    public AbstractPath(BlazeCriteriaBuilderImpl criteriaBuilder, Class<X> javaType, AbstractPath<?> basePath) {
        super(criteriaBuilder, javaType);
        this.basePath = basePath;
        this.typeExpression = new PathTypeExpression(criteriaBuilder, this.getJavaType(), this);
    }

    public AbstractPath<?> getBasePath() {
        return this.basePath;
    }

    public AbstractPath<?> getParentPath() {
        return this.getBasePath();
    }

    public abstract <T extends X> AbstractPath<T> treatAs(Class<T> var1);

    protected final <T> EntityType<T> getTreatType(Class<T> type) {
        return this.criteriaBuilder.getEntityMetamodel().entity(type);
    }

    public BlazeExpression<Class<? extends X>> type() {
        return this.typeExpression;
    }

    public abstract Attribute<?, ?> getAttribute();

    protected abstract Attribute<?, ?> findAttribute(String var1);

    protected abstract boolean isDereferencable();

    public String getPathExpression() {
        return this.getBasePath().getPathExpression() + "." + this.getAttribute().getName();
    }

    private void checkGet(Attribute<?, ?> attribute) {
        this.checkDereferenceAllowed();
        if (attribute == null) {
            throw new IllegalArgumentException("Null attribute");
        }
    }

    protected final Path<?> getAttributePath(String attributeName) {
        return this.attributePathCache == null ? null : this.attributePathCache.get(attributeName);
    }

    protected final void putAttributePath(String attributeName, Path<?> path) {
        if (this.attributePathCache == null) {
            this.attributePathCache = new HashMap();
        }
        this.attributePathCache.put(attributeName, path);
    }

    public <Y> BlazePath<Y> get(SingularAttribute<? super X, Y> attribute) {
        this.checkGet((Attribute<?, ?>)attribute);
        SingularAttributePath<Y> path = (SingularAttributePath<Y>)this.getAttributePath(attribute.getName());
        if (path == null) {
            path = new SingularAttributePath<Y>(this.criteriaBuilder, attribute.getJavaType(), this, attribute);
            this.putAttributePath(attribute.getName(), (Path<?>)path);
        }
        return path;
    }

    public <E, C extends Collection<E>> BlazeExpression<C> get(PluralAttribute<X, C, E> attribute) {
        this.checkGet((Attribute<?, ?>)attribute);
        PluralAttributePath<C> path = (PluralAttributePath<C>)this.getAttributePath(attribute.getName());
        if (path == null) {
            path = new PluralAttributePath<C>(this.criteriaBuilder, this, attribute);
            this.putAttributePath(attribute.getName(), (Path<?>)path);
        }
        return path;
    }

    public <K, V, M extends Map<K, V>> BlazeExpression<M> get(MapAttribute<X, K, V> attribute) {
        this.checkGet((Attribute<?, ?>)attribute);
        PluralAttributePath<K> path = (PluralAttributePath<K>)this.getAttributePath(attribute.getName());
        if (path == null) {
            path = new PluralAttributePath<K>(this.criteriaBuilder, this, attribute);
            this.putAttributePath(attribute.getName(), (Path<?>)path);
        }
        return path;
    }

    public <Y> BlazePath<Y> get(String attributeName) {
        this.checkDereferenceAllowed();
        Attribute<?, ?> attribute = this.getAttribute(attributeName);
        if (attribute.isCollection()) {
            PluralAttribute pluralAttribute = (PluralAttribute)attribute;
            if (PluralAttribute.CollectionType.MAP.equals((Object)pluralAttribute.getCollectionType())) {
                return (PluralAttributePath)this.get((MapAttribute<X, K, V>)((MapAttribute)pluralAttribute));
            }
            return (PluralAttributePath)this.get((PluralAttribute<X, C, E>)pluralAttribute);
        }
        return this.get((SingularAttribute<? super X, Y>)((SingularAttribute)attribute));
    }

    protected final Attribute<?, ?> getAttribute(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        Attribute<?, ?> attribute = this.findAttribute(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException("Could not find attribute '" + attributeName + "' in '" + this.getBasePath().getPathExpression() + "'");
        }
        return attribute;
    }

    public String resolveAlias(RenderContext context) {
        AbstractPath<?> base = this.getBasePath();
        if (base != null) {
            base.resolveAlias(context);
        }
        return null;
    }

    public void renderPathExpression(RenderContext context) {
        this.getBasePath().renderPathExpression(context);
        context.getBuffer().append('.').append(this.getAttribute().getName());
    }

    @Override
    public void render(RenderContext context) {
        AbstractPath<?> base = this.getBasePath();
        if (base != null) {
            base.renderPathExpression(context);
            context.getBuffer().append('.').append(this.getAttribute().getName());
        } else {
            context.getBuffer().append(this.getAttribute().getName());
        }
    }

    private void checkDereferenceAllowed() {
        if (!this.isDereferencable()) {
            throw new IllegalArgumentException("Dereferencing attributes in '" + this.getPathExpression() + "' is not allowed!");
        }
    }
}

