/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractJoin;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;

public class EntityJoin<Z, X>
extends AbstractJoin<Z, X> {
    private static final long serialVersionUID = 1L;
    private final EntityType<X> model;

    private EntityJoin(BlazeCriteriaBuilderImpl criteriaBuilder, EntityJoin<Z, ? super X> original, EntityType<X> treatType) {
        super(criteriaBuilder, original, treatType);
        this.model = treatType;
    }

    public EntityJoin(BlazeCriteriaBuilderImpl criteriaBuilder, AbstractPath<Z> pathSource, EntityType<X> entityType, JoinType joinType) {
        super(criteriaBuilder, entityType.getJavaType(), pathSource, null, joinType);
        this.model = entityType;
    }

    @Override
    public EntityJoin<Z, X> correlateTo(SubqueryExpression<?> subquery) {
        return (EntityJoin)super.correlateTo((SubqueryExpression)subquery);
    }

    @Override
    protected AbstractFrom<Z, X> createCorrelationDelegate() {
        return new EntityJoin(this.criteriaBuilder, this.getBasePath(), this.getModel(), this.getJoinType());
    }

    @Override
    protected boolean isJoinAllowed() {
        return true;
    }

    public EntityType<X> getModel() {
        if (this.treatJoinType != null) {
            return this.treatJoinType;
        }
        return this.model;
    }

    @Override
    public EntityJoin<Z, X> on(Expression<Boolean> restriction) {
        super.onExpression(restriction);
        return this;
    }

    @Override
    public EntityJoin<Z, X> on(Predicate ... restrictions) {
        super.onPredicates(restrictions);
        return this;
    }

    @Override
    public <T extends X> EntityJoin<Z, T> treatJoin(Class<T> treatType) {
        this.setTreatType(treatType);
        return this;
    }

    @Override
    public <T extends X> EntityJoin<Z, T> treatAs(Class<T> treatAsType) {
        if (treatAsType.isAssignableFrom(this.getJavaType())) {
            return this;
        }
        return this.addTreatedPath(new TreatedEntityJoin(this.criteriaBuilder, this, this.getTreatType(treatAsType)));
    }

    public static class TreatedEntityJoin<Z, X>
    extends EntityJoin<Z, X>
    implements TreatedPath<X> {
        private static final long serialVersionUID = 1L;
        private final EntityJoin<?, ? super X> treatedJoin;
        private final EntityType<X> treatType;

        public TreatedEntityJoin(BlazeCriteriaBuilderImpl criteriaBuilder, EntityJoin<Z, ? super X> treatedJoin, EntityType<X> treatType) {
            super(criteriaBuilder, treatedJoin, (EntityType)treatType);
            this.treatedJoin = treatedJoin;
            this.treatType = treatType;
        }

        @Override
        protected ManagedType<X> getManagedType() {
            return this.treatType;
        }

        @Override
        public EntityType<X> getTreatType() {
            return this.treatType;
        }

        @Override
        public AbstractPath<? super X> getTreatedPath() {
            return this.treatedJoin;
        }

        @Override
        public String getAlias() {
            return this.treatedJoin.getAlias();
        }

        @Override
        public String getPathExpression() {
            return this.getAlias();
        }

        @Override
        public void renderPathExpression(RenderContext context) {
            this.render(context);
        }

        @Override
        public void render(RenderContext context) {
            StringBuilder buffer = context.getBuffer();
            buffer.append("TREAT(").append(this.resolveAlias(context)).append(" AS ").append(this.getTreatType().getName()).append(')');
        }
    }
}

